/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.sampledb;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.birt.core.plugin.BIRTPlugin;
import org.eclipse.birt.report.data.oda.jdbc.JDBCDriverManager;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class SampledbPlugin
extends BIRTPlugin {
    private static final Logger logger;
    private static String dbDir;
    private static final String SAMPLE_DB_NAME = "BirtSample";
    private static final String SAMPLE_DB_JAR_FILE = "BirtSample.jar";
    private static final String SAMPLE_DB_HOME_DIR = "db";
    private static int startCount;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.data.oda.sampledb.SampledbPlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.report.data.oda.sampledb.SampledbPlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz2.getName());
        startCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext context) throws Exception {
        logger.info("Sampledb plugin starts up. Current startCount=" + startCount);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.data.oda.sampledb.SampledbPlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (++startCount == 1) {
                this.init();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            super.start(context);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        logger.info("Sampledb plugin stopping. Current startCount=" + startCount);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.data.oda.sampledb.SampledbPlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (startCount >= 1 && --startCount == 0) {
                this.cleanUp();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            super.stop(context);
            return;
        }
    }

    private void cleanUp() throws Exception {
        this.shutDownDatabase();
        this.removeDatabase();
        dbDir = null;
    }

    private void init() throws IOException {
        ZipEntry entry;
        if (!$assertionsDisabled && dbDir != null) {
            throw new AssertionError();
        }
        String tempDir = System.getProperty("java.io.tmpdir");
        String timeStamp = String.valueOf(System.currentTimeMillis());
        String instanceId = Integer.toHexString(((Object)((Object)this)).hashCode());
        dbDir = String.valueOf(tempDir) + "/BIRTSampleDB_" + timeStamp + "_" + instanceId;
        logger.info("Creating Sampledb database at location " + dbDir);
        new File(dbDir).mkdir();
        Bundle bundle = Platform.getBundle((String)"org.eclipse.birt.report.data.oda.sampledb");
        String dbEntryName = "db/BirtSample.jar";
        URL fileURL = bundle.getEntry(dbEntryName);
        if (fileURL == null) {
            String errMsg = "INTERNAL ERROR: SampleDB DB file not found: " + dbEntryName;
            logger.severe(errMsg);
            throw new RuntimeException(errMsg);
        }
        BufferedInputStream dbFileStream = new BufferedInputStream(fileURL.openStream());
        ZipInputStream zipStream = new ZipInputStream(dbFileStream);
        while ((entry = zipStream.getNextEntry()) != null) {
            int len;
            File entryFile = new File(dbDir, entry.getName());
            if (entry.isDirectory()) {
                entryFile.mkdir();
                continue;
            }
            FileOutputStream os = new FileOutputStream(entryFile);
            byte[] buf = new byte[4000];
            while ((len = zipStream.read(buf)) > 0) {
                ((OutputStream)os).write(buf, 0, len);
            }
            ((OutputStream)os).close();
        }
        zipStream.close();
        ((InputStream)dbFileStream).close();
    }

    public static String getDBUrl() {
        return SampledbPlugin.getDBUrl(false);
    }

    public static String getDBUrl(boolean shutdown) {
        String url = "jdbc:derby:" + dbDir + "/" + SAMPLE_DB_NAME;
        if (shutdown) {
            url = String.valueOf(url) + ";shutdown=true";
        }
        return url;
    }

    private void shutDownDatabase() {
        logger.info("Stopping Sampledb database at location " + dbDir);
        try {
            JDBCDriverManager.getInstance().getConnection("org.apache.derby.jdbc.EmbeddedDriver", SampledbPlugin.getDBUrl(true), "ClassicModels", "");
        }
        catch (Exception e) {
            logger.info("Expected exception: " + e.getLocalizedMessage());
        }
    }

    private void removeDatabase() {
        logger.info("Removing Sampledb DB directory at location " + dbDir);
        File dbDirFile = new File(dbDir);
        if (!SampledbPlugin.removeDirectory(dbDirFile)) {
            if (!$assertionsDisabled && dbDirFile == null) {
                throw new AssertionError();
            }
            dbDirFile.deleteOnExit();
            logger.info("Fail to remove one or more file in temp db directory,but it will be removed when the VM exits: " + dbDir);
        }
    }

    static boolean removeDirectory(File dir) {
        if (!($assertionsDisabled || dir != null && dir.isDirectory())) {
            throw new AssertionError();
        }
        boolean success = true;
        String[] children = dir.list();
        int i = 0;
        while (i < children.length) {
            File child = new File(dir, children[i]);
            if (child.isDirectory()) {
                if (!SampledbPlugin.removeDirectory(child)) {
                    success = false;
                }
            } else if (!child.delete()) {
                logger.info("Failed to delete temp file " + child.getAbsolutePath());
                success = false;
            }
            ++i;
        }
        if (!dir.delete()) {
            success = false;
        }
        return success;
    }
}

