/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.eclipse.cosmos.dc.management.domain.client.ManagementDomainClient;
import org.w3c.dom.Element;

public class DomainTestClient {
    private ManagementDomainClient domainClient = null;
    static DomainTestClient domainTest = new DomainTestClient();

    private EndpointReference getBrokerEpr() {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("Management Domain EPR (terminate by an empty line):");
        StringBuffer eprBuffer = new StringBuffer();
        try {
            String line;
            while (!(line = br.readLine()).trim().equals("")) {
                eprBuffer.append(line);
            }
        }
        catch (IOException ioe) {
            System.out.println("IO error trying to read broker EPR");
            return null;
        }
        try {
            Element eprElement = XmlUtils.createDocument((String)eprBuffer.toString()).getDocumentElement();
            EndpointReference epr = new EndpointReference(eprElement);
            return epr;
        }
        catch (Exception e) {
            System.err.println("Invalid EPR");
            return null;
        }
    }

    public void getBrokers() {
        EndpointReference epr = null;
        if (this.domainClient == null) {
            epr = this.getBrokerEpr();
            this.domainClient = new ManagementDomainClient(epr);
        }
        if (this.domainClient != null) {
            try {
                String[] eprs = this.domainClient.getBrokers();
                System.out.println("EPR of brokers:");
                int i = 0;
                while (i < eprs.length) {
                    System.out.println("Broker " + (i + 1) + ":");
                    System.out.println(eprs[i]);
                    ++i;
                }
            }
            catch (Exception e) {
                System.err.println("Error occurred while retrieving broker EPRs.");
            }
        }
    }

    @Deprecated
    public void getDefaultBroker() {
    }

    public void handleCommand(String commandline) {
        StringTokenizer st = new StringTokenizer(commandline);
        if (st.hasMoreTokens()) {
            String command = st.nextToken();
            if (command.equals("getBrokers")) {
                this.getBrokers();
            } else {
                DomainTestClient.printusage();
            }
        }
    }

    public static void getInput() {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        try {
            while (true) {
                System.out.print("Domain> ");
                String line = br.readLine();
                if (line.trim().equals("")) continue;
                if (!line.equals("exit")) {
                    try {
                        domainTest.handleCommand(line);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                break;
            }
        }
        catch (IOException ioe) {
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        DomainTestClient.getInput();
    }

    public static void printusage() {
        System.out.println("Commands: \ndomain getBrokers\nexit");
    }
}

