/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.QueryMetadataTransformer;
import org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.input.artifacts.IQueryServiceMetadata;
import org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.input.artifacts.IRecordType;
import org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.input.artifacts.IRecordTypeList;
import org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.input.artifacts.IRecordTypes;
import org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.input.artifacts.IServiceDescription;
import org.eclipse.cosmos.dc.mdr.client.MdrClient;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SmlMdrTestClient {
    private MdrClient mdrClient = null;
    private String mdrname = null;

    public SmlMdrTestClient(String mdrname) {
        this.mdrname = mdrname;
    }

    private EndpointReference getMDREpr() {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("EPR of SML Repository MDR (terminate by an empty line):");
        StringBuffer eprBuffer = new StringBuffer();
        try {
            String line;
            while (!(line = br.readLine()).trim().equals("")) {
                eprBuffer.append(line);
            }
        }
        catch (IOException ioe) {
            System.out.println("IO error trying to read broker EPR");
            return null;
        }
        try {
            Element eprElement = XmlUtils.createDocument((String)eprBuffer.toString()).getDocumentElement();
            EndpointReference epr = new EndpointReference(eprElement);
            return epr;
        }
        catch (Exception e) {
            System.err.println("Invalid EPR");
            return null;
        }
    }

    public void query(String queryFile) {
        EndpointReference epr = null;
        if (this.mdrClient == null) {
            epr = this.getMDREpr();
            this.mdrClient = new MdrClient(epr);
        }
        if (this.mdrClient != null) {
            try {
                Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new File(queryFile));
                Element elem = XmlUtils.getDocumentRoot((Node)doc);
                Element response = this.mdrClient.query(elem);
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer trans = tf.newTransformer();
                StringWriter sw = new StringWriter();
                trans.transform(new DOMSource(response), new StreamResult(sw));
                System.out.println("Query response:");
                System.out.println(sw.toString());
            }
            catch (Exception e) {
                System.err.println("Error occurred while executing CMDBf query.");
            }
        }
    }

    public void register() {
        EndpointReference epr = null;
        if (this.mdrClient == null) {
            epr = this.getMDREpr();
            this.mdrClient = new MdrClient(epr);
        }
        if (this.mdrClient != null) {
            try {
                this.mdrClient.register();
                System.out.println("MDR has been registered with broker.");
            }
            catch (Exception e) {
                System.err.println("Error occurred while registering MDR with broker.");
                e.printStackTrace();
                this.mdrClient = null;
            }
        }
    }

    public void getWSDL() {
        EndpointReference epr = null;
        if (this.mdrClient == null) {
            epr = this.getMDREpr();
            this.mdrClient = new MdrClient(epr);
        }
        if (this.mdrClient != null) {
            try {
                IRecordTypeList recordTypeList;
                Element result = this.mdrClient.getWSDL();
                File xmlfile = new File(String.valueOf(this.mdrname) + ".wsdl");
                XmlUtils.toFile((Node)result, (File)xmlfile);
                System.out.println("WSDL result: " + xmlfile.getAbsolutePath());
                IQueryServiceMetadata queryServiceMetadata = QueryMetadataTransformer.transform((InputStream)new FileInputStream(xmlfile));
                IServiceDescription serviceDescription = queryServiceMetadata.getServiceDescription();
                if (serviceDescription != null) {
                    System.out.println("MdrId:       " + serviceDescription.getMdrId());
                    System.out.println("Description: " + serviceDescription.getDescription());
                }
                if ((recordTypeList = queryServiceMetadata.getRecordTypeList()) != null) {
                    IRecordTypes[] recordTypes;
                    IRecordTypes[] iRecordTypesArray = recordTypes = recordTypeList.getRecordTypes();
                    int n = recordTypes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IRecordType[] recType;
                        IRecordTypes recTypes = iRecordTypesArray[n2];
                        IRecordType[] iRecordTypeArray = recType = recTypes.getRecordType();
                        int n3 = recType.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IRecordType rType = iRecordTypeArray[n4];
                            System.out.println(" RecordType: " + rType.getLocalName());
                            ++n4;
                        }
                        ++n2;
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Error occurred in getWSDL: " + e.getMessage());
            }
        }
    }

    public void handleCommand(String commandline) {
        StringTokenizer st = new StringTokenizer(commandline);
        if (st.hasMoreTokens()) {
            String command = st.nextToken();
            if (command.equals("register")) {
                this.register();
            } else if (command.equals("query")) {
                String queryFile = "";
                if (st.hasMoreElements()) {
                    queryFile = st.nextToken();
                    this.query(queryFile);
                } else {
                    this.printusage();
                }
            } else if (command.equals("getWSDL")) {
                this.getWSDL();
            } else {
                this.printusage();
            }
        }
    }

    public void printusage() {
        System.out.println("Commands: \n" + this.mdrname + " register\n" + this.mdrname + " query file_containing_CMDBf_query\n" + this.mdrname + " getWSDL\n" + "exit");
    }
}

