/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.eclipse.cosmos.common.exceptions.CosmosException;
import org.eclipse.cosmos.dc.stat.datamgr.client.StatisticalDataManagerClient;
import org.eclipse.cosmos.dc.stat.datamgr.client.StatisticalTuple;
import org.eclipse.cosmos.dc.stat.datamgr.common.DataSourceKeyset;
import org.w3c.dom.Element;

public class StatTestClient {
    public static void printusage() {
        System.out.println("Commands: \nstat getDatasourceKeyset\nstat getStatDataForSource\n");
    }

    public String GetQuotedString(StringTokenizer st) {
        String ret = null;
        String str = null;
        str = st.nextToken();
        if (str.charAt(0) != '\"') {
            return str;
        }
        ret = str.substring(1);
        while (st.hasMoreTokens()) {
            str = st.nextToken();
            if (str.charAt(str.length() - 1) == '\"') {
                ret = ret.concat(" " + str.substring(0, str.length() - 1));
                return ret;
            }
            ret = ret.concat(" " + str);
        }
        return ret;
    }

    public void handleCommand(String commandline) {
        StringTokenizer st = new StringTokenizer(commandline);
        if (st.hasMoreTokens()) {
            String command = st.nextToken();
            if (command.equals("getDatasourceKeyset")) {
                this.getDatasourceKeyset();
            } else if (command.equals("getStatDataForSource")) {
                if (st.hasMoreElements()) {
                    String dataset = this.GetQuotedString(st);
                    if (st.hasMoreElements()) {
                        String keyset = st.nextToken();
                        this.getStatDataForSource(dataset, keyset);
                    } else {
                        StatTestClient.printusage();
                    }
                } else {
                    StatTestClient.printusage();
                }
            } else {
                StatTestClient.printusage();
            }
        }
    }

    public void getStatDataForSource(String dataset, String keyset) {
        Object address = null;
        StatisticalDataManagerClient dmc = null;
        Collection sds = null;
        Iterator I = null;
        StatisticalTuple t2 = null;
        EndpointReference epr = this.getDataManagerEpr();
        dmc = new StatisticalDataManagerClient(epr);
        try {
            sds = dmc.getStatDataForSource(dataset, keyset, 0, 1000);
        }
        catch (CosmosException ex) {
            System.out.println("Request failed.");
            return;
        }
        if (sds == null) {
            System.out.println("Request failed.");
            return;
        }
        for (StatisticalTuple t2 : sds) {
            System.out.println(t2.toString());
        }
    }

    public void getDatasourceKeyset() {
        Object address = null;
        StatisticalDataManagerClient dmc = null;
        Collection ds = null;
        Iterator I = null;
        DataSourceKeyset dk2 = null;
        EndpointReference epr = this.getDataManagerEpr();
        dmc = new StatisticalDataManagerClient(epr);
        try {
            ds = dmc.getDatasourceKeyset();
        }
        catch (CosmosException ex) {
            System.out.println("Request failed.");
            return;
        }
        if (ds == null) {
            System.out.println("Request failed.");
            return;
        }
        for (DataSourceKeyset dk2 : ds) {
            System.out.println(String.valueOf(dk2.getDataSet()) + " " + dk2.getKeySet());
        }
    }

    private EndpointReference getDataManagerEpr() {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("DataManager EPR (terminate by an empty line):");
        StringBuffer eprBuffer = new StringBuffer();
        try {
            String line;
            while (!(line = br.readLine()).trim().equals("")) {
                eprBuffer.append(line);
            }
        }
        catch (IOException ioe) {
            System.out.println("IO error trying to read DataManager EPR");
            return null;
        }
        try {
            Element eprElement = XmlUtils.createDocument((String)eprBuffer.toString()).getDocumentElement();
            EndpointReference epr = new EndpointReference(eprElement);
            return epr;
        }
        catch (Exception e) {
            System.err.println("Invalid EPR");
            return null;
        }
    }
}

