/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.example.mdr.registration.internal.query;

import java.util.List;
import java.util.Map;
import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServiceException;
import org.eclipse.cosmos.dc.cmdbf.services.query.service.IRelationshipTemplateHandler;
import org.eclipse.cosmos.dc.cmdbf.services.query.service.impl.AbstractQueryHandler;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IRelationshipTemplate;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IEdges;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IQueryResult;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.QueryOutputArtifactFactory;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IInstanceId;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IItem;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IRelationship;
import org.eclipse.cosmos.example.mdr.registration.internal.core.SampleFederatingCMDB;
import org.eclipse.cosmos.example.mdr.registration.internal.core.SampleFederatingCMDBUtil;

public class CMDBRelationshipTemplateHandler
extends AbstractQueryHandler
implements IRelationshipTemplateHandler {
    public IEdges execute(IQueryResult context, IRelationshipTemplate relationshipTemplate, IItem source, IItem target) throws CMDBfServiceException {
        SampleFederatingCMDB repository = (SampleFederatingCMDB)((Object)this.getValue("org.eclipse.cosmos.example.federating.cmdb.internal.core.ISampleCMDBConstants.DATA_PROVIDER"));
        Map<IInstanceId, List<IRelationship>> relationships = repository.retrieveRelationshipBySource();
        IEdges edges = QueryOutputArtifactFactory.getInstance().createEdges(relationshipTemplate.getId());
        IInstanceId[] sourceInstanceIds = source.getInstanceIds();
        int i = 0;
        while (i < sourceInstanceIds.length) {
            List<IRelationship> relationshipList = relationships.get(sourceInstanceIds[i]);
            if (relationshipList != null) {
                int j = 0;
                int relationshipCount = relationshipList.size();
                while (j < relationshipCount) {
                    if (SampleFederatingCMDBUtil.isEqual(new IInstanceId[]{relationshipList.get(j).getTargetId()}, target.getInstanceIds(), true)) {
                        edges.addRelationship(relationshipList.get(j));
                    }
                    ++j;
                }
            }
            ++i;
        }
        return edges;
    }
}

