/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.image;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Vector;

class IOUtil {
    private IOUtil() {
    }

    static byte[] readFully(String filename) throws IOException {
        return IOUtil.readFully(new FileInputStream(filename));
    }

    static byte[] readFully(File file) throws IOException {
        return IOUtil.readFully(new FileInputStream(file));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static byte[] readFully(InputStream is) throws IOException {
        byte[] tmp;
        int size = 10000;
        int off = 0;
        byte[] ret = new byte[size];
        try {
            int got;
            while ((got = is.read(ret, off, size - off)) != -1) {
                if ((off += got) != size) continue;
                tmp = new byte[size *= 2];
                System.arraycopy(ret, 0, tmp, 0, off);
                ret = tmp;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            IOUtil.close(is);
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        IOUtil.close(is);
        if (off == size) return ret;
        tmp = new byte[off];
        System.arraycopy(ret, 0, tmp, 0, off);
        return tmp;
    }

    static Vector readText(String filename) throws IOException {
        return IOUtil.readText(new FileReader(filename));
    }

    static Vector readText(File file) throws IOException {
        return IOUtil.readText(new FileReader(file));
    }

    static Vector readText(Reader r) throws IOException {
        Vector<String> vector;
        BufferedReader br = new BufferedReader(r);
        try {
            String line;
            Vector<String> ret = new Vector<String>();
            while ((line = br.readLine()) != null) {
                ret.addElement(line.intern());
            }
            vector = ret;
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            IOUtil.close(br);
            throw throwable;
        }
        IOUtil.close(br);
        return vector;
    }

    static void writeText(Vector lines, String filename) throws IOException {
        IOUtil.writeText(lines, new FileWriter(filename));
    }

    static void writeText(Vector lines, File file) throws IOException {
        IOUtil.writeText(lines, new FileWriter(file));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void writeText(Vector lines, Writer out) throws IOException {
        BufferedWriter bw = new BufferedWriter(out);
        try {
            int l = lines.size();
            int i = 0;
            while (i < l) {
                bw.write((String)lines.elementAt(i));
                bw.newLine();
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            IOUtil.close(bw);
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        IOUtil.close(bw);
    }

    static void close(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    static void close(OutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    static void close(Reader in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    static void close(Writer out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }
}

