/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.mdr.registration;

import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.WsaConstants;
import org.apache.muse.ws.dm.muws.MuwsConstants;
import org.eclipse.cosmos.dc.broker.client.BrokerClient;
import org.eclipse.cosmos.dc.cmdbf.services.common.INotificationHandlerFactory;
import org.eclipse.cosmos.dc.cmdbf.services.deregistration.service.ICMDBfDeregistrationOperation;
import org.eclipse.cosmos.dc.cmdbf.services.deregistration.service.impl.CMDBfDeregistrationOperation;
import org.eclipse.cosmos.dc.cmdbf.services.deregistration.transform.DeregistrationInputTransformer;
import org.eclipse.cosmos.dc.cmdbf.services.deregistration.transform.DeregistrationOutputTransformer;
import org.eclipse.cosmos.dc.cmdbf.services.deregistration.transform.input.artifacts.DeregisterInputArtifactFactory;
import org.eclipse.cosmos.dc.cmdbf.services.deregistration.transform.input.artifacts.IDeregisterInputArtifactFactory;
import org.eclipse.cosmos.dc.cmdbf.services.deregistration.transform.input.artifacts.IDeregisterRequest;
import org.eclipse.cosmos.dc.cmdbf.services.deregistration.transform.output.artifacts.IDeregisterResponse;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.QueryOutputTransformer;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IQueryResult;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IQueryServiceElementCollection;
import org.eclipse.cosmos.dc.cmdbf.services.registration.service.ICMDBfRegistrationOperation;
import org.eclipse.cosmos.dc.cmdbf.services.registration.service.impl.CMDBfRegistrationOperation;
import org.eclipse.cosmos.dc.cmdbf.services.registration.transform.RegistrationInputTransformer;
import org.eclipse.cosmos.dc.cmdbf.services.registration.transform.RegistrationOutputTransformer;
import org.eclipse.cosmos.dc.cmdbf.services.registration.transform.input.artifacts.IRegisterRequest;
import org.eclipse.cosmos.dc.cmdbf.services.registration.transform.input.artifacts.IRequest;
import org.eclipse.cosmos.dc.cmdbf.services.registration.transform.input.artifacts.RegisterInputArtifactFactory;
import org.eclipse.cosmos.dc.cmdbf.services.registration.transform.output.artifacts.IRegisterResponse;
import org.eclipse.cosmos.dc.cmdbf.services.transform.TransformerException;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IGraphElement;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IInstanceId;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IItem;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IRelationship;
import org.eclipse.cosmos.dc.management.domain.client.ManagementDomainClient;
import org.eclipse.cosmos.dc.mdr.client.MdrClient;
import org.eclipse.cosmos.dc.mdr.exception.CMDBfException;
import org.eclipse.cosmos.dc.mdr.impl.AbstractMdr;
import org.eclipse.cosmos.dc.mdr.registration.common.IFederatingCMDB;
import org.eclipse.cosmos.dc.mdr.registration.common.internal.EndPointReferenceSerializer;
import org.eclipse.cosmos.dc.mdr.registration.common.internal.MDRIdentifierSerializer;
import org.eclipse.cosmos.dc.mdr.registration.common.internal.SelectiveRegistrationInputSerializer;
import org.eclipse.cosmos.dc.mdr.registration.common.internal.SerializerUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractFederatingCMDB
extends AbstractMdr
implements IFederatingCMDB {
    private ICMDBfRegistrationOperation registrationOperation;
    private ICMDBfDeregistrationOperation deregistrationOperation;

    public AbstractFederatingCMDB() {
        INotificationHandlerFactory factory = this.getNotificationHandlerFactory();
        this.registrationOperation = new CMDBfRegistrationOperation(factory, null);
        this.deregistrationOperation = new CMDBfDeregistrationOperation(factory, null);
    }

    public abstract INotificationHandlerFactory getNotificationHandlerFactory();

    public Element register(Element registrationRequest) throws CMDBfException {
        return this.register(this.toInputStream(registrationRequest, "registerRequest"));
    }

    private Element register(InputStream registrationRequest) throws CMDBfException {
        try {
            IRegisterResponse result = this.getRegistrationOperation().execute(registrationRequest);
            InputStream output = RegistrationOutputTransformer.transform((IRegisterResponse)result);
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(output).getDocumentElement();
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    public Element registerMDREntries(Element mdrReferences) throws CMDBfException {
        return this.registerMDREntries(EndPointReferenceSerializer.getInstance().fromXML(mdrReferences));
    }

    private Element registerMDREntries(EndPointReferenceSerializer.MDRReference[] mdrIdentifiers) throws CMDBfException {
        try {
            InputStream is = AbstractFederatingCMDB.class.getClassLoader().getResourceAsStream("query-all.txt");
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(is);
            Element queryRequest = XmlUtils.getDocumentRoot((Node)document);
            return this.registerSelectiveMDREntries(mdrIdentifiers, queryRequest);
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    public Element registerSelectiveMDREntries(Element selectiveRegistration) throws CMDBfException {
        SelectiveRegistrationInputSerializer.SelectiveRegistrationRequest request = SelectiveRegistrationInputSerializer.getInstance().fromXML(selectiveRegistration);
        return this.registerSelectiveMDREntries(request.getMDRReferences(), request.getQuery());
    }

    private Element registerSelectiveMDREntries(EndPointReferenceSerializer.MDRReference[] mdrIdentifiers, Element queryRequest) throws CMDBfException {
        String currentMDRId = null;
        try {
            IRegisterRequest registerRequest = RegisterInputArtifactFactory.getInstance().createRegisterRequest();
            int i = 0;
            while (i < mdrIdentifiers.length) {
                MdrClient mdrClient;
                Element queryResponse;
                EndpointReference epr = mdrIdentifiers[i].getEpr();
                if (epr == null) {
                    epr = new EndpointReference(new URI(mdrIdentifiers[i].getEndPointReferenceURI()));
                    epr.addParameter(WsaConstants.DEFAULT_RESOURCE_ID_QNAME, (Object)mdrIdentifiers[i].getDefaultResourceId());
                }
                if ((queryResponse = (mdrClient = new MdrClient(epr)).query(queryRequest)) != null) {
                    this.createRegisterRequest(registerRequest, queryResponse);
                }
                ++i;
            }
            registerRequest.setMdrId(new URI(""));
            return this.register(RegistrationInputTransformer.transform((IRegisterRequest)registerRequest));
        }
        catch (Exception e) {
            System.err.println("There was an error handling the registration for MDR: " + currentMDRId);
            e.printStackTrace();
            throw new CMDBfException("There was an error handling the registration request", (Throwable)e);
        }
    }

    public Element registerAll(Element managementDomainEPR) throws CMDBfException {
        try {
            String mgtDomainEPR;
            Element rootNode = SerializerUtil.findNode((Element)managementDomainEPR, (String)"managementDomain");
            String string = mgtDomainEPR = rootNode == null ? null : rootNode.getTextContent();
            if (mgtDomainEPR == null) {
                throw new CMDBfException("The argument representing a management domain EPR is invalid");
            }
            ManagementDomainClient managementDomainClient = new ManagementDomainClient(new EndpointReference(new URI(mgtDomainEPR)));
            String[] brokers = managementDomainClient.getBrokers();
            ArrayList<EndPointReferenceSerializer.MDRReference> mdrEndPoints = new ArrayList<EndPointReferenceSerializer.MDRReference>();
            int i = 0;
            while (i < brokers.length) {
                BrokerClient brokerClient = new BrokerClient(new EndpointReference(XmlUtils.createDocument((String)brokers[i]).getDocumentElement()));
                String[] endPoints = brokerClient.getServices(MuwsConstants.MANAGEABILITY_CAPABILITY_QNAME, "http://www.eclipse.org/cosmos/mdrquery");
                int j = 0;
                while (j < endPoints.length) {
                    EndPointReferenceSerializer.MDRReference entry = new EndPointReferenceSerializer.MDRReference(new EndpointReference(XmlUtils.createDocument((String)endPoints[j]).getDocumentElement()));
                    mdrEndPoints.add(entry);
                    ++j;
                }
                ++i;
            }
            return this.registerMDREntries(mdrEndPoints.toArray(new EndPointReferenceSerializer.MDRReference[mdrEndPoints.size()]));
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    private void createRegisterRequest(IRegisterRequest registerRequest, Element queryResponse) throws CMDBfException, TransformerException {
        InputStream inputStream = this.toInputStream(this.cleanseResponse(queryResponse));
        IQueryResult queryResult = QueryOutputTransformer.transform((InputStream)inputStream);
        this.addCollection((IQueryServiceElementCollection[])queryResult.getAllNodes(), (IRequest)registerRequest, true);
        this.addCollection((IQueryServiceElementCollection[])queryResult.getAllEdges(), (IRequest)registerRequest, false);
    }

    private Element cleanseResponse(Element queryResponse) {
        Element cleansedRoot = XmlUtils.createElement((QName)new QName("http://cmdbf.org/schema/1-0-0/datamodel", "queryResult", "cmdbf"));
        Document document = cleansedRoot.getOwnerDocument();
        NodeList children = queryResponse.getChildNodes();
        int counter = 0;
        int i = 0;
        int childCount = children.getLength();
        while (i < childCount) {
            Node child = children.item(counter);
            Node adoptedNode = document.adoptNode(child);
            if (adoptedNode == null) {
                adoptedNode = document.importNode(child, true);
                ++counter;
            }
            cleansedRoot.appendChild(adoptedNode);
            ++i;
        }
        return cleansedRoot;
    }

    private void addCollection(IQueryServiceElementCollection[] collection, IRequest registerRequest, boolean isNode) {
        int i = 0;
        while (i < collection.length) {
            IGraphElement[] graphElements = collection[i].getElements();
            int j = 0;
            while (j < graphElements.length) {
                if (isNode) {
                    registerRequest.addItem((IItem)graphElements[j]);
                } else {
                    registerRequest.addRelationship((IRelationship)graphElements[j]);
                }
                ++j;
            }
            ++i;
        }
    }

    public Element deregister(Element deregistrationRequest) throws CMDBfException {
        return this.processDeregisterRequest(deregistrationRequest);
    }

    public Element deregisterMDREntries(Element mdrReferences) throws CMDBfException {
        String[] mdrIds = MDRIdentifierSerializer.getInstance().fromXML(mdrReferences);
        IDeregisterInputArtifactFactory artifactFactory = DeregisterInputArtifactFactory.getInstance();
        IDeregisterRequest deregisterRequest = artifactFactory.createDeregisterRequest();
        try {
            deregisterRequest.setMdrId(new URI(""));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        int i = 0;
        while (i < mdrIds.length) {
            IInstanceId instanceId = artifactFactory.createInstanceId();
            instanceId.setMdrId(mdrIds[i]);
            instanceId.setLocalId("*");
            IItem item = artifactFactory.createItem();
            item.addInstanceId(instanceId);
            IRelationship relationship = artifactFactory.createRelationship();
            relationship.addInstanceId(instanceId);
            deregisterRequest.addItem(item);
            deregisterRequest.addRelationship(relationship);
            ++i;
        }
        return this.processDeregisterRequest(DeregistrationInputTransformer.transform((IDeregisterRequest)deregisterRequest));
    }

    public Element deregisterSelectiveEntries(Element queryRequest) throws CMDBfException {
        try {
            IQueryResult queryResult = this.getQueryOperation().execute(this.toInputStream(SerializerUtil.findNode((Element)queryRequest, (String)"query")));
            IDeregisterRequest request = DeregisterInputArtifactFactory.getInstance().createDeregisterRequest();
            this.addCollection((IQueryServiceElementCollection[])queryResult.getAllNodes(), (IRequest)request, true);
            this.addCollection((IQueryServiceElementCollection[])queryResult.getAllEdges(), (IRequest)request, true);
            request.setMdrId(new URI(""));
            return this.processDeregisterRequest(DeregistrationInputTransformer.transform((IDeregisterRequest)request));
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    public Element deregisterAll() throws CMDBfException {
        IDeregisterInputArtifactFactory artifactFactory = DeregisterInputArtifactFactory.getInstance();
        IDeregisterRequest request = artifactFactory.createDeregisterRequest();
        try {
            request.setMdrId(new URI(""));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
        IInstanceId instanceId = artifactFactory.createInstanceId();
        instanceId.setMdrId("*");
        instanceId.setLocalId("*");
        IItem item = artifactFactory.createItem();
        item.addInstanceId(instanceId);
        request.addItem(item);
        IRelationship relationship = artifactFactory.createRelationship();
        relationship.addInstanceId(instanceId);
        request.addRelationship(relationship);
        return this.processDeregisterRequest(DeregistrationInputTransformer.transform((IDeregisterRequest)request));
    }

    protected ICMDBfRegistrationOperation getRegistrationOperation() {
        return this.registrationOperation;
    }

    protected void setRegistrationOperation(ICMDBfRegistrationOperation registrationOperation) {
        this.registrationOperation = registrationOperation;
    }

    protected ICMDBfDeregistrationOperation getDeregistrationOperation() {
        return this.deregistrationOperation;
    }

    protected void setDeregistrationOperation(ICMDBfDeregistrationOperation deregistrationOperation) {
        this.deregistrationOperation = deregistrationOperation;
    }

    private void handleException(Exception e) throws CMDBfException {
        if (e instanceof CMDBfException) {
            throw (CMDBfException)e;
        }
        e.printStackTrace();
        throw new CMDBfException((Throwable)e);
    }

    private Element processDeregisterRequest(Object deregistrationRequest) throws CMDBfException {
        try {
            InputStream request = deregistrationRequest instanceof Element ? this.toInputStream((Element)deregistrationRequest, "deregisterRequest") : (InputStream)deregistrationRequest;
            IDeregisterResponse result = this.getDeregistrationOperation().execute(request);
            InputStream output = DeregistrationOutputTransformer.transform((IDeregisterResponse)result);
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(output).getDocumentElement();
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }
}

