/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.management.provisional.wsdm.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.apache.muse.core.routing.MessageHandler;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.dm.muws.impl.AbstractManageabilityCapability;
import org.apache.muse.ws.resource.basefaults.BaseFault;
import org.eclipse.cosmos.me.management.common.info.ManagedAttributeInfo;
import org.eclipse.cosmos.me.management.common.info.ManagedOperationInfo;
import org.eclipse.cosmos.me.management.common.info.ManagedResourceInfo;
import org.eclipse.cosmos.me.management.common.util.ManagementProxy;
import org.eclipse.cosmos.me.management.provisional.wsdm.DynamicBindingCapability;
import org.eclipse.cosmos.me.management.provisional.wsdm.annotations.WSDMOperation;
import org.eclipse.cosmos.me.management.provisional.wsdm.faults.DynamicFault;
import org.eclipse.cosmos.me.management.provisional.wsdm.impl.DynamicInvocationHandler;
import org.eclipse.cosmos.me.management.provisional.wsdm.impl.WSDMBinding;
import org.eclipse.cosmos.me.management.provisional.wsdm.impl.info.WSDMInfo;
import org.w3c.dom.Element;

public class DynamicCapability
extends AbstractManageabilityCapability
implements DynamicBindingCapability {
    private ManagedResourceInfo info;
    private String namespace;
    private Object target;
    private QName[] properties = new QName[0];
    private HashMap<QName, Method> getterMap = new HashMap();
    private HashMap<QName, Method> setterMap = new HashMap();

    public QName[] getPropertyNames() {
        return this.properties;
    }

    protected void createGettersAndSetters(QName propertyName) {
    }

    protected Method getGetter(QName propertyQName) {
        return this.getterMap.get(propertyQName);
    }

    protected Method getSetter(QName propertyQName) {
        return this.setterMap.get(propertyQName);
    }

    public void initializeCompleted() throws SoapFault {
        super.initializeCompleted();
        try {
            this.target = this.getWsResource();
            this.target.getClass();
            if (this.getWsResource() instanceof WSDMBinding) {
                WSDMBinding binding = (WSDMBinding)this.getWsResource();
                this.target = binding.getResource();
                this.target.getClass();
                if (this.target instanceof ManagementProxy) {
                    Object newTarget = ((ManagementProxy)this.target).getCapability(this.namespace);
                    this.target = newTarget != null ? ((ManagementProxy)newTarget).getProxiedObject() : ((ManagementProxy)this.target).getProxiedObject();
                }
            }
        }
        catch (Throwable error) {
            error.printStackTrace();
        }
    }

    public Element[] getProperty(QName propertyQName) throws BaseFault {
        Method method = this.getterMap.get(propertyQName);
        Object result = this.invokeMethod(method, null);
        return this.getPropertyElements(propertyQName, result);
    }

    private BaseFault handleError(Throwable error) {
        Throwable cause = null;
        if (error instanceof InvocationTargetException) {
            cause = ((InvocationTargetException)error).getTargetException();
        }
        if (cause == null) {
            cause = error.getCause();
        }
        if (cause != null) {
            error = cause;
        }
        Object fault = null;
        if (error instanceof BaseFault) {
            fault = (BaseFault)error;
        } else {
            fault = new DynamicFault(error);
            Element trace = XmlUtils.createElement((QName)new QName(this.namespace, "stacktrace"));
            StackTraceElement[] stackTraceElementArray = error.getStackTrace();
            int n = stackTraceElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement ste = stackTraceElementArray[n2];
                Element se = XmlUtils.createElement((QName)new QName(this.namespace, "stackframe"));
                String names = String.valueOf(ste.getClassName()) + "." + ste.getMethodName();
                se.setAttribute("method", names);
                if (ste.getLineNumber() > 0) {
                    se.setAttribute("line", Integer.toString(ste.getLineNumber()));
                } else {
                    se.setAttribute("line", "not available");
                }
                trace.appendChild(se);
                ++n2;
            }
            fault.getDetail().appendChild(trace);
            String message = error.getMessage();
            if (message == null) {
                message = error.getClass().getName();
            }
            fault.setReason(message);
        }
        return fault;
    }

    protected Object invokeMethod(Method method, Object[] params) throws BaseFault {
        Object result = null;
        try {
            result = method.invoke(this.target, params);
        }
        catch (Throwable error) {
            throw this.handleError(error);
        }
        return result;
    }

    public Object invokeCustomMethod(Method method, Object[] params) throws Throwable {
        Object result = null;
        try {
            Object target = this.target;
            target.getClass();
            if (this.getWsResource() instanceof WSDMBinding) {
                WSDMBinding cfr_ignored_0 = (WSDMBinding)this.getWsResource();
                target = this.target;
                target.getClass();
                if (target instanceof ManagementProxy) {
                    Method proxyMethod = ((ManagementProxy)target).getProxiedMethod(method);
                    if (proxyMethod == null) {
                        if ((target = ((ManagementProxy)target).getCapability(method.getDeclaringClass())) instanceof ManagementProxy) {
                            target = ((ManagementProxy)target).getProxiedObject();
                        }
                    } else {
                        target = ((ManagementProxy)target).getProxiedObject();
                        method = proxyMethod;
                    }
                }
            }
            System.out.println(method.getDeclaringClass() + " " + target.getClass());
            result = method.invoke(target, params);
        }
        catch (Throwable error) {
            throw this.handleError(error);
        }
        return result;
    }

    public void initializeBindingInfo(WSDMInfo wsdmInfo, String namespace, String prefix) {
        ManagedOperationInfo[] operations;
        int n;
        this.info = wsdmInfo.getInfo();
        this.namespace = namespace;
        int propertiesLength = this.info.getAttributes().length;
        if (this.info.getResourceIdField() != null) {
            --propertiesLength;
        }
        if (propertiesLength > 0) {
            this.properties = new QName[propertiesLength];
            propertiesLength = 0;
            int i = 0;
            ManagedAttributeInfo[] managedAttributeInfoArray = (ManagedAttributeInfo[])this.info.getAttributes();
            n = managedAttributeInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                String ns;
                ManagedAttributeInfo attr = managedAttributeInfoArray[n2];
                if (!attr.isResourceID() && (ns = attr.getOwnerNamespace()).equals(namespace)) {
                    QName propName = new QName(attr.getNamespace(), attr.getName(), prefix);
                    this.getterMap.put(propName, attr.getGetter());
                    if (attr.getSetter() != null) {
                        this.setterMap.put(propName, attr.getSetter());
                    }
                    this.properties[i++] = propName;
                    propertiesLength = i;
                }
                ++n2;
            }
        }
        QName[] actualProps = new QName[propertiesLength];
        int i = 0;
        while (i < propertiesLength) {
            actualProps[i] = this.properties[i];
            ++i;
        }
        this.properties = actualProps;
        ManagedOperationInfo[] managedOperationInfoArray = operations = (ManagedOperationInfo[])this.info.getOperations();
        int n3 = operations.length;
        n = 0;
        while (n < n3) {
            ManagedOperationInfo operation = managedOperationInfoArray[n];
            if (operation.getNamespace().equals(namespace)) {
                WSDMOperation wsdmOper = (WSDMOperation)operation.getAnnotation(WSDMOperation.class);
                String actionURI = String.valueOf(namespace) + "/" + operation.getName();
                if (wsdmOper != null && !"".equals(wsdmOper.soapAction())) {
                    actionURI = wsdmOper.soapAction();
                }
                QName inputName = new QName(namespace, String.valueOf(operation.getName()) + "RequestType", "dyn");
                QName outputName = new QName(namespace, String.valueOf(operation.getName()) + "ResponseType", "dyn");
                DynamicInvocationHandler handler = new DynamicInvocationHandler(actionURI, inputName, outputName);
                handler.setMethod(operation.getOperationMethod());
                this.setMessageHandler((MessageHandler)handler);
            }
            ++n;
        }
    }
}

