/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.management.provisional.wsdm.persistence;

import javax.xml.namespace.QName;
import org.apache.muse.core.Resource;
import org.apache.muse.core.ResourceManager;
import org.apache.muse.core.routing.RouterFilePersistence;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.WsaConstants;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FilePersistor
extends RouterFilePersistence {
    protected Resource reloadResource(String contextPath, Element resourceXML) throws SoapFault {
        ResourceManager manager = this.getResourceManager();
        Document doc = resourceXML.getOwnerDocument();
        Element eprXML = XmlUtils.createElement((Document)doc, (QName)WsaConstants.EPR_QNAME);
        eprXML.appendChild(resourceXML);
        String address = manager.getEnvironment().getDefaultURI();
        int lastSlash = address.lastIndexOf(47);
        address = String.valueOf(address.substring(0, lastSlash + 1)) + contextPath;
        XmlUtils.setElement((Element)eprXML, (QName)WsaConstants.ADDRESS_QNAME, (Object)address);
        EndpointReference epr = new EndpointReference(eprXML);
        Resource resource = manager.createResource(contextPath);
        resource.setEndpointReference(epr);
        resource.initialize();
        manager.addResource(epr, resource);
        return resource;
    }

    public void resourceAdded(EndpointReference epr, Resource resource) throws SoapFault {
        String contextPath = resource.getContextPath();
        if (this.getResourceManager().isUsingPersistence(contextPath)) {
            this.createResourceFile(epr, resource);
        }
    }

    public void resourceRemoved(EndpointReference epr) throws SoapFault {
        String contextPath = this.getContextPath(epr);
        if (this.getResourceManager().isUsingPersistence(contextPath)) {
            this.destroyResourceFile(epr);
        }
    }
}

