/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.management.wsdm.web;

import java.net.InetAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.WsaConstants;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.resource.sg.remote.ServiceGroupClient;
import org.eclipse.cosmos.me.management.binding.Binding;
import org.eclipse.cosmos.me.management.common.BindingProvider;
import org.eclipse.cosmos.me.management.common.StatusChangeListener;
import org.eclipse.cosmos.me.management.web.ContributionManagerImpl;
import org.eclipse.cosmos.me.management.wsdm.web.ResourceRouter;
import org.eclipse.cosmos.me.management.wsdm.web.WebWSDMBindingFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDMServiceInitializer
implements ServletContextListener,
BindingProvider {
    private ArrayList<Binding> bindingSet = new ArrayList();
    private ContributionManagerImpl cosmosManager;

    protected ContributionManagerImpl getManager() {
        return this.cosmosManager;
    }

    public void contextDestroyed(ServletContextEvent event) {
    }

    public void contextInitialized(ServletContextEvent event) {
        final ServletContext context = event.getServletContext();
        Enumeration attrNames = context.getAttributeNames();
        while (attrNames.hasMoreElements()) {
            String name = (String)attrNames.nextElement();
            System.out.println(String.valueOf(name) + " " + context.getAttribute(name));
        }
        Thread kickstartThread = new Thread(new Runnable(){

            public void run() {
                WSDMServiceInitializer.this.launchWarmUpMuse(context);
            }
        });
        kickstartThread.start();
    }

    protected void managerInitialized() {
    }

    public Collection<Binding> getBindings() {
        return this.bindingSet;
    }

    private void launchWarmUpMuse(final ServletContext context) {
        try {
            Thread.currentThread();
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {}
        Thread museThread = new Thread(new Runnable(){

            public void run() {
                WSDMServiceInitializer.this.warmUpMuse(context.getServletContextName());
            }
        });
        museThread.start();
        try {
            museThread.join();
        }
        catch (InterruptedException interruptedException) {}
        this.bindingSet.add(WebWSDMBindingFactory.getDefault());
        this.cosmosManager = ContributionManagerImpl.getDefault();
        this.cosmosManager.initialize((BindingProvider)this);
        WebWSDMBindingFactory.getDefault().setResourceRouter((org.apache.muse.core.routing.ResourceRouter)ResourceRouter.getRouterInstance());
        WebWSDMBindingFactory.getDefault().setResourceManager(ResourceRouter.getRouterInstance().getResourceManager());
        WebWSDMBindingFactory.getDefault().setContextPath(context.getServletContextName());
        String portParam = context.getInitParameter("CosmosWebPort");
        if (portParam != null) {
            WebWSDMBindingFactory.getDefault().setPort(portParam);
        }
        this.managerInitialized();
    }

    private void warmUpMuse(String contextName) {
        try {
            try {
                String webAppRoot = "/" + contextName;
                String contextPath = String.valueOf(webAppRoot) + "/services/Relationships";
                String port = System.getProperty("org.eclipse.cosmos.me.web.bootstrap.port", "8080");
                String ip = InetAddress.getLocalHost().getHostAddress();
                StringBuffer address = new StringBuffer();
                address.append("http://");
                address.append(ip);
                address.append(':');
                address.append(port);
                if (contextPath.charAt(0) != '/') {
                    address.append('/');
                }
                address.append(contextPath);
                URI addressURI = URI.create(address.toString());
                EndpointReference epr = new EndpointReference(addressURI);
                ServiceGroupClient sg = new ServiceGroupClient(epr);
                System.out.println("Pinging Muse to initialize the endpoint...");
                sg.getResourcePropertyDocument();
                System.out.println("Waiting 10 seconds while simulation creates WS-resources...");
            }
            catch (SoapFault s) {
                if (!WsaConstants.DESTINATION_UNREACHABLE_FAULT_QNAME.equals(s.getSubCode())) {
                    s.printStackTrace();
                }
                WebWSDMBindingFactory.getDefault().statusChanged(WebWSDMBindingFactory.getDefault(), StatusChangeListener.STATUS.AVAILABLE);
            }
            catch (Throwable t) {
                t.printStackTrace();
                WebWSDMBindingFactory.getDefault().statusChanged(WebWSDMBindingFactory.getDefault(), StatusChangeListener.STATUS.AVAILABLE);
            }
        }
        finally {
            WebWSDMBindingFactory.getDefault().statusChanged(WebWSDMBindingFactory.getDefault(), StatusChangeListener.STATUS.AVAILABLE);
        }
    }
}

