/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.management.provisional.wsdm.impl.info;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.MBeanParameterInfo;
import javax.xml.namespace.QName;
import org.apache.muse.core.Capability;
import org.apache.muse.core.Environment;
import org.apache.muse.core.routing.MessageHandler;
import org.apache.muse.core.routing.ReflectionMessageHandler;
import org.apache.muse.core.serializer.Serializer;
import org.apache.muse.core.serializer.SerializerRegistry;
import org.apache.muse.ws.dm.muws.impl.SimpleManageabilityCharacteristics;
import org.apache.muse.ws.dm.muws.impl.SimpleMetrics;
import org.apache.muse.ws.dm.muws.impl.SimpleRelationships;
import org.apache.muse.ws.notification.impl.SimpleNotificationProducer;
import org.apache.muse.ws.resource.properties.get.impl.SimpleGetCapability;
import org.apache.muse.ws.resource.properties.query.impl.SimpleQueryCapability;
import org.apache.muse.ws.resource.properties.set.impl.SimpleSetCapability;
import org.eclipse.cosmos.me.management.common.info.ComposedCapabilityInfo;
import org.eclipse.cosmos.me.management.common.info.ManagedAttributeInfo;
import org.eclipse.cosmos.me.management.common.info.ManagedOperationInfo;
import org.eclipse.cosmos.me.management.common.info.ManagedRelationInfo;
import org.eclipse.cosmos.me.management.common.info.ManagedResourceInfo;
import org.eclipse.cosmos.me.management.common.util.BindingUtil;
import org.eclipse.cosmos.me.management.provisional.wsdm.annotations.WSDMOperation;
import org.eclipse.cosmos.me.management.provisional.wsdm.annotations.WSDMParameterType;
import org.eclipse.cosmos.me.management.provisional.wsdm.annotations.WSDMSchemaImport;
import org.eclipse.cosmos.me.management.provisional.wsdm.impl.DynamicAdvertisementCapability;
import org.eclipse.cosmos.me.management.provisional.wsdm.impl.DynamicNotificationConsumer;
import org.eclipse.cosmos.me.management.provisional.wsdm.impl.WSDLSource;
import org.eclipse.cosmos.me.management.provisional.wsdm.impl.info.WSDMOperationInfo;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDMInfo {
    private String targetNamespace = "";
    private ManagedResourceInfo info;
    private int namespaceCount = 0;
    private Object contribution;
    private HashMap<String, WSDMOperationInfo> metaMethodMap = new HashMap();
    private HashMap<String, String> namespaceList = new HashMap();
    private HashMap<String, String> importList = new HashMap();
    private HashMap<String, Class> capabilityMap = new HashMap();
    private HashMap<Class, HashMap<String, HandlerDescriptor>> capabilityMethodMap = new HashMap();

    private <T extends Annotation> T getAnnotationFromList(Class<T> target, Annotation[] annotations) {
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation.annotationType().equals(target)) {
                return (T)annotation;
            }
            ++n2;
        }
        return null;
    }

    public WSDMInfo(ManagedResourceInfo info, Object contribution) throws IllegalArgumentException {
        ComposedCapabilityInfo[] caps;
        ManagedOperationInfo[] ops;
        String[] nsSet;
        this.info = info;
        this.contribution = contribution;
        this.targetNamespace = info.getTargetNamespace();
        this.namespaceList.put(this.targetNamespace, "dyn");
        String[] stringArray = nsSet = info.getNamespaces();
        int n = nsSet.length;
        int n2 = 0;
        while (n2 < n) {
            String ns = stringArray[n2];
            String pfx = info.getPrefixForNamespace(ns);
            this.namespaceList.put(ns, pfx);
            ++n2;
        }
        ManagedAttributeInfo[] cfr_ignored_0 = (ManagedAttributeInfo[])info.getAttributes();
        ManagedOperationInfo[] managedOperationInfoArray = ops = (ManagedOperationInfo[])info.getOperations();
        int n3 = ops.length;
        n = 0;
        while (n < n3) {
            MBeanParameterInfo[] parms;
            ManagedOperationInfo op = managedOperationInfoArray[n];
            WSDMOperation wsdmOp = (WSDMOperation)op.getAnnotation(WSDMOperation.class);
            MBeanParameterInfo[] mBeanParameterInfoArray = parms = op.getSignature();
            int n4 = parms.length;
            int n5 = 0;
            while (n5 < n4) {
                MBeanParameterInfo parm = mBeanParameterInfoArray[n5];
                WSDMParameterType parmType = this.getAnnotationFromList(WSDMParameterType.class, op.getAnnotationsForParameter(parm));
                if (parmType != null) {
                    this.addNamespace(parmType.schema());
                    if (parmType.serializer() != null && !"".equals(parmType.serializer())) {
                        try {
                            Class<?> parmClass = op.getOperationMethod().getDeclaringClass().getClassLoader().loadClass(parm.getType());
                            Serializer ser = null;
                            try {
                                ser = SerializerRegistry.getInstance().getSerializer(parmClass);
                            }
                            catch (RuntimeException runtimeException) {
                                Class<?> serializer;
                                Object serObj;
                                if (ser == null && (serObj = (serializer = op.getOperationMethod().getDeclaringClass().getClassLoader().loadClass(parmType.serializer())).newInstance()) instanceof Serializer) {
                                    SerializerRegistry.getInstance().registerSerializer(parmClass, (Serializer)serObj);
                                }
                            }
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                }
                ++n5;
            }
            ++n;
        }
        this.extractAdditionalNamespaces(info.getResourceClass());
        Object[] objectArray = caps = info.getComposedCapabilities();
        int n6 = caps.length;
        n3 = 0;
        while (n3 < n6) {
            ComposedCapabilityInfo cap = objectArray[n3];
            this.extractAdditionalNamespaces(cap.getImplClass());
            this.addCapabilityClass(cap.getNamespace(), cap.getImplClass());
            ++n3;
        }
        objectArray = info.getCapabilities();
        n6 = objectArray.length;
        n3 = 0;
        while (n3 < n6) {
            ComposedCapabilityInfo cap = objectArray[n3];
            if (this.getCapabilityClass((String)cap) == null) {
                this.addCapabilityClass((String)cap, info.getResourceClass());
            }
            ++n3;
        }
    }

    private void extractAdditionalNamespaces(Class clzz) {
        Class<?>[] ifaces;
        HashMap fieldMap = new HashMap();
        BindingUtil.extractFields((Class)clzz, fieldMap);
        for (Field field : fieldMap.values()) {
            WSDMSchemaImport schemaImport = field.getAnnotation(WSDMSchemaImport.class);
            if (schemaImport == null) continue;
            field.getDeclaringClass();
            try {
                String value = (String)field.get(null);
                this.addNamespace(value);
                this.importList.put(value, schemaImport.location());
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        Class superClzz = clzz.getSuperclass();
        if (superClzz != null && !superClzz.getPackage().getName().startsWith("java")) {
            this.extractAdditionalNamespaces(superClzz);
        }
        Class<?>[] classArray = ifaces = clzz.getInterfaces();
        int n = ifaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> iface = classArray[n2];
            if (!iface.getPackage().getName().startsWith("java")) {
                this.extractAdditionalNamespaces(iface);
            }
            ++n2;
        }
    }

    public ManagedResourceInfo getInfo() {
        return this.info;
    }

    public boolean hasNamespace(String namespace) {
        return this.namespaceList.containsKey(namespace);
    }

    public String[] getNamespaces() {
        return this.namespaceList.keySet().toArray(new String[0]);
    }

    public String[] getSchemaImports() {
        return this.importList.keySet().toArray(new String[0]);
    }

    public String getSchemaLocation(String namespace) {
        return this.importList.get(namespace);
    }

    public String getPrefixForNamespace(String namespace) {
        if ("".equals(namespace)) {
            return "dyn";
        }
        return this.namespaceList.get(namespace);
    }

    public ManagedAttributeInfo getResourceIdField() {
        return this.info.getResourceIdField();
    }

    public boolean resourceLifetimeSupport() {
        return false;
    }

    public boolean hasMetrics() {
        return this.info.hasMetrics();
    }

    public boolean isAdvertised() {
        return this.info.isAdvertised();
    }

    public boolean hasEventConsumers() {
        return this.info.hasEventConsumers();
    }

    public String getAdvertisementConsumer() {
        return this.info.getAdvertisementConsumer();
    }

    public String getTargetNamespace() {
        return this.info.getTargetNamespace();
    }

    public String getResourceName() {
        return this.info.getClassName();
    }

    public ManagedRelationInfo[] getRelations() {
        return this.info.getRelations();
    }

    public Class getCapabilityClass(String capability) {
        return this.capabilityMap.get(capability);
    }

    public void addCapabilityClass(String capability, Class implClass) {
        this.capabilityMap.put(capability, implClass);
    }

    public String[] getCapabilityURIs() {
        return this.capabilityMap.keySet().toArray(new String[0]);
    }

    public void compileCapabilties(Environment environment, ManagedResourceInfo info) throws Exception {
        WSDLSource metaData = new WSDLSource(this, this.contribution);
        metaData.setEnvironment(environment);
        Document wsdl = metaData.getWSDLDocument();
        Element binding = (Element)wsdl.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "binding").item(0);
        Element portType = (Element)wsdl.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "portType").item(0);
        HashMap<String, Element> actionToElementMap = new HashMap<String, Element>();
        NodeList children = binding.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "operation");
        int i = 0;
        while (i < children.getLength()) {
            Element child = (Element)children.item(i);
            child.getAttribute("name");
            NodeList inputChild = child.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/soap/", "operation");
            String action = ((Element)inputChild.item(0)).getAttribute("soapAction");
            actionToElementMap.put(action, child);
            ++i;
        }
        if (this.capabilityMap.get("http://docs.oasis-open.org/wsrf/rpw-2/Get") == null) {
            this.capabilityMap.put("http://docs.oasis-open.org/wsrf/rpw-2/Get", SimpleGetCapability.class);
        }
        if (this.capabilityMap.get("http://docs.oasis-open.org/wsrf/rpw-2/Query") == null) {
            this.capabilityMap.put("http://docs.oasis-open.org/wsrf/rpw-2/Query", SimpleQueryCapability.class);
        }
        if (this.capabilityMap.get("http://docs.oasis-open.org/wsdm/muws/capabilities/ManageabilityCharacteristics") == null) {
            this.capabilityMap.put("http://docs.oasis-open.org/wsdm/muws/capabilities/ManageabilityCharacteristics", SimpleManageabilityCharacteristics.class);
        }
        if (this.capabilityMap.get("http://docs.oasis-open.org/wsrf/rpw-2/Set") == null && this.hasSettableAttributes()) {
            this.capabilityMap.put("http://docs.oasis-open.org/wsrf/rpw-2/Set", SimpleSetCapability.class);
        }
        if ((info.getNotifications().length > 0 || this.isAdvertised()) && this.capabilityMap.get("http://docs.oasis-open.org/wsn/bw-2/NotificationProducer") == null) {
            this.capabilityMap.put("http://docs.oasis-open.org/wsn/bw-2/NotificationProducer", SimpleNotificationProducer.class);
        }
        if (this.getRelations().length > 0 && this.capabilityMap.get("http://docs.oasis-open.org/wsdm/muws/capabilities/Relationships") == null) {
            this.capabilityMap.put("http://docs.oasis-open.org/wsdm/muws/capabilities/Relationships", SimpleRelationships.class);
        }
        if (this.hasMetrics() && this.capabilityMap.get("http://docs.oasis-open.org/wsdm/muws/capabilities/Metrics") == null) {
            this.capabilityMap.put("http://docs.oasis-open.org/wsdm/muws/capabilities/Metrics", SimpleMetrics.class);
        }
        if (this.isAdvertised() && this.capabilityMap.get("http://docs.oasis-open.org/wsdm/muws/capabilities/Advertisement") == null) {
            this.capabilityMap.put("http://docs.oasis-open.org/wsdm/muws/capabilities/Advertisement", DynamicAdvertisementCapability.class);
        }
        if (this.hasEventConsumers() && this.capabilityMap.get("http://docs.oasis-open.org/wsn/bw-2/NotificationConsumer") == null) {
            this.capabilityMap.put("http://docs.oasis-open.org/wsn/bw-2/NotificationConsumer", DynamicNotificationConsumer.class);
        }
        this.capabilityMap.put(this.getTargetNamespace(), info.getResourceClass());
        for (Class capClass : this.capabilityMap.values()) {
            this.capabilityMethodMap.put(capClass, this.compileMessageHandlers(wsdl, portType, actionToElementMap, capClass));
        }
        if (this.capabilityMap.get("http://schemas.xmlsoap.org/ws/2004/09/mex/GetMetadata") == null) {
            this.capabilityMethodMap.put(WSDLSource.class, this.compileMessageHandlers(wsdl, portType, actionToElementMap, WSDLSource.class));
        }
    }

    private boolean hasSettableAttributes() {
        ManagedAttributeInfo[] attrs;
        ManagedAttributeInfo[] managedAttributeInfoArray = attrs = (ManagedAttributeInfo[])this.info.getAttributes();
        int n = attrs.length;
        int n2 = 0;
        while (n2 < n) {
            ManagedAttributeInfo attr = managedAttributeInfoArray[n2];
            if (attr.getSetter() != null) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected MessageHandler createMessageHandler(String actionURI, QName operationName, QName returnValueName) {
        return new ReflectionMessageHandler(actionURI, operationName, returnValueName);
    }

    protected HashMap compileMessageHandlers(Document wsdl, Element portType, Map opsByAction, Class theClass) {
        HashMap<String, HandlerDescriptor> descriptorMap = new HashMap<String, HandlerDescriptor>();
        HashMap<String, Method> methodsByName = new HashMap<String, Method>();
        Method[] methods = theClass.getMethods();
        NamedNodeMap docAttrs = wsdl.getDocumentElement().getAttributes();
        HashMap<String, String> prefixMap = new HashMap<String, String>();
        int i = 0;
        while (i < docAttrs.getLength()) {
            Attr attr = (Attr)docAttrs.item(i);
            if ("http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI())) {
                if ("xmlns".equals(attr.getName())) {
                    prefixMap.put("", attr.getValue());
                } else {
                    prefixMap.put(attr.getName().substring("xmlns:".length(), attr.getName().length()), attr.getValue());
                }
            } else if ("targetNamespace".equals(attr.getName())) {
                prefixMap.put("dyn", attr.getValue());
            }
            ++i;
        }
        int n = 0;
        while (n < methods.length) {
            Class<?> declaringClass = methods[n].getDeclaringClass();
            if (declaringClass != Object.class && declaringClass != Capability.class) {
                methodsByName.put(methods[n].getName(), methods[n]);
            }
            ++n;
        }
        new ArrayList(opsByAction.size());
        Iterator i2 = opsByAction.keySet().iterator();
        while (i2.hasNext()) {
            String action = (String)i2.next();
            Element next = (Element)opsByAction.get(action);
            QName inputName = this.getInputPartName(prefixMap, wsdl, portType, next);
            QName outputName = this.getOutputPartName(prefixMap, wsdl, portType, next);
            String localName = next.getAttribute("name");
            String methodName = this.getMethodName(localName);
            Method method = (Method)methodsByName.get(methodName);
            String qualifiedAction = this.getQualifiedAction(portType, next);
            if (qualifiedAction == null) {
                qualifiedAction = action;
            }
            if (method == null) continue;
            descriptorMap.put(qualifiedAction, new HandlerDescriptor(method, inputName, outputName));
            i2.remove();
        }
        return descriptorMap;
    }

    public Collection createMessageHandlers(Class theClass) {
        Map actionMap = this.capabilityMethodMap.get(theClass);
        ArrayList<MessageHandler> handlers = new ArrayList<MessageHandler>();
        if (actionMap == null) {
            System.out.println("Oops");
        }
        for (String action : actionMap.keySet()) {
            HandlerDescriptor desc = (HandlerDescriptor)actionMap.get(action);
            MessageHandler handler = this.createMessageHandler(action, desc.inputName, desc.outputName);
            handler.setMethod(desc.method);
            handlers.add(handler);
        }
        return handlers;
    }

    private QName getInputPartName(HashMap<String, String> prefixMap, Document doc, Element portType, Element oper) {
        return this.getPartName("input", doc, prefixMap, portType, oper);
    }

    private QName getOutputPartName(HashMap<String, String> prefixMap, Document doc, Element portType, Element oper) {
        return this.getPartName("output", doc, prefixMap, portType, oper);
    }

    private QName getPartName(String part, Document doc, HashMap<String, String> prefixMap, Element portType, Element oper) {
        NodeList inputChild = oper.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "input");
        ((Element)inputChild.item(0)).getAttribute("name");
        String message = null;
        NodeList operTypeList = portType.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "operation");
        int i = 0;
        while (i < operTypeList.getLength()) {
            Element type = (Element)operTypeList.item(i);
            if (oper.getAttribute("name").equals(type.getAttribute("name"))) {
                NodeList messages = type.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", part);
                if (messages == null || messages.getLength() == 0) {
                    return null;
                }
                message = ((Element)type.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", part).item(0)).getAttribute("message");
                break;
            }
            ++i;
        }
        String namespace = prefixMap.get("dyn");
        String name = message;
        if (message == null) {
            // empty if block
        }
        if (message.indexOf(":") > 0) {
            String prefix = message.substring(0, message.indexOf(":"));
            name = message.substring(message.indexOf(":") + 1, message.length());
            namespace = prefixMap.get(prefix);
        }
        NodeList messageList = doc.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "message");
        int i2 = 0;
        while (i2 < messageList.getLength()) {
            Element msg = (Element)messageList.item(i2);
            if (name.equals(msg.getAttribute("name"))) {
                String partName;
                msg.getNamespaceURI();
                message = partName = ((Element)msg.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "part").item(0)).getAttribute("element");
                name = partName;
                if (message.indexOf(":") > 0) {
                    String prefix = message.substring(0, message.indexOf(":"));
                    name = message.substring(message.indexOf(":") + 1, message.length());
                    namespace = prefixMap.get(prefix);
                    return new QName(namespace, name, prefix);
                }
            }
            ++i2;
        }
        return null;
    }

    private String getQualifiedAction(Element portType, Element oper) {
        NodeList operTypeList = portType.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "operation");
        int i = 0;
        while (i < operTypeList.getLength()) {
            Element type = (Element)operTypeList.item(i);
            if (oper.getAttribute("name").equals(type.getAttribute("name"))) {
                return ((Element)type.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "input").item(0)).getAttributeNS("http://www.w3.org/2005/08/addressing", "Action");
            }
            ++i;
        }
        return null;
    }

    private String getMethodName(String actionName) {
        return String.valueOf(Character.toLowerCase(actionName.charAt(0))) + actionName.substring(1);
    }

    public void addNamespace(String schema) {
        String ns = this.namespaceList.get(schema);
        if (ns == null) {
            this.namespaceList.put(schema, "wsdm" + this.namespaceCount++);
        }
    }

    private class HandlerDescriptor {
        Method method;
        QName inputName;
        QName outputName;

        public HandlerDescriptor(Method method, QName inputName, QName outputName) {
            this.method = method;
            this.inputName = inputName;
            this.outputName = outputName;
        }
    }
}

