/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.management.provisional.wsdm.util;

import java.util.ArrayList;
import java.util.Hashtable;
import javax.xml.namespace.QName;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.WsaConstants;
import org.apache.muse.ws.dm.muws.MuwsConstants;
import org.apache.muse.ws.resource.remote.WsResourceClient;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RelationshipHelper {
    public static ArrayList getRelationships(WsResourceClient _resource) throws Exception {
        ArrayList<Object> relationships = new ArrayList<Object>();
        String resourceType = "RelationshipResource";
        boolean isRelationshipResource = true;
        Element ele = _resource.getResourcePropertyDocument();
        System.out.println(XmlUtils.toString((Node)ele));
        Element[] rels = _resource.getResourceProperty(MuwsConstants.RELATIONSHIP_QNAME);
        if (rels != null && rels.length > 0) {
            resourceType = "ResourceWithRelationships";
            isRelationshipResource = false;
        }
        relationships.add(resourceType);
        if (!isRelationshipResource) {
            int i = 0;
            while (i < rels.length) {
                relationships.add(RelationshipHelper.createRelationship(rels[i]));
                ++i;
            }
        }
        return relationships;
    }

    protected static Hashtable createRelationship(Element el) {
        Element typeElement;
        Hashtable<String, Object> table = new Hashtable<String, Object>();
        Element nameElement = XmlUtils.findFirstInSubTree((Element)el, (QName)MuwsConstants.NAME_QNAME);
        if (nameElement != null) {
            String name = XmlUtils.extractText((Element)nameElement);
            table.put("name", name);
        }
        if ((typeElement = XmlUtils.findFirstInSubTree((Element)el, (QName)MuwsConstants.TYPE_QNAME)) != null) {
            String type = XmlUtils.toString((Node)typeElement);
            table.put("type", type);
        }
        Hashtable participants = new Hashtable();
        table.put("participants", participants);
        Element[] pElements = XmlUtils.findInSubTree((Element)el, (QName)MuwsConstants.PARTICIPANT_QNAME);
        if (pElements != null) {
            int i = 0;
            while (i < pElements.length) {
                RelationshipHelper.addParticipant(participants, pElements[i]);
                ++i;
            }
        }
        return table;
    }

    protected static void addParticipant(Hashtable participants, Element el) {
        Hashtable<String, String> partiDetails = new Hashtable<String, String>();
        Element roleElement = XmlUtils.findFirstInSubTree((Element)el, (QName)MuwsConstants.ROLE_QNAME);
        String role = XmlUtils.extractText((Element)roleElement);
        Element eprElement = XmlUtils.findFirstInSubTree((Element)el, (QName)MuwsConstants.MANAGEABILITY_EPR_QNAME);
        String epr = XmlUtils.toString((Node)eprElement);
        Element element = XmlUtils.getElement((Node)eprElement, (QName)WsaConstants.ADDRESS_QNAME);
        String uri = XmlUtils.extractText((Element)element);
        partiDetails.put("epr", epr);
        partiDetails.put("displayString", uri);
        partiDetails.put("ManagedAgentType", "WSDM");
        participants.put(role, partiDetails);
    }
}

