/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.tools.generator.projectizer;

import java.io.File;
import java.io.InputStream;
import java.util.Map;
import org.apache.muse.tools.generator.projectizer.J2EEAxis2Projectizer;
import org.apache.muse.tools.generator.projectizer.OsgiAxis2ProjectizerConstants;
import org.apache.muse.tools.generator.projectizer.OsgiProjectizerConstants;
import org.apache.muse.tools.generator.util.ConfigurationData;
import org.apache.muse.tools.generator.util.ConfigurationDataDescriptor;
import org.apache.muse.util.FileUtils;
import org.apache.muse.ws.resource.metadata.MetadataDescriptor;
import org.apache.muse.ws.wsdl.WsdlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OsgiAxis2Projectizer
extends J2EEAxis2Projectizer {
    static /* synthetic */ Class class$org$apache$muse$tools$generator$projectizer$OsgiAxis2Projectizer;

    public void projectize(ConfigurationData configuration) throws Exception {
        ConfigurationData.checkConfiguration(this, configuration);
        this.loadParameters(configuration);
        File javaSourceDir = new File(this._targetDirectory, "src");
        this.createDirectoryStructure();
        this.createJavaSources(javaSourceDir, this._filesMaps, this._ignoreSets);
        this.createArtifacts(javaSourceDir);
        this.createOverwriteManifest();
    }

    protected void createArtifacts(File javaSourceDir) throws Exception {
        File descriptorFile = new File(this._targetDirectory, "config/muse.xml");
        this.createBuildFile(this._targetDirectory, "/resources/osgi/build.xml", "build.xml");
        File wsdldir = new File(this._targetDirectory, "wsdl");
        this.createActivatorFile(javaSourceDir, "/resources/osgi/Activator");
        File routerEntriesDir = new File(this._targetDirectory, "router-entries");
        String activatorName = this.getSymbolicName() + "." + "Activator";
        this.createManifest(this._targetDirectory, "/resources/osgi/MANIFEST.MF", "config/MANIFEST.MF", activatorName);
        this.createConfigIni(this._targetDirectory, "/resources/osgi/config.ini", "config/config.ini");
        for (int i = 0; i < this._capabilitiesList.length; ++i) {
            Map capabilities = this._capabilitiesList[i];
            MetadataDescriptor rmd = this._metadatas[i];
            this.createRMDFile(rmd, this._wsdls[i], wsdldir);
            Document wsdl = this._wsdls[i];
            this.createDescriptor(this._descriptor, wsdl, descriptorFile, capabilities, "/wsdl/", i);
            this.createWSDLFile(wsdl, wsdldir);
            this.createRouterEntries(routerEntriesDir, WsdlUtils.getServiceName((Element)wsdl.getDocumentElement()), capabilities);
        }
    }

    protected void createDirectoryStructure() throws Exception {
        File templateDir = new File(System.getProperty("MUSE_HOME"), "lib/eclipse-osgi");
        File destDir = new File(this._targetDirectory, "plugins");
        this.copyTemplate(templateDir, destDir);
        File axis2ExtraJars = new File(System.getProperty("MUSE_HOME"), "lib/axis2-osgi");
        this.copyTemplate(axis2ExtraJars, destDir);
        File modulesDir = new File(System.getProperty("MUSE_HOME"), "modules");
        this.copyJars(OsgiAxis2ProjectizerConstants.REQUIRED_MODULES, modulesDir, destDir);
        File libDir = new File(this._targetDirectory, "lib");
        this.copyJars(OsgiProjectizerConstants.REQUIRED_LIBS, modulesDir, libDir);
    }

    protected void createConfigIni(File destDir, String configFileResource, String configFileName) throws Exception {
        InputStream configIS = FileUtils.loadFromContext((Class)(class$org$apache$muse$tools$generator$projectizer$OsgiAxis2Projectizer == null ? (class$org$apache$muse$tools$generator$projectizer$OsgiAxis2Projectizer = OsgiAxis2Projectizer.class$("org.apache.muse.tools.generator.projectizer.OsgiAxis2Projectizer")) : class$org$apache$muse$tools$generator$projectizer$OsgiAxis2Projectizer), (String)configFileResource);
        File configFile = new File(destDir, configFileName);
        this.copyStreamCheck(configIS, configFile);
    }

    protected void createActivatorFile(File srcDir, String activatorFileResource) throws Exception {
        InputStream activatorTemplateIS = FileUtils.loadFromContext((Class)(class$org$apache$muse$tools$generator$projectizer$OsgiAxis2Projectizer == null ? (class$org$apache$muse$tools$generator$projectizer$OsgiAxis2Projectizer = OsgiAxis2Projectizer.class$("org.apache.muse.tools.generator.projectizer.OsgiAxis2Projectizer")) : class$org$apache$muse$tools$generator$projectizer$OsgiAxis2Projectizer), (String)activatorFileResource);
        Object[] filler = new Object[]{this.getSymbolicName()};
        String newActivator = this.loadString(activatorTemplateIS, filler);
        String activatorDirName = this.getSymbolicName().toString();
        File activatorDir = new File(srcDir, activatorDirName);
        File activatorFile = new File(activatorDir, "Activator.java");
        this.writeToFileCheck(newActivator, activatorFile);
    }

    protected void createManifest(File baseTargetDir, String manifestFileResource, String manifestFileName, String activatorFileName) throws Exception {
        InputStream manifestTemplateIS = FileUtils.loadFromContext((Class)(class$org$apache$muse$tools$generator$projectizer$OsgiAxis2Projectizer == null ? (class$org$apache$muse$tools$generator$projectizer$OsgiAxis2Projectizer = OsgiAxis2Projectizer.class$("org.apache.muse.tools.generator.projectizer.OsgiAxis2Projectizer")) : class$org$apache$muse$tools$generator$projectizer$OsgiAxis2Projectizer), (String)manifestFileResource);
        Object[] filler = new Object[]{this.getSymbolicName(), activatorFileName, this.getSymbolicName(), this.getSymbolicName()};
        String newManifest = this.loadString(manifestTemplateIS, filler);
        File manifestFile = new File(baseTargetDir, manifestFileName);
        this.writeToFileCheck(newManifest, manifestFile);
    }

    protected Object getSymbolicName() {
        if (this._targetDirectory.equals(FileUtils.CURRENT_DIR)) {
            return this._targetDirectory.getAbsoluteFile().getParentFile().getName();
        }
        return this._targetDirectory.getAbsoluteFile().getName();
    }

    public ConfigurationDataDescriptor[] getConfigurationDataDescriptions() {
        return J2EEAxis2Projectizer.REQUIRED_PARAMETERS;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

