/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.tools.generator.projectizer;

import java.io.File;
import java.io.InputStream;
import java.util.Map;
import org.apache.muse.tools.generator.projectizer.AbstractProjectizer;
import org.apache.muse.tools.generator.projectizer.ProxyProjectizerConstants;
import org.apache.muse.tools.generator.util.ConfigurationData;
import org.apache.muse.tools.generator.util.ConfigurationDataDescriptor;
import org.apache.muse.util.FileUtils;

public class ProxyProjectizer
extends AbstractProjectizer {
    static ConfigurationDataDescriptor[] REQUIRED_PARAMETERS = new ConfigurationDataDescriptor[]{ConfigurationData.FILES_MAP_LIST_CONFIGURATION, ConfigurationData.OVERWRITE_CONFIGURATION};
    protected Map[] _filesMaps;

    public void projectize(ConfigurationData configuration) throws Exception {
        ConfigurationData.checkConfiguration(this, configuration);
        this.loadParameters(configuration);
        File javaSourceDir = new File(this._targetDirectory, "src");
        this.createDirectoryStructure();
        this.createJavaSources(javaSourceDir, this._filesMaps);
        this.createArtifacts();
        this.createOverwriteManifest();
    }

    protected void createArtifacts() throws Exception {
        this.createBuildFile(this._targetDirectory, "/resources/proxy/build.xml", "build.xml");
    }

    protected void createDirectoryStructure() throws Exception {
        File libDir = new File(this._targetDirectory, "lib");
        File modulesDir = new File(System.getProperty("MUSE_HOME"), "modules");
        File museLibDir = new File(System.getProperty("MUSE_HOME"), "lib");
        this.copyJars(ProxyProjectizerConstants.REQUIRED_MODULES, modulesDir, libDir);
        this.copyJars(ProxyProjectizerConstants.REQUIRED_MUSE_LIBS, museLibDir, libDir);
    }

    protected void loadParameters(ConfigurationData configuration) {
        this._filesMaps = (Map[])configuration.getParameter("files_map_list");
        this._targetDirectory = (File)configuration.getParameter("target_dir");
        boolean overwrite = (Boolean)configuration.getParameter("overwrite");
        this.setTargetDirectory((File)configuration.getParameter("target_dir"), overwrite);
    }

    protected void createBuildFile(File baseTargetDir, String buildFileResource, String buildFile) throws Exception {
        InputStream buildTemplate = FileUtils.loadFromContext(this.getClass(), (String)buildFileResource);
        File build = new File(baseTargetDir, buildFile);
        this.copyStreamCheck(buildTemplate, build);
    }

    public ConfigurationDataDescriptor[] getConfigurationDataDescriptions() {
        return REQUIRED_PARAMETERS;
    }
}

