/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.tools.generator.synthesizer;

import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.muse.tools.generator.util.Capability;
import org.apache.muse.tools.inspector.JavaMethod;
import org.apache.muse.tools.inspector.JavaProperty;
import org.apache.muse.util.ReflectUtils;

public class ClassInfo {
    Capability _capability = null;
    Set _imports = new HashSet();
    Map _conflicts = new HashMap();

    public ClassInfo(Capability capability) {
        this._capability = capability;
        this.findImports();
    }

    public ClassInfo() {
    }

    public void setCapability(Capability capability) {
        this._capability = capability;
        this.findImports();
    }

    private void findImports() {
        Iterator i = this._capability.getOperations().iterator();
        while (i.hasNext()) {
            JavaMethod method = (JavaMethod)i.next();
            this.addImport(method.getReturnType());
            Class[] parameterTypes = method.getParameterTypes();
            for (int j = 0; j < parameterTypes.length; ++j) {
                this.addImport(parameterTypes[j]);
            }
        }
        i = this._capability.getProperties().iterator();
        while (i.hasNext()) {
            JavaProperty property = (JavaProperty)i.next();
            this.addImport(property.getJavaType());
        }
    }

    public void addImport(Class theClass) {
        String shortName;
        HashSet<Class> matches;
        if (theClass.isArray()) {
            theClass = ReflectUtils.getClassFromArrayClass((Class)theClass);
        }
        if ((matches = (HashSet<Class>)this._conflicts.get(shortName = ReflectUtils.getShortName((Class)theClass))) == null) {
            matches = new HashSet<Class>();
            matches.add(theClass);
        } else if (!matches.contains(theClass)) {
            matches.add(theClass);
        }
        this._conflicts.put(shortName, matches);
        this._imports.add(theClass);
    }

    public Set getImports() {
        return this._imports;
    }

    public static String getPackageName(String uri) {
        try {
            String result = new String();
            URL url = new URL(uri);
            String[] hostParts = url.getHost().split("\\.");
            for (int i = hostParts.length - 1; i >= 0; --i) {
                if (hostParts[i].matches("^[^a-zA-Z_].*$")) {
                    hostParts[i] = "_" + hostParts[i];
                }
                result = result + hostParts[i] + ".";
            }
            String[] fileParts = url.getPath().split("/");
            for (int i = 0; i < fileParts.length; ++i) {
                if (fileParts[i].matches("^[^a-zA-Z_].*$")) {
                    fileParts[i] = "_" + fileParts[i];
                }
                if (fileParts[i].length() == 0) continue;
                result = result + fileParts[i] + (i != fileParts.length - 1 ? "." : "");
            }
            result = result.replaceAll("[^.a-zA-Z0-9_]+", "_");
            return result;
        }
        catch (Exception e) {
            return "org.tempuri";
        }
    }

    public boolean hasConflict(Class theClass) {
        Integer count = (Integer)this._conflicts.get(theClass);
        return count != null && count > 1;
    }

    public Capability getCapability() {
        return this._capability;
    }

    public boolean needsInitializer() {
        Iterator i = this._capability.getProperties().iterator();
        while (i.hasNext()) {
            JavaProperty next = (JavaProperty)i.next();
            if (next.getJavaType().isPrimitive()) continue;
            return true;
        }
        return this._capability.isEmpty();
    }

    public void addImports(Set set) {
        Iterator i = set.iterator();
        while (i.hasNext()) {
            this.addImport((Class)i.next());
        }
    }
}

