/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.tools.generator.synthesizer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.muse.tools.generator.synthesizer.AbstractSynthesizer;
import org.apache.muse.tools.generator.synthesizer.ClassInfo;
import org.apache.muse.tools.generator.util.Capability;
import org.apache.muse.tools.generator.util.ConfigurationData;
import org.apache.muse.tools.generator.util.ConfigurationDataDescriptor;
import org.apache.muse.tools.inspector.JavaMethod;
import org.apache.muse.tools.inspector.JavaProperty;
import org.apache.muse.tools.inspector.ResourceInspector;
import org.apache.muse.util.ReflectUtils;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.wsdl.WsdlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ProxyInterfaceSynthesizer
extends AbstractSynthesizer {
    private static final String TARGET_NS_ATTR = "targetNamespace";
    protected static final String PARAM_NAME = "param";
    static ConfigurationDataDescriptor[] REQUIRED_PARAMETERS = new ConfigurationDataDescriptor[]{ConfigurationData.CAPABILITIES_MAP_LIST_CONFIGURATION, ConfigurationData.GENERATE_CUSTOM_HEADERS_CONFIGURATION, ConfigurationData.WSDL_DOCUMENT_LIST_CONFIGURATION};
    protected static Set _ignoredCapabilitySet = new HashSet();
    protected static Map _clientCapabilitiesMap;
    protected StringBuffer _headerCode;
    protected StringBuffer _operationsCode;
    protected StringBuffer _propertiesCode;
    String _className;
    protected Set _importSet;
    private boolean _hasProperties;
    protected boolean _generateCustomHeaders;
    private Map[] _capabilityMaps;
    private Document[] _wsdlDocuments;
    protected Class _baseClientClass;
    private Map[] _filesMaps;
    private int _index = 0;
    static /* synthetic */ Class class$org$apache$muse$ws$resource$remote$WsResourceClient;
    static /* synthetic */ Class class$org$apache$muse$ws$notification$remote$NotificationProducerClient;
    static /* synthetic */ Class class$org$apache$muse$ws$notification$remote$NotificationConsumerClient;
    static /* synthetic */ Class class$org$apache$muse$ws$addressing$soap$SoapFault;
    static /* synthetic */ Class class$javax$xml$namespace$QName;

    public ConfigurationData synthesize(ConfigurationData data) throws Exception {
        ConfigurationData.checkConfiguration(this, data);
        this.loadParameters(data);
        for (int i = 0; i < this._capabilityMaps.length; ++i) {
            if (this._filesMaps[i] == null) {
                this._filesMaps[i] = new HashMap();
            }
            this.generateCode(this._wsdlDocuments[i], this._capabilityMaps[i], this._filesMaps[i]);
        }
        return data;
    }

    protected void loadParameters(ConfigurationData data) {
        this._generateCustomHeaders = (Boolean)data.getParameter("generate_custom_headers");
        this._capabilityMaps = (Map[])data.getParameter("capabilities_map_list");
        this._wsdlDocuments = (Document[])data.getParameter("wsdl_documents");
        this._filesMaps = (Map[])data.getParameter("files_map_list");
        if (this._filesMaps == null) {
            this._filesMaps = new HashMap[this._capabilityMaps.length];
            data.addParameter("files_map_list", this._filesMaps);
        }
    }

    protected void generateCode(Document wsdl, Map capabilityMap, Map files) {
        String className = this.generateClassName(wsdl);
        this._baseClientClass = this.getBaseClientClass(capabilityMap);
        this.initializeCode(className);
        ClassInfo classInfo = new ClassInfo();
        Iterator i = capabilityMap.values().iterator();
        while (i.hasNext()) {
            Capability capability = (Capability)i.next();
            if (!this.needsGeneratedCode(this._baseClientClass, capability)) continue;
            classInfo.setCapability(capability);
            this.updateCode(classInfo);
        }
        files.put(this.createFileName(className), this.generateCombinedCode(classInfo));
    }

    private boolean needsGeneratedCode(Class clientClass, Capability capability) {
        Set set;
        boolean needsGeneratedCode = true;
        String uri = capability.getURI();
        Class clazz = null;
        if ((class$org$apache$muse$ws$notification$remote$NotificationProducerClient == null ? (class$org$apache$muse$ws$notification$remote$NotificationProducerClient = ProxyInterfaceSynthesizer.class$("org.apache.muse.ws.notification.remote.NotificationProducerClient")) : class$org$apache$muse$ws$notification$remote$NotificationProducerClient).isAssignableFrom(clientClass)) {
            clazz = class$org$apache$muse$ws$notification$remote$NotificationProducerClient == null ? (class$org$apache$muse$ws$notification$remote$NotificationProducerClient = ProxyInterfaceSynthesizer.class$("org.apache.muse.ws.notification.remote.NotificationProducerClient")) : class$org$apache$muse$ws$notification$remote$NotificationProducerClient;
        } else if ((class$org$apache$muse$ws$notification$remote$NotificationConsumerClient == null ? (class$org$apache$muse$ws$notification$remote$NotificationConsumerClient = ProxyInterfaceSynthesizer.class$("org.apache.muse.ws.notification.remote.NotificationConsumerClient")) : class$org$apache$muse$ws$notification$remote$NotificationConsumerClient).isAssignableFrom(clientClass)) {
            clazz = class$org$apache$muse$ws$notification$remote$NotificationConsumerClient == null ? (class$org$apache$muse$ws$notification$remote$NotificationConsumerClient = ProxyInterfaceSynthesizer.class$("org.apache.muse.ws.notification.remote.NotificationConsumerClient")) : class$org$apache$muse$ws$notification$remote$NotificationConsumerClient;
        } else {
            Class clazz2 = clazz = class$org$apache$muse$ws$resource$remote$WsResourceClient == null ? (class$org$apache$muse$ws$resource$remote$WsResourceClient = ProxyInterfaceSynthesizer.class$("org.apache.muse.ws.resource.remote.WsResourceClient")) : class$org$apache$muse$ws$resource$remote$WsResourceClient;
        }
        if (clazz != null && ((set = (Set)_clientCapabilitiesMap.get(clazz)).contains(uri) || _ignoredCapabilitySet.contains(uri))) {
            needsGeneratedCode = false;
        }
        return needsGeneratedCode;
    }

    private Class getBaseClientClass(Map capabilityMap) {
        if (capabilityMap.containsKey("http://docs.oasis-open.org/wsn/bw-2/NotificationProducer")) {
            return class$org$apache$muse$ws$notification$remote$NotificationProducerClient == null ? (class$org$apache$muse$ws$notification$remote$NotificationProducerClient = ProxyInterfaceSynthesizer.class$("org.apache.muse.ws.notification.remote.NotificationProducerClient")) : class$org$apache$muse$ws$notification$remote$NotificationProducerClient;
        }
        if (capabilityMap.containsKey("http://docs.oasis-open.org/wsn/bw-2/NotificationConsumer")) {
            return class$org$apache$muse$ws$notification$remote$NotificationConsumerClient == null ? (class$org$apache$muse$ws$notification$remote$NotificationConsumerClient = ProxyInterfaceSynthesizer.class$("org.apache.muse.ws.notification.remote.NotificationConsumerClient")) : class$org$apache$muse$ws$notification$remote$NotificationConsumerClient;
        }
        return class$org$apache$muse$ws$resource$remote$WsResourceClient == null ? (class$org$apache$muse$ws$resource$remote$WsResourceClient = ProxyInterfaceSynthesizer.class$("org.apache.muse.ws.resource.remote.WsResourceClient")) : class$org$apache$muse$ws$resource$remote$WsResourceClient;
    }

    protected String generateClassName(Document wsdlDocument) {
        String packageName = ClassInfo.getPackageName(wsdlDocument.getDocumentElement().getAttribute(TARGET_NS_ATTR));
        return packageName + "." + WsdlUtils.getServiceName((Element)XmlUtils.getDocumentRoot((Node)wsdlDocument));
    }

    protected void initializeCode(String className) {
        this._className = className;
        this._headerCode = this.beginHeaderCode(this._className);
        this._operationsCode = this.beginOperationsCode();
        this._propertiesCode = this.beginPropertiesCode();
        this._importSet = new HashSet();
        this._hasProperties = false;
        this.resetIndex();
    }

    protected void resetIndex() {
        this._index = 0;
    }

    private StringBuffer beginOperationsCode() {
        return new StringBuffer();
    }

    private StringBuffer beginPropertiesCode() {
        StringBuffer code = new StringBuffer();
        this.indent(code);
        code.append("QName[] PROPERTIES = {");
        return code;
    }

    protected void updateCode(ClassInfo classInfo) {
        Capability capability = classInfo.getCapability();
        this.updateMethods(classInfo, this._operationsCode);
        if (!capability.getProperties().isEmpty()) {
            this._hasProperties = true;
            this.updateProperties(classInfo, this._propertiesCode);
        }
        classInfo.addImports(this._importSet);
    }

    protected void updateMethods(ClassInfo classInfo, StringBuffer code) {
        Iterator i = classInfo.getCapability().getOperations().iterator();
        while (i.hasNext()) {
            JavaMethod method = (JavaMethod)i.next();
            this.generateMethod(method, classInfo, code);
        }
        i = classInfo.getCapability().getProperties().iterator();
        while (i.hasNext()) {
            JavaProperty property = (JavaProperty)i.next();
            this.generatePropertyGet(property, classInfo, this.getIndex(), code);
            if (property.isAppendable()) {
                this.generatePropertyInsert(property, classInfo, this.getIndex(), code);
            }
            if (property.isMutable()) {
                this.generatePropertyUpdate(property, classInfo, this.getIndex(), code);
                this.generatePropertyDelete(property, classInfo, this.getIndex(), code);
            }
            this.incrementIndex();
        }
    }

    private void incrementIndex() {
        ++this._index;
    }

    private int getIndex() {
        return this._index;
    }

    private void generateMethod(JavaMethod method, ClassInfo classInfo, StringBuffer code) {
        this.newLine(2, code);
        this.indent(code);
        this.generateMethodQualifier(code);
        Class returnType = method.getReturnType();
        code.append(ReflectUtils.getShortName((Class)returnType));
        code.append(' ');
        code.append(method.getJavaName());
        QName[] paramNames = method.getParameterTypeNames();
        Class[] paramTypes = method.getParameterTypes();
        this.generateParamList(paramNames, paramTypes, code);
        this.newLine(code);
        this.indent(2, code);
        code.append("throws SoapFault");
        this.addImport(class$org$apache$muse$ws$addressing$soap$SoapFault == null ? (class$org$apache$muse$ws$addressing$soap$SoapFault = ProxyInterfaceSynthesizer.class$("org.apache.muse.ws.addressing.soap.SoapFault")) : class$org$apache$muse$ws$addressing$soap$SoapFault);
        this.generateMethodBody(method, classInfo, code);
        this.newLine(code);
    }

    protected void addImports(Class[] classes) {
        for (int i = 0; i < classes.length; ++i) {
            this.addImport(classes[i]);
        }
    }

    protected void addImport(Class className) {
        this._importSet.add(className);
    }

    protected void generateMethodQualifier(StringBuffer code) {
    }

    protected void generateParamList(QName[] paramNames, Class[] paramTypes, StringBuffer code) {
        code.append('(');
        for (int n = 0; n < paramTypes.length; ++n) {
            code.append(ReflectUtils.getShortName((Class)paramTypes[n]));
            code.append(' ');
            if (paramNames != null) {
                code.append(ResourceInspector.getLowerCamelName(paramNames[n].getLocalPart()));
            } else {
                code.append(PARAM_NAME + n);
            }
            if (n == paramTypes.length - 1) continue;
            code.append(", ");
        }
        if (this._generateCustomHeaders) {
            if (paramTypes.length > 0) {
                code.append(", ");
            }
            code.append("Element[] customHeaders");
        }
        code.append(")");
    }

    protected void generateMethodBody(JavaMethod method, ClassInfo classInfo, StringBuffer code) {
        code.append(';');
    }

    private void generatePropertyGet(JavaProperty property, ClassInfo classInfo, int propertyIndex, StringBuffer code) {
        this.newLine(code);
        this.indent(code);
        this.generateMethodQualifier(code);
        Class type = property.getJavaType();
        code.append(this.convertType(type, classInfo));
        code.append(' ');
        code.append("get" + property.getName().getLocalPart());
        code.append("()");
        this.newLine(code);
        this.indent(2, code);
        code.append("throws SoapFault");
        this.addImport(class$org$apache$muse$ws$addressing$soap$SoapFault == null ? (class$org$apache$muse$ws$addressing$soap$SoapFault = ProxyInterfaceSynthesizer.class$("org.apache.muse.ws.addressing.soap.SoapFault")) : class$org$apache$muse$ws$addressing$soap$SoapFault);
        this.generatePropertyGetBody(property, classInfo, propertyIndex, code);
        this.newLine(code);
    }

    protected void generatePropertyGetBody(JavaProperty property, ClassInfo classInfo, int propertyIndex, StringBuffer code) {
        code.append(';');
    }

    private void generatePropertyUpdate(JavaProperty property, ClassInfo classInfo, int propertyIndex, StringBuffer code) {
        this.generatePropertySet(property, classInfo, propertyIndex, "update", code);
    }

    private void generatePropertyInsert(JavaProperty property, ClassInfo classInfo, int propertyIndex, StringBuffer code) {
        this.generatePropertySet(property, classInfo, propertyIndex, "insert", code);
    }

    private void generatePropertySet(JavaProperty property, ClassInfo classInfo, int propertyIndex, String setType, StringBuffer code) {
        this.newLine(code);
        this.indent(code);
        this.generateMethodQualifier(code);
        Class type = property.getJavaType();
        if (type.isArray()) {
            type = ReflectUtils.getClassFromArrayClass((Class)type);
        }
        code.append("void ");
        code.append(setType);
        code.append(property.getName().getLocalPart());
        code.append('(');
        code.append(ReflectUtils.getShortName((Class)type));
        code.append(" value)");
        this.newLine(code);
        this.indent(2, code);
        code.append("throws SoapFault");
        this.addImport(class$org$apache$muse$ws$addressing$soap$SoapFault == null ? (class$org$apache$muse$ws$addressing$soap$SoapFault = ProxyInterfaceSynthesizer.class$("org.apache.muse.ws.addressing.soap.SoapFault")) : class$org$apache$muse$ws$addressing$soap$SoapFault);
        this.generatePropertySetBody(property, classInfo, propertyIndex, setType, code);
        this.newLine(code);
    }

    protected void generatePropertySetBody(JavaProperty property, ClassInfo classInfo, int propertyIndex, String setType, StringBuffer code) {
        code.append(';');
    }

    private void generatePropertyDelete(JavaProperty property, ClassInfo classInfo, int propertyIndex, StringBuffer code) {
        this.newLine(code);
        this.indent(code);
        this.generateMethodQualifier(code);
        code.append("void delete" + property.getName().getLocalPart());
        code.append("()");
        this.newLine(code);
        this.indent(2, code);
        code.append("throws SoapFault");
        this.addImport(class$org$apache$muse$ws$addressing$soap$SoapFault == null ? (class$org$apache$muse$ws$addressing$soap$SoapFault = ProxyInterfaceSynthesizer.class$("org.apache.muse.ws.addressing.soap.SoapFault")) : class$org$apache$muse$ws$addressing$soap$SoapFault);
        this.generatePropertyDeleteBody(property, classInfo, propertyIndex, code);
        this.newLine(code);
    }

    protected void generatePropertyDeleteBody(JavaProperty property, ClassInfo classInfo, int propertyIndex, StringBuffer code) {
        code.append(';');
    }

    private void updateProperties(ClassInfo classInfo, StringBuffer code) {
        Iterator i = classInfo.getCapability().getProperties().iterator();
        if (i.hasNext()) {
            this.addImport(class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = ProxyInterfaceSynthesizer.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName);
        }
        while (i.hasNext()) {
            this.generatePropertyConstant((JavaProperty)i.next(), code);
        }
    }

    private void generatePropertyConstant(JavaProperty property, StringBuffer code) {
        this.newLine(code);
        this.indent(2, code);
        this.generateQName(property.getName(), code);
        code.append(",");
    }

    protected String generateCombinedCode(ClassInfo classInfo) {
        this.endHeaderCode(classInfo);
        this.endOperationsCode();
        this.endPropertiesCode();
        StringBuffer code = new StringBuffer();
        code.append(this._headerCode);
        code.append(this._operationsCode);
        if (this._hasProperties) {
            code.append(this._propertiesCode);
        }
        return code.append(this.generateFooterCode()).toString();
    }

    protected void endHeaderCode(ClassInfo classInfo) {
        this.generateImports(classInfo, this._headerCode);
        this.generateClassDef(this._className, true, this._headerCode);
    }

    private void endOperationsCode() {
        this.newLine(this._operationsCode);
    }

    private void endPropertiesCode() {
        int length = this._propertiesCode.length();
        this._propertiesCode.delete(length - 1, length);
        this.newLine(this._propertiesCode);
        this.indent(this._propertiesCode);
        this.generateCloseBlock(this._propertiesCode);
        this._propertiesCode.append(";");
        this.newLine(this._propertiesCode);
    }

    private StringBuffer generateFooterCode() {
        StringBuffer code = new StringBuffer();
        this.newLine(code);
        this.generateCloseBlock(code);
        this.newLine(code);
        return code;
    }

    public ConfigurationDataDescriptor[] getConfigurationDataDescriptions() {
        return REQUIRED_PARAMETERS;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        _ignoredCapabilitySet.add("http://schemas.xmlsoap.org/ws/2004/09/mex");
        _clientCapabilitiesMap = new HashMap();
        HashSet<String> baseClientset = new HashSet<String>();
        baseClientset.add("http://docs.oasis-open.org/wsrf/rpw-2/Get");
        baseClientset.add("http://docs.oasis-open.org/wsrf/rpw-2/Query");
        baseClientset.add("http://docs.oasis-open.org/wsrf/rpw-2/Set");
        baseClientset.add("http://docs.oasis-open.org/wsrf/rlw-2/ImmediateResourceTermination");
        baseClientset.add("http://docs.oasis-open.org/wsrf/rlw-2/ScheduledResourceTermination");
        _clientCapabilitiesMap.put(class$org$apache$muse$ws$resource$remote$WsResourceClient == null ? (class$org$apache$muse$ws$resource$remote$WsResourceClient = ProxyInterfaceSynthesizer.class$("org.apache.muse.ws.resource.remote.WsResourceClient")) : class$org$apache$muse$ws$resource$remote$WsResourceClient, baseClientset);
        HashSet<String> set = new HashSet<String>();
        set.add("http://docs.oasis-open.org/wsn/bw-2/NotificationProducer");
        set.addAll(baseClientset);
        _clientCapabilitiesMap.put(class$org$apache$muse$ws$notification$remote$NotificationProducerClient == null ? (class$org$apache$muse$ws$notification$remote$NotificationProducerClient = ProxyInterfaceSynthesizer.class$("org.apache.muse.ws.notification.remote.NotificationProducerClient")) : class$org$apache$muse$ws$notification$remote$NotificationProducerClient, set);
        set = new HashSet();
        set.add("http://docs.oasis-open.org/wsn/bw-2/NotificationConsumer");
        set.addAll(baseClientset);
        _clientCapabilitiesMap.put(class$org$apache$muse$ws$notification$remote$NotificationConsumerClient == null ? (class$org$apache$muse$ws$notification$remote$NotificationConsumerClient = ProxyInterfaceSynthesizer.class$("org.apache.muse.ws.notification.remote.NotificationConsumerClient")) : class$org$apache$muse$ws$notification$remote$NotificationConsumerClient, set);
    }
}

