/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.tools.generator.util;

import java.io.File;
import javax.xml.namespace.QName;
import org.apache.muse.core.descriptor.DescriptorConstants;
import org.apache.muse.tools.generator.util.Capability;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.wsdl.WsdlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DeploymentDescriptorHelper {
    private Document _descriptorDocument;
    private Element _wsdlFileElement;
    private Element _resourceTypeElement;
    private Element _contextPathElement;
    private Element _javaResourceClass;
    private static Messages _MESSAGES = MessagesFactory.get((Object)(class$org$apache$muse$tools$generator$util$DeploymentDescriptorHelper == null ? (class$org$apache$muse$tools$generator$util$DeploymentDescriptorHelper = DeploymentDescriptorHelper.class$("org.apache.muse.tools.generator.util.DeploymentDescriptorHelper")) : class$org$apache$muse$tools$generator$util$DeploymentDescriptorHelper));
    static /* synthetic */ Class class$org$apache$muse$tools$generator$util$DeploymentDescriptorHelper;

    public DeploymentDescriptorHelper(Document descriptorDocument, Document wsdlDocument, int resourceIndex) throws Exception {
        this._descriptorDocument = descriptorDocument;
        this._resourceTypeElement = this.findResourceTypeElement(this._descriptorDocument, wsdlDocument, resourceIndex);
        this._wsdlFileElement = XmlUtils.findFirstInSubTree((Element)this._resourceTypeElement, (QName)DescriptorConstants.WSDL_FILE_QNAME);
        this._contextPathElement = XmlUtils.findFirstInSubTree((Element)this._resourceTypeElement, (QName)DescriptorConstants.CONTEXT_PATH_QNAME);
        this._javaResourceClass = XmlUtils.findFirstInSubTree((Element)this._resourceTypeElement, (QName)DescriptorConstants.JAVA_RESOURCE_QNAME);
    }

    private Element findResourceTypeElement(Document descriptorDocument, Document wsdlDocument, int resourceIndex) throws Exception {
        Element portTypeElement = XmlUtils.findFirstInSubTree((Element)wsdlDocument.getDocumentElement(), (QName)WsdlUtils.PORT_TYPE_QNAME);
        if (portTypeElement == null) {
            throw new Exception(_MESSAGES.get("NoPortType"));
        }
        String portTypeName = portTypeElement.getAttribute("name");
        if (portTypeName == null) {
            throw new Exception(_MESSAGES.get("NoPortTypeName"));
        }
        String portTypeURI = wsdlDocument.getDocumentElement().getAttribute("targetNamespace");
        if (portTypeURI == null) {
            throw new Exception(_MESSAGES.get("NoTargetNamespace"));
        }
        Element[] resourceTypes = XmlUtils.findInSubTree((Element)this._descriptorDocument.getDocumentElement(), (QName)DescriptorConstants.RESOURCE_TYPE_QNAME);
        if (resourceTypes.length < 1) {
            throw new Exception(_MESSAGES.get("NoResourceTypeElements"));
        }
        if (resourceIndex >= resourceTypes.length) {
            Object[] filler = new Object[]{new Integer(resourceIndex), new Integer(resourceTypes.length)};
            throw new IndexOutOfBoundsException(_MESSAGES.get("InvalidResourceIndex", filler));
        }
        if (this.findPortTypeElement(resourceTypes[resourceIndex], portTypeName, portTypeURI) != null) {
            return resourceTypes[resourceIndex];
        }
        if (resourceTypes.length != 1) {
            Object[] filler = new Object[]{portTypeName, portTypeURI};
            throw new Exception(_MESSAGES.get("NoPortTypeMultipleCapabilities", filler));
        }
        portTypeElement = XmlUtils.findFirstInSubTree((Element)resourceTypes[0], (QName)DescriptorConstants.WSDL_PORT_TYPE_QNAME);
        if (portTypeElement == null) {
            throw new Exception(_MESSAGES.get("NoPortTypeElement"));
        }
        String prefix = "pfx";
        XmlUtils.setElementText((Element)portTypeElement, (String)(prefix + ":" + portTypeName));
        XmlUtils.setNamespaceAttribute((Element)portTypeElement, (String)prefix, (String)portTypeURI);
        return resourceTypes[0];
    }

    private Element findPortTypeElement(Element resourceTypeElement, String portTypeName, String portTypeURI) throws Exception {
        Element portTypeElement = XmlUtils.findFirstInSubTree((Element)resourceTypeElement, (QName)DescriptorConstants.WSDL_PORT_TYPE_QNAME);
        if (portTypeElement == null) {
            Object[] filler = new Object[]{XmlUtils.toString((Node)resourceTypeElement)};
            throw new Exception(_MESSAGES.get("NoPortTypeElement", filler));
        }
        String qname = XmlUtils.extractText((Element)portTypeElement);
        if (qname == null) {
            return null;
        }
        String namespace = XmlUtils.resolveNamespace((String)qname, (Node)portTypeElement);
        if (namespace == portTypeURI && namespace == null) {
            return portTypeElement;
        }
        if (portTypeURI.equals(namespace)) {
            return portTypeElement;
        }
        return null;
    }

    public Capability[] getCapabilities() {
        Element[] capabilityElements = XmlUtils.findInSubTree((Element)this._resourceTypeElement, (QName)DescriptorConstants.CAPABILITY_QNAME);
        Capability[] capabilities = new Capability[capabilityElements.length];
        for (int i = 0; i < capabilityElements.length; ++i) {
            Element capabilityURIElement = XmlUtils.findFirstInSubTree((Element)capabilityElements[i], (QName)DescriptorConstants.CAPABILITY_URI_QNAME);
            Element javaResourceClassElement = XmlUtils.findFirstInSubTree((Element)capabilityElements[i], (QName)DescriptorConstants.JAVA_CAPABILITY_QNAME);
            String capabilityURI = XmlUtils.extractText((Element)capabilityURIElement);
            String javaResourceClass = XmlUtils.extractText((Element)javaResourceClassElement);
            if (javaResourceClass == null || javaResourceClass.length() == 0) {
                javaResourceClass = null;
            }
            capabilities[i] = new Capability(capabilityURI);
            capabilities[i].setImplementingClass(javaResourceClass);
        }
        return capabilities;
    }

    private Element findCapabilityElement(String uri) {
        Element[] capabilities = XmlUtils.findInSubTree((Element)this._resourceTypeElement, (QName)DescriptorConstants.CAPABILITY_QNAME);
        for (int i = 0; i < capabilities.length; ++i) {
            Element capabilityURIElement = XmlUtils.findFirstInSubTree((Element)capabilities[i], (QName)DescriptorConstants.CAPABILITY_URI_QNAME);
            String capabilityURI = XmlUtils.extractText((Element)capabilityURIElement);
            if (!uri.equals(capabilityURI)) continue;
            return capabilities[i];
        }
        return null;
    }

    public void setWsdlFile(String wsdlFileName) {
        XmlUtils.setElementText((Element)this._wsdlFileElement, (String)wsdlFileName);
    }

    public void setContextPath(String contextPathName) {
        XmlUtils.setElementText((Element)this._contextPathElement, (String)contextPathName);
    }

    public void setJavaResourceClass(String name) {
        XmlUtils.setElementText((Element)this._javaResourceClass, (String)name);
    }

    public void addCapability(Capability capability) {
        Element javaResourceClassElement;
        Element capabilityElement = this.findCapabilityElement(capability.getURI());
        if (capabilityElement == null) {
            capabilityElement = XmlUtils.createElement((Document)this._descriptorDocument, (QName)DescriptorConstants.CAPABILITY_QNAME);
            Element capabilityUriElement = XmlUtils.createElement((Document)this._descriptorDocument, (QName)DescriptorConstants.CAPABILITY_URI_QNAME, (Object)capability.getURI());
            capabilityElement.appendChild(capabilityUriElement);
            this._resourceTypeElement.appendChild(capabilityElement);
        }
        if ((javaResourceClassElement = XmlUtils.findFirstInSubTree((Element)capabilityElement, (QName)DescriptorConstants.JAVA_CAPABILITY_QNAME)) == null) {
            javaResourceClassElement = XmlUtils.createElement((Document)this._descriptorDocument, (QName)DescriptorConstants.JAVA_CAPABILITY_QNAME);
            capabilityElement.appendChild(javaResourceClassElement);
        }
        XmlUtils.setElementText((Element)javaResourceClassElement, (String)capability.getImplementingClass());
    }

    public static File[] getWsdls(File deploymentDescriptorFile, Document deploymentDescriptorDocument) throws Exception {
        Element[] wsdlFileElements = XmlUtils.findInSubTree((Element)deploymentDescriptorDocument.getDocumentElement(), (QName)DescriptorConstants.WSDL_FILE_QNAME);
        File[] files = new File[wsdlFileElements.length];
        for (int i = 0; i < wsdlFileElements.length; ++i) {
            String wsdlFileName = XmlUtils.extractText((Element)wsdlFileElements[i]);
            if (wsdlFileName == null || wsdlFileName.length() == 0) {
                Object[] filler = new Object[]{deploymentDescriptorFile.getAbsolutePath()};
                throw new Exception(_MESSAGES.get("EmptyWsdlFileElement", filler));
            }
            files[i] = new File(deploymentDescriptorFile.getAbsoluteFile().getParentFile(), wsdlFileName);
            if (files[i].exists()) continue;
            Object[] filler = new Object[]{files[i].getAbsolutePath()};
            throw new Exception(_MESSAGES.get("RelativeWsdlFileNotFound", filler));
        }
        return files;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

