/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.tools.inspector;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.apache.muse.core.Environment;
import org.apache.muse.core.proxy.ProxyHandler;
import org.apache.muse.core.proxy.ReflectionProxyHandler;
import org.apache.muse.tools.inspector.JavaMethod;
import org.apache.muse.util.ReflectUtils;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.util.xml.XsdUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.WsaConstants;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.notification.WsnConstants;
import org.apache.muse.ws.resource.lifetime.WsrlConstants;
import org.apache.muse.ws.resource.metadata.MetadataDescriptor;
import org.apache.muse.ws.resource.metadata.OpenMetadataDescriptor;
import org.apache.muse.ws.resource.properties.WsrpConstants;
import org.apache.muse.ws.resource.properties.impl.WsrpUtils;
import org.apache.muse.ws.resource.properties.schema.ResourcePropertiesSchema;
import org.apache.muse.ws.resource.properties.schema.impl.SimpleResourcePropertiesSchema;
import org.apache.muse.ws.resource.remote.WsResourceClient;
import org.apache.muse.ws.wsdl.WsdlUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ResourceInspector {
    private static Messages _MESSAGES = MessagesFactory.get((Object)(class$org$apache$muse$tools$inspector$ResourceInspector == null ? (class$org$apache$muse$tools$inspector$ResourceInspector = ResourceInspector.class$("org.apache.muse.tools.inspector.ResourceInspector")) : class$org$apache$muse$tools$inspector$ResourceInspector));
    private static final Set _BASIC_RESOURCE_METHODS = new HashSet();
    private static final Map _JAVA_TYPES = new HashMap();
    public static final String NAMESPACE_URI = "http://www.w3.org/2001/XMLSchema";
    public static final String PREFIX = "xsd";
    public static final QName ANY_TYPE_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "anyType", "xsd");
    public static final QName ANY_URI_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "anyURI", "xsd");
    public static final QName ATTRIBUTE_GROUP_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "attributeGroup", "xsd");
    public static final QName ATTRIBUTE_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "attribute", "xsd");
    public static final QName BOOLEAN_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "boolean", "xsd");
    public static final QName COMPLEX_TYPE_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "complexType", "xsd");
    public static final QName DATE_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "date", "xsd");
    public static final QName DATE_TIME_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "dateTime", "xsd");
    public static final QName DOUBLE_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "double", "xsd");
    public static final QName DURATION_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "duration", "xsd");
    public static final QName ELEMENT_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "element", "xsd");
    public static final QName FLOAT_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "float", "xsd");
    public static final QName IMPORT_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "import", "xsd");
    public static final QName INCLUDE_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "include", "xsd");
    public static final QName INT_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "int", "xsd");
    public static final QName INTEGER_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "integer", "xsd");
    public static final QName LANGSTRING_QNAME = new QName("http://docs.oasis-open.org/wsdm/muws2-2.xsd", "LangString");
    public static final QName LONG_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "long", "xsd");
    public static final QName NC_NAME_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "NCName", "xsd");
    public static final QName QNAME_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "QName", "xsd");
    public static final QName SCHEMA_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "schema", "xsd");
    public static final QName SEQUENCE_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "sequence", "xsd");
    public static final QName SHORT_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "short", "xsd");
    public static final QName SIMPLE_TYPE_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "simpleType", "xsd");
    public static final QName STRING_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "string", "xsd");
    private Class _baseProxyClass = null;
    private Map _handlersByName = null;
    private LinkedHashMap _javaMethodsByName;
    private QName _portType = null;
    private MetadataDescriptor _rmd = null;
    private ResourcePropertiesSchema _wsrpSchema = null;
    private Logger _logger = Logger.getLogger((class$org$apache$muse$tools$inspector$ResourceInspector == null ? (class$org$apache$muse$tools$inspector$ResourceInspector = ResourceInspector.class$("org.apache.muse.tools.inspector.ResourceInspector")) : class$org$apache$muse$tools$inspector$ResourceInspector).getPackage().getName());
    static /* synthetic */ Class class$org$apache$muse$tools$inspector$ResourceInspector;
    static /* synthetic */ Class class$org$w3c$dom$Element;
    static /* synthetic */ Class class$java$net$URI;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$xml$namespace$QName;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$org$apache$muse$ws$addressing$EndpointReference;
    static /* synthetic */ Class class$org$apache$muse$ws$notification$remote$NotificationProducerClient;
    static /* synthetic */ Class class$org$apache$muse$ws$notification$remote$NotificationConsumerClient;
    static /* synthetic */ Class class$org$apache$muse$ws$resource$remote$WsResourceClient;

    public static String getLowerCamelName(String operationName) {
        if (operationName == null) {
            throw new NullPointerException(_MESSAGES.get("NullOperationName"));
        }
        char first = operationName.charAt(0);
        return Character.toLowerCase(first) + operationName.substring(1);
    }

    public static QName getSchemaType(Class type) {
        Iterator i = _JAVA_TYPES.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry next = i.next();
            Class nextType = (Class)next.getValue();
            if (!type.equals(nextType)) continue;
            return (QName)next.getKey();
        }
        return null;
    }

    public static Class getXsdJavaType(QName typeName) {
        return (Class)_JAVA_TYPES.get(typeName);
    }

    private Object createBaseProxy(WsResourceClient resource) throws Exception {
        EndpointReference src = resource.getSource();
        EndpointReference dest = resource.getDestination();
        Class[] paramTypes = new Class[]{class$org$apache$muse$ws$addressing$EndpointReference == null ? (class$org$apache$muse$ws$addressing$EndpointReference = ResourceInspector.class$("org.apache.muse.ws.addressing.EndpointReference")) : class$org$apache$muse$ws$addressing$EndpointReference, class$org$apache$muse$ws$addressing$EndpointReference == null ? (class$org$apache$muse$ws$addressing$EndpointReference = ResourceInspector.class$("org.apache.muse.ws.addressing.EndpointReference")) : class$org$apache$muse$ws$addressing$EndpointReference};
        Constructor ctor = this.getBaseProxyClass().getConstructor(paramTypes);
        return ctor.newInstance(dest, src);
    }

    private JavaMethod createJavaMethod(Element wsdl, Operation op) {
        JavaMethod method = new JavaMethod();
        method.setName(this.getInputName(op));
        method.setReturnName(this.getOutputName(op));
        Element inputElement = WsdlUtils.getElementDeclaration((Node)wsdl, (QName)method.getName());
        if (inputElement == null) {
            Object[] filler = new Object[]{method.getName()};
            throw new RuntimeException(_MESSAGES.get("NoTypeDef", filler));
        }
        Element outputElement = null;
        if (method.getReturnName() != null) {
            outputElement = WsdlUtils.getElementDeclaration((Node)wsdl, (QName)method.getReturnName());
        }
        method.setReturnSchemaType(this.getSchemaType(outputElement));
        method.setReturnType(this.getJavaType(outputElement));
        Element[] paramXML = XmlUtils.findInSubTree((Element)inputElement, (QName)XsdUtils.ELEMENT_QNAME);
        Element schema = (Element)inputElement.getParentNode();
        String targetNS = schema.getAttribute("targetNamespace");
        Class[] parameterTypes = new Class[paramXML.length];
        QName[] parameterSchemaTypes = new QName[paramXML.length];
        QName[] parameterTypeNames = new QName[paramXML.length];
        for (int n = 0; n < paramXML.length; ++n) {
            String localName = paramXML[n].getAttribute("name");
            parameterTypeNames[n] = localName != null && localName.length() != 0 ? new QName(targetNS, localName, "pfx") : XmlUtils.parseQName((String)paramXML[n].getAttribute("ref"), (Element)paramXML[n]);
            parameterSchemaTypes[n] = this.getSchemaType(paramXML[n]);
            parameterTypes[n] = this.getJavaType(paramXML[n]);
        }
        Object actionURI = op.getInput().getExtensionAttribute(WsaConstants.ACTION_QNAME);
        if (actionURI != null) {
            if (actionURI instanceof QName) {
                method.setActionURI(((QName)actionURI).getLocalPart());
            } else if (actionURI instanceof String) {
                method.setActionURI(actionURI.toString());
            }
        }
        method.setParameterTypes(parameterTypes);
        method.setParameterSchemaTypes(parameterSchemaTypes);
        method.setParameterTypeNames(parameterTypeNames);
        return method;
    }

    private ProxyHandler createReflectionHandler(JavaMethod method) {
        ReflectionProxyHandler handler = new ReflectionProxyHandler();
        handler.setAction(method.getActionURI());
        handler.setRequestName(method.getName());
        handler.setRequestParameterNames(method.getParameterTypeNames());
        handler.setRequestParameterSchemaTypes(method.getParameterSchemaTypes());
        handler.setRequestParameterTypes(method.getParameterTypes());
        handler.setResponseName(method.getReturnName());
        handler.setReturnSchemaType(method.getReturnSchemaType());
        handler.setReturnType(method.getReturnType());
        return handler;
    }

    public String getAction(String operation) {
        ProxyHandler handler = this.getHandler(operation);
        if (handler != null) {
            return handler.getAction();
        }
        return null;
    }

    public Class getBaseProxyClass() {
        return this._baseProxyClass;
    }

    private Method getBaseProxyMethod(String operation) {
        Method[] methods = this.getBaseProxyClass().getMethods();
        if (!this.isBasicResourceOperation(operation)) {
            Object[] filler = new Object[]{operation};
            throw new RuntimeException(_MESSAGES.get("OperationUndefined", filler));
        }
        for (int n = 0; n < methods.length; ++n) {
            if (!methods[n].getName().equals(operation)) continue;
            return methods[n];
        }
        Object[] filler = new Object[]{operation};
        throw new RuntimeException(_MESSAGES.get("OperationUndefined", filler));
    }

    private ProxyHandler getHandler(String operation) {
        return (ProxyHandler)this._handlersByName.get(operation);
    }

    private Map getHandlers(Map operations) {
        this._baseProxyClass = this.getProxyExtends(operations);
        Iterator i = operations.keySet().iterator();
        HashMap<String, ProxyHandler> handlers = new HashMap<String, ProxyHandler>();
        while (i.hasNext()) {
            JavaMethod method = (JavaMethod)operations.get(i.next());
            if (this.isBasicResourceOperation(method.getName())) continue;
            ProxyHandler handler = this.createReflectionHandler(method);
            String javaName = method.getJavaName();
            handlers.put(javaName, handler);
        }
        return handlers;
    }

    private QName getInputName(Operation op) {
        Map parts = op.getInput().getMessage().getParts();
        if (parts.size() != 1) {
            Object[] filler = new Object[]{op.getName()};
            throw new RuntimeException(_MESSAGES.get("NotDocLiteral", filler));
        }
        Part docLiteralPart = (Part)parts.values().iterator().next();
        return docLiteralPart.getElementName();
    }

    public Map getJavaMethods() {
        return this._javaMethodsByName;
    }

    private Class getJavaType(Element outputElement) {
        if (outputElement == null) {
            return Void.TYPE;
        }
        String typeName = outputElement.getAttribute("type");
        QName typeQName = XmlUtils.parseQName((String)typeName, (Element)outputElement);
        Class type = ResourceInspector.getXsdJavaType(typeQName);
        if (type == null) {
            Class clazz = type = class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = ResourceInspector.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element;
        }
        if (this.isArrayType(outputElement)) {
            return ReflectUtils.getArrayClassFromClass((Class)type);
        }
        return type;
    }

    private boolean isArrayType(Element element) {
        String minOccursAttr = element.getAttribute("minOccurs");
        int minOccurs = 1;
        if (minOccursAttr != null && minOccursAttr.length() > 0) {
            minOccurs = Integer.valueOf(minOccursAttr);
        }
        String maxOccursAttr = element.getAttribute("maxOccurs");
        int maxOccurs = 1;
        if (maxOccursAttr != null && maxOccursAttr.length() > 0) {
            maxOccurs = maxOccursAttr.equalsIgnoreCase("unbounded") ? Integer.MAX_VALUE : Integer.valueOf(maxOccursAttr);
        }
        return maxOccurs > 1 || minOccurs > 1;
    }

    public Collection getOperations() {
        HashSet ops = new HashSet(this._handlersByName.keySet());
        Method[] baseOps = this.getBaseProxyClass().getMethods();
        for (int n = 0; n < baseOps.length; ++n) {
            if (!this.isBasicResourceOperation(baseOps[n].getName())) continue;
            ops.add(baseOps[n].getName());
        }
        return ops;
    }

    private Map getOperations(Definition wsdlDef, Element wsdlXML, QName portTypeName) {
        PortType portType = wsdlDef.getPortType(portTypeName);
        List operations = portType.getOperations();
        this._javaMethodsByName = new LinkedHashMap();
        Iterator i = operations.iterator();
        while (i.hasNext()) {
            Operation next = (Operation)i.next();
            JavaMethod method = this.createJavaMethod(wsdlXML, next);
            this._javaMethodsByName.put(method.getName(), method);
        }
        return this.getHandlers(this._javaMethodsByName);
    }

    private QName getOutputName(Operation op) {
        Output output = op.getOutput();
        if (output == null) {
            return null;
        }
        Map parts = output.getMessage().getParts();
        if (parts.size() != 1) {
            Object[] filler = new Object[]{op.getName()};
            throw new RuntimeException(_MESSAGES.get("NotDocLiteral", filler));
        }
        Part docLiteralPart = (Part)parts.values().iterator().next();
        return docLiteralPart.getElementName();
    }

    public String[] getParameterNames(String operation) {
        QName[] qnames = this.getParameterQNames(operation);
        String[] names = new String[qnames.length];
        for (int n = 0; n < qnames.length; ++n) {
            names[n] = ResourceInspector.getLowerCamelName(qnames[n].getLocalPart());
        }
        return names;
    }

    public QName[] getParameterQNames(String operation) {
        ProxyHandler handler = this.getHandler(operation);
        if (handler != null) {
            return handler.getRequestParameterNames();
        }
        return new QName[0];
    }

    public QName[] getParameterSchemaTypes(String operation) {
        ProxyHandler handler = this.getHandler(operation);
        if (handler != null) {
            return handler.getRequestParameterSchemaTypes();
        }
        Method method = this.getBaseProxyMethod(operation);
        Class<?>[] types = method.getParameterTypes();
        QName[] qnames = new QName[types.length];
        for (int n = 0; n < types.length; ++n) {
            qnames[n] = ResourceInspector.getSchemaType(types[n]);
        }
        return qnames;
    }

    public Class[] getParameterTypes(String operation) {
        ProxyHandler handler = this.getHandler(operation);
        if (handler != null) {
            return handler.getRequestParameterTypes();
        }
        Method method = this.getBaseProxyMethod(operation);
        return method.getParameterTypes();
    }

    public QName getPortType() {
        return this._portType;
    }

    private QName getPortType(Definition wsdl) {
        Map services = wsdl.getServices();
        if (services.size() != 1) {
            throw new RuntimeException(_MESSAGES.get("OneServicePerWSDL"));
        }
        Service service = (Service)services.values().iterator().next();
        Map ports = service.getPorts();
        if (ports.size() != 1) {
            throw new RuntimeException(_MESSAGES.get("OnePortPerWSDL"));
        }
        Port port = (Port)ports.values().iterator().next();
        PortType portType = port.getBinding().getPortType();
        return portType.getQName();
    }

    public Collection getProperties() {
        return this._wsrpSchema == null ? null : this._wsrpSchema.getPropertyNames();
    }

    public Class getPropertyType(QName property) {
        Class javaType;
        QName type = this._wsrpSchema.getPropertyTypeName(property);
        if (type.getNamespaceURI() == null || type.getNamespaceURI().length() == 0) {
            type = new QName(NAMESPACE_URI, type.getLocalPart(), PREFIX);
        }
        if ((javaType = ResourceInspector.getXsdJavaType(type)) == null) {
            Class clazz = javaType = class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = ResourceInspector.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element;
        }
        if (this.isPropertyMultiple(property)) {
            javaType = ReflectUtils.getArrayClassFromClass((Class)javaType);
        }
        return javaType;
    }

    private Class getProxyExtends(Map operations) {
        if (operations.keySet().contains(WsnConstants.SUBSCRIBE_QNAME)) {
            return class$org$apache$muse$ws$notification$remote$NotificationProducerClient == null ? (class$org$apache$muse$ws$notification$remote$NotificationProducerClient = ResourceInspector.class$("org.apache.muse.ws.notification.remote.NotificationProducerClient")) : class$org$apache$muse$ws$notification$remote$NotificationProducerClient;
        }
        if (operations.keySet().contains(WsnConstants.NOTIFY_QNAME)) {
            return class$org$apache$muse$ws$notification$remote$NotificationConsumerClient == null ? (class$org$apache$muse$ws$notification$remote$NotificationConsumerClient = ResourceInspector.class$("org.apache.muse.ws.notification.remote.NotificationConsumerClient")) : class$org$apache$muse$ws$notification$remote$NotificationConsumerClient;
        }
        return class$org$apache$muse$ws$resource$remote$WsResourceClient == null ? (class$org$apache$muse$ws$resource$remote$WsResourceClient = ResourceInspector.class$("org.apache.muse.ws.resource.remote.WsResourceClient")) : class$org$apache$muse$ws$resource$remote$WsResourceClient;
    }

    public QName getRequestName(String operation) {
        ProxyHandler handler = this.getHandler(operation);
        if (handler != null) {
            return handler.getRequestName();
        }
        return null;
    }

    public QName getReturnName(String operation) {
        ProxyHandler handler = this.getHandler(operation);
        if (handler != null) {
            return handler.getResponseName();
        }
        return null;
    }

    public QName getReturnSchemaType(String operation) {
        ProxyHandler handler = this.getHandler(operation);
        if (handler != null) {
            return handler.getReturnSchemaType();
        }
        Method method = this.getBaseProxyMethod(operation);
        Class<?> type = method.getReturnType();
        return ResourceInspector.getSchemaType(type);
    }

    public Class getReturnType(String operation) {
        ProxyHandler handler = this.getHandler(operation);
        if (handler != null) {
            return handler.getReturnType();
        }
        Method method = this.getBaseProxyMethod(operation);
        return method.getReturnType();
    }

    private QName getSchemaType(Element element) {
        if (element == null) {
            return null;
        }
        String typeName = element.getAttribute("type");
        if (typeName == null || typeName.length() == 0) {
            return XsdUtils.ANY_TYPE_QNAME;
        }
        return XmlUtils.parseQName((String)typeName, (Element)element);
    }

    private ResourcePropertiesSchema getWsrpSchema(Element wsdl, QName portType) {
        QName wsrpName = WsrpUtils.getPropertiesName((Node)wsdl, (QName)portType);
        Element wsrp = WsdlUtils.getElementDeclaration((Node)wsdl, (QName)wsrpName);
        return new SimpleResourcePropertiesSchema(wsrpName, wsrp);
    }

    public Object invoke(WsResourceClient resource, String operation, Object[] parameters) throws SoapFault {
        ProxyHandler handler = this.getHandler(operation);
        if (handler != null) {
            return resource.invoke(handler, parameters);
        }
        Object proxy = null;
        try {
            proxy = this.createBaseProxy(resource);
        }
        catch (Exception error) {
            throw new RuntimeException(error.getMessage(), error);
        }
        Method method = this.getBaseProxyMethod(operation);
        try {
            return method.invoke(proxy, parameters);
        }
        catch (Exception error) {
            throw new SoapFault((Throwable)error);
        }
    }

    public boolean isBasicResourceOperation(QName name) {
        return _BASIC_RESOURCE_METHODS.contains(name);
    }

    public boolean isBasicResourceOperation(String name) {
        Iterator i = _BASIC_RESOURCE_METHODS.iterator();
        while (i.hasNext()) {
            QName qname = (QName)i.next();
            if (!name.equalsIgnoreCase(qname.getLocalPart())) continue;
            return true;
        }
        return false;
    }

    public boolean isPropertyAppendable(QName property) {
        return !this._rmd.isReadOnlyExternal(property) && this._rmd.canInsert(property);
    }

    public boolean isPropertyMultiple(QName property) {
        return this._wsrpSchema.getMaxOccurs(property) > 1;
    }

    public boolean isPropertyMutable(QName property) {
        return !this._rmd.isReadOnlyExternal(property) && this._rmd.canUpdate(property);
    }

    public void run(Element wsdl) {
        this.run(wsdl, null);
    }

    public void run(Element wsdl, Environment env) {
        Definition def = null;
        String path = null;
        if (env != null) {
            path = env.getRealDirectory().getAbsolutePath();
        }
        try {
            WSDLFactory factory = WSDLFactory.newInstance();
            WSDLReader reader = factory.newWSDLReader();
            reader.setFeature("javax.wsdl.verbose", false);
            def = reader.readWSDL(path, wsdl);
        }
        catch (Exception error) {
            throw new RuntimeException(error);
        }
        this._portType = this.getPortType(def);
        try {
            this._wsrpSchema = this.getWsrpSchema(wsdl, this._portType);
        }
        catch (Exception e) {
            this._logger.warning(_MESSAGES.get("NoWSRPSchema"));
        }
        this._handlersByName = this.getOperations(def, wsdl, this._portType);
    }

    public void setMetadata(MetadataDescriptor descriptor) {
        this._rmd = descriptor != null ? descriptor : OpenMetadataDescriptor.getInstance();
    }

    public MetadataDescriptor getMetadata() {
        return this._rmd;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        _BASIC_RESOURCE_METHODS.add(WsrpConstants.GET_QNAME);
        _BASIC_RESOURCE_METHODS.add(WsrpConstants.GET_MULTIPLE_QNAME);
        _BASIC_RESOURCE_METHODS.add(WsrpConstants.QUERY_QNAME);
        _BASIC_RESOURCE_METHODS.add(WsrpConstants.SET_QNAME);
        _BASIC_RESOURCE_METHODS.add(WsrlConstants.DESTROY_QNAME);
        _BASIC_RESOURCE_METHODS.add(WsrlConstants.SET_TERMINATION_QNAME);
        _BASIC_RESOURCE_METHODS.add(WsnConstants.NOTIFY_QNAME);
        _BASIC_RESOURCE_METHODS.add(WsnConstants.SUBSCRIBE_QNAME);
        _BASIC_RESOURCE_METHODS.add(WsnConstants.GET_CURRENT_QNAME);
        _JAVA_TYPES.put(ANY_TYPE_QNAME, class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = ResourceInspector.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element);
        _JAVA_TYPES.put(ANY_URI_QNAME, class$java$net$URI == null ? (class$java$net$URI = ResourceInspector.class$("java.net.URI")) : class$java$net$URI);
        _JAVA_TYPES.put(STRING_QNAME, class$java$lang$String == null ? (class$java$lang$String = ResourceInspector.class$("java.lang.String")) : class$java$lang$String);
        _JAVA_TYPES.put(NC_NAME_QNAME, class$java$lang$String == null ? (class$java$lang$String = ResourceInspector.class$("java.lang.String")) : class$java$lang$String);
        _JAVA_TYPES.put(QNAME_QNAME, class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = ResourceInspector.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName);
        _JAVA_TYPES.put(BOOLEAN_QNAME, Boolean.TYPE);
        _JAVA_TYPES.put(INT_QNAME, Integer.TYPE);
        _JAVA_TYPES.put(INTEGER_QNAME, Integer.TYPE);
        _JAVA_TYPES.put(SHORT_QNAME, Short.TYPE);
        _JAVA_TYPES.put(LONG_QNAME, Long.TYPE);
        _JAVA_TYPES.put(FLOAT_QNAME, Float.TYPE);
        _JAVA_TYPES.put(DOUBLE_QNAME, Double.TYPE);
        _JAVA_TYPES.put(DATE_QNAME, class$java$util$Date == null ? (class$java$util$Date = ResourceInspector.class$("java.util.Date")) : class$java$util$Date);
        _JAVA_TYPES.put(DATE_TIME_QNAME, class$java$util$Date == null ? (class$java$util$Date = ResourceInspector.class$("java.util.Date")) : class$java$util$Date);
        _JAVA_TYPES.put(DURATION_QNAME, class$java$lang$String == null ? (class$java$lang$String = ResourceInspector.class$("java.lang.String")) : class$java$lang$String);
        _JAVA_TYPES.put(LANGSTRING_QNAME, class$java$lang$String == null ? (class$java$lang$String = ResourceInspector.class$("java.lang.String")) : class$java$lang$String);
        _JAVA_TYPES.put(WsaConstants.EPR_QNAME, class$org$apache$muse$ws$addressing$EndpointReference == null ? (class$org$apache$muse$ws$addressing$EndpointReference = ResourceInspector.class$("org.apache.muse.ws.addressing.EndpointReference")) : class$org$apache$muse$ws$addressing$EndpointReference);
        _JAVA_TYPES.put(WsaConstants.EPR_TYPE_QNAME, class$org$apache$muse$ws$addressing$EndpointReference == null ? (class$org$apache$muse$ws$addressing$EndpointReference = ResourceInspector.class$("org.apache.muse.ws.addressing.EndpointReference")) : class$org$apache$muse$ws$addressing$EndpointReference);
    }
}

