/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.RowBandAction;
import org.eclipse.birt.report.model.api.RowBandAdapter;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.RowOperationParameters;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.elements.TableRow;

public class RowBandShiftAction
extends RowBandAction {
    public RowBandShiftAction(RowBandAdapter adapter) {
        super(adapter);
    }

    protected boolean canShift(RowOperationParameters parameters) {
        if (this.adapter.hasParent()) {
            return false;
        }
        int destIndex = parameters.getDestIndex();
        int sourceIndex = parameters.getSourceIndex();
        SlotHandle slotHandle = this.getSlotHandle(parameters);
        if (slotHandle == null) {
            return false;
        }
        if (sourceIndex < 0 || sourceIndex >= slotHandle.getCount()) {
            return false;
        }
        if (destIndex < 0 || destIndex > slotHandle.getCount()) {
            return false;
        }
        if (sourceIndex == destIndex) {
            return false;
        }
        RowHandle sourceHandle = (RowHandle)slotHandle.get(sourceIndex);
        if (destIndex > 0) {
            --destIndex;
        }
        RowHandle destHandle = (RowHandle)slotHandle.get(destIndex);
        return this.isRectangleArea(sourceHandle) && this.isRectangleArea(destHandle) && !this.containsRowSpan(sourceHandle) && !this.containsRowSpan(destHandle);
    }

    protected void doShift(RowOperationParameters parameters) throws SemanticException {
        if (!this.canShift(parameters)) {
            throw new SemanticError(this.adapter.getElementHandle().getElement(), new String[]{this.adapter.getElementHandle().getName()}, "Error.SemanticError.ROW_SHIFT_FORBIDDEN");
        }
        int destIndex = parameters.getDestIndex();
        int sourceIndex = parameters.getSourceIndex();
        SlotHandle slotHandle = this.getSlotHandle(parameters);
        ActivityStack stack = this.adapter.getModule().getActivityStack();
        try {
            stack.startTrans();
            RowHandle rowHandle = (RowHandle)slotHandle.get(sourceIndex);
            TableRow copiedRow = this.copyRow(rowHandle);
            this.adapter.getModule().getModuleHandle().rename(copiedRow.getHandle(this.adapter.getModule()));
            slotHandle.drop(sourceIndex);
            if (sourceIndex < destIndex && destIndex > 0) {
                --destIndex;
            }
            slotHandle.paste(copiedRow.getHandle(slotHandle.getModule()), destIndex);
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
    }
}

