/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.StyleEvent;
import org.eclipse.birt.report.model.core.BackRef;
import org.eclipse.birt.report.model.core.CachedMemberRef;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.IReferencableElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.ReferencableStyledElement;
import org.eclipse.birt.report.model.core.ReferenceableElement;
import org.eclipse.birt.report.model.metadata.ElementRefValue;

public class ReferenceableElementAdapter
implements IReferencableElement,
Cloneable {
    protected ArrayList clients = new ArrayList();
    private DesignElement element;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.core.ReferenceableElementAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public ReferenceableElementAdapter(ReferenceableElement element) {
        this.element = element;
    }

    public ReferenceableElementAdapter(ReferencableStyledElement element) {
        this.element = element;
    }

    public Object clone() throws CloneNotSupportedException {
        ReferenceableElementAdapter adapter = (ReferenceableElementAdapter)super.clone();
        adapter.clients = new ArrayList();
        return adapter;
    }

    public void addClient(DesignElement client, String propName) {
        this.clients.add(new BackRef(client, propName));
    }

    public void dropClient(DesignElement client) {
        this.dropClient(client, (String)null);
    }

    public void dropClient(DesignElement client, String propName) {
        int i = 0;
        while (i < this.clients.size()) {
            BackRef ref = (BackRef)this.clients.get(i);
            if (ref.element == client && (propName == null || ref.propName.equals(propName))) {
                this.clients.remove(i);
                return;
            }
            ++i;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public List getClientList() {
        return new ArrayList(this.clients);
    }

    public boolean hasReferences() {
        return !this.clients.isEmpty();
    }

    protected void broadcastToClients(NotificationEvent ev, Module module) {
        int i = 0;
        while (i < this.clients.size()) {
            BackRef ref = (BackRef)this.clients.get(i);
            DesignElement target = ref.element;
            if ("extends".equalsIgnoreCase(ref.getPropertyName())) {
                ev.setDeliveryPath(2);
            } else if ("style".equalsIgnoreCase(ref.getPropertyName())) {
                ev.setDeliveryPath(2);
            } else {
                ev.setDeliveryPath(4);
            }
            target.broadcast(ev, module);
            ++i;
        }
    }

    public void updateClientReferences() {
        Iterator backRefIter = new ArrayList(this.clients).iterator();
        while (backRefIter.hasNext()) {
            BackRef ref = (BackRef)backRefIter.next();
            DesignElement client = ref.element;
            Module root = client.getRoot();
            CachedMemberRef memberRef = ref.getCachedMemberRef();
            Object value = null;
            value = memberRef != null ? client.getLocalProperty(root, memberRef.getPropDefn()) : client.getLocalProperty(root, ref.propName);
            if (value instanceof ElementRefValue) {
                ElementRefValue refValue = (ElementRefValue)value;
                refValue.unresolved(refValue.getName());
                this.dropClient(client);
            } else if (value instanceof List) {
                List valueList = (List)value;
                int i = 0;
                while (i < valueList.size()) {
                    ElementRefValue item = (ElementRefValue)valueList.get(i);
                    if (item.getElement() == this.element) {
                        item.unresolved(item.getName());
                        this.dropClient(client);
                    }
                    ++i;
                }
            }
            if ("style".equalsIgnoreCase(ref.propName)) {
                client.broadcast(new StyleEvent(client));
                continue;
            }
            client.resolveElementReference(root, client.getPropertyDefn(ref.propName));
        }
    }

    public void clearClients() {
        this.clients = new ArrayList();
    }

    public void addClient(DesignElement client, CachedMemberRef cachedMemberRef) {
        this.clients.add(new BackRef(client, cachedMemberRef));
    }

    public void dropClient(DesignElement client, CachedMemberRef cachedMemberRef) {
        int i = 0;
        while (i < this.clients.size()) {
            BackRef ref = (BackRef)this.clients.get(i);
            if (ref.element == client && (cachedMemberRef == null || cachedMemberRef.equals(ref.getCachedMemberRef()))) {
                this.clients.remove(i);
                return;
            }
            ++i;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void insertClient(int index, DesignElement client, CachedMemberRef cachedMemberRef) {
        if (!($assertionsDisabled || index > 0 && index <= this.clients.size())) {
            throw new AssertionError();
        }
        this.clients.add(index, new BackRef(client, cachedMemberRef));
    }
}

