/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core.namespace;

import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.NameSpace;
import org.eclipse.birt.report.model.core.namespace.INameContainer;
import org.eclipse.birt.report.model.core.namespace.INameHelper;
import org.eclipse.birt.report.model.metadata.ElementDefn;

public class NameExecutor {
    protected DesignElement focus;
    public static final String NAME_SEPARATOR = "/";

    public NameExecutor(DesignElement element) {
        if (element == null) {
            throw new IllegalArgumentException("The element can not be null");
        }
        this.focus = element;
    }

    public INameHelper getNameHelper(Module module) {
        ElementDefn elementDefn = (ElementDefn)this.focus.getDefn();
        IElementDefn holderDefn = elementDefn.getNameConfig().getNameContainer();
        if (holderDefn == null) {
            return null;
        }
        if (!"Module".equalsIgnoreCase(holderDefn.getName())) {
            DesignElement e = this.focus;
            while (e != null) {
                if (e.getDefn().isKindOf(holderDefn) && e instanceof INameContainer) {
                    return ((INameContainer)((Object)e)).getNameHelper();
                }
                e = e.getContainer();
            }
            return null;
        }
        return module == null ? null : module.getNameHelper();
    }

    public NameSpace getNameSpace(Module module) {
        int id = ((ElementDefn)this.focus.getDefn()).getNameSpaceID();
        INameHelper container = this.getNameHelper(module);
        return container == null ? null : container.getNameSpace(id);
    }
}

