/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements;

import java.util.List;
import org.eclipse.birt.report.model.api.ListingHandle;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.api.validators.DataSetRequiredValidator;
import org.eclipse.birt.report.model.api.validators.GroupNameValidator;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.GroupElement;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.interfaces.IListingElementModel;

public abstract class ListingElement
extends ReportItem
implements IListingElementModel {
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.elements.ListingElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public ListingElement() {
        this.initSlots();
    }

    public ListingElement(String theName) {
        super(theName);
        this.initSlots();
    }

    public List getGroups() {
        return this.slots[1].getContents();
    }

    public ContainerSlot getSlot(int slot) {
        if (!($assertionsDisabled || slot >= 0 && slot < this.getDefn().getSlotCount())) {
            throw new AssertionError();
        }
        return this.slots[slot];
    }

    public String getDisplayLabel(Module module, int level) {
        String displayLabel = super.getDisplayLabel(module, level);
        if (level == 2) {
            String name = this.getStringProperty(module, "dataSet");
            if (!StringUtil.isBlank(name = this.limitStringLength(name))) {
                displayLabel = String.valueOf(displayLabel) + "(" + name + ")";
            }
        }
        return displayLabel;
    }

    public List validate(Module module) {
        List list = super.validate(module);
        list.addAll(this.validateStructureList(module, "sort"));
        list.addAll(this.validateStructureList(module, "filter"));
        if (this.getDataSetElement(module) == null) {
            list.addAll(DataSetRequiredValidator.getInstance().validate(module, this));
        } else {
            list.addAll(GroupNameValidator.getInstance().validate(module, this));
        }
        return list;
    }

    public List checkContent(Module module, ContainerContext containerInfo, DesignElement content) {
        List errors = super.checkContent(module, containerInfo, content);
        if (!errors.isEmpty()) {
            return errors;
        }
        if (content instanceof GroupElement) {
            String checkedName = (String)content.getLocalProperty(module, "groupName");
            if (StringUtil.isBlank(checkedName)) {
                return errors;
            }
            errors.addAll(GroupNameValidator.getInstance().validateForAddingGroup((ListingHandle)this.getHandle(module), checkedName));
        }
        return errors;
    }
}

