/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.data.IColumnBinding;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.elements.GroupElement;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.parser.CompatibleExpressionState;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.util.BoundDataColumnUtil;
import org.xml.sax.SAXException;

class CompatibleMiscExpressionState
extends CompatibleExpressionState {
    CompatibleMiscExpressionState(ModuleParserHandler theHandler, DesignElement element) {
        super(theHandler, element);
    }

    CompatibleMiscExpressionState(ModuleParserHandler theHandler, DesignElement element, PropertyDefn propDefn, IStructure struct) {
        super(theHandler, element, propDefn, struct);
    }

    public void end() throws SAXException {
        String value = this.text.toString();
        if (value == null) {
            return;
        }
        DesignElement target = BoundDataColumnUtil.findTargetOfBoundColumns(this.element, this.handler.module);
        if (target != null) {
            this.setupBoundDataColumns(target, value, this.handler.versionNumber < 3020000);
        }
        this.doEnd(value);
    }

    protected void doEnd(String value) {
        this.doEnd(value, false);
    }

    protected void doEnd(String value, boolean isParamBindingValue) {
        String newValue = value;
        if (StringUtil.trimString(value) != null) {
            newValue = ExpressionUtil.updateParentQueryReferenceExpression((String)value, (boolean)isParamBindingValue);
        }
        super.doEnd(newValue);
    }

    protected void setupBoundDataColumns(DesignElement target, String value, boolean createLocalColumns) {
        if (value == null) {
            return;
        }
        List newExprs = null;
        try {
            newExprs = ExpressionUtil.extractColumnExpressions((String)value);
        }
        catch (BirtException birtException) {}
        if (newExprs == null || newExprs.isEmpty()) {
            return;
        }
        ArrayList<IColumnBinding> outerColumns = new ArrayList<IColumnBinding>();
        ArrayList<IColumnBinding> localColumns = new ArrayList<IColumnBinding>();
        int i = 0;
        while (i < newExprs.size()) {
            IColumnBinding boundColumn = (IColumnBinding)newExprs.get(i);
            if (boundColumn.getOuterLevel() < 1) {
                localColumns.add(boundColumn);
            } else {
                outerColumns.add(boundColumn);
            }
            ++i;
        }
        if (!outerColumns.isEmpty()) {
            DesignElement tmpTarget = BoundDataColumnUtil.findTargetOfBoundColumns(target, this.handler.module, 1);
            this.addBoundColumnsToTarget(tmpTarget, outerColumns);
        }
        if (createLocalColumns) {
            this.addBoundColumnsToTarget(target, localColumns);
        }
    }

    protected void addBoundColumnsToTarget(DesignElement target, List newExprs) {
        if (newExprs.isEmpty()) {
            return;
        }
        if (target instanceof GroupElement) {
            this.appendBoundColumnsToGroup((GroupElement)target, newExprs);
            return;
        }
        int i = 0;
        while (i < newExprs.size()) {
            IColumnBinding boundColumn = (IColumnBinding)newExprs.get(i);
            String newExpression = boundColumn.getBoundExpression();
            if (newExpression != null) {
                BoundDataColumnUtil.createBoundDataColumn(target, boundColumn.getResultSetColumnName(), newExpression, this.handler.module);
            }
            ++i;
        }
    }

    private void appendBoundColumnsToGroup(GroupElement target, List newExprs) {
        ArrayList<ComputedColumn> newColumns = new ArrayList<ComputedColumn>();
        int i = 0;
        while (i < newExprs.size()) {
            ComputedColumn column = StructureFactory.createComputedColumn();
            IColumnBinding boundColumn = (IColumnBinding)newExprs.get(i);
            String newExpression = boundColumn.getBoundExpression();
            if (newExpression != null) {
                column.setName(boundColumn.getResultSetColumnName());
                column.setExpression(boundColumn.getBoundExpression());
                if (!newColumns.contains(column)) {
                    newColumns.add(column);
                }
            }
            ++i;
        }
        this.appendBoundColumnsToCachedGroup(target, newColumns);
    }

    private void appendBoundColumnsToCachedGroup(GroupElement target, List newColumns) {
        List boundColumns = (List)this.handler.tempValue.get(target);
        if (boundColumns == null) {
            this.handler.tempValue.put(target, newColumns);
            return;
        }
        int i = 0;
        while (i < newColumns.size()) {
            ComputedColumn column = (ComputedColumn)newColumns.get(i);
            if (!boundColumns.contains(column)) {
                boundColumns.add(column);
            }
            ++i;
        }
    }

    protected String appendBoundColumnsToCachedGroup(GroupElement target, String boundName, String expression) {
        ComputedColumn column = StructureFactory.createComputedColumn();
        column.setName(boundName);
        column.setExpression(expression);
        List boundColumns = (List)this.handler.tempValue.get(target);
        if (boundColumns == null) {
            ArrayList<ComputedColumn> newColumns = new ArrayList<ComputedColumn>();
            newColumns.add(column);
            this.handler.tempValue.put(target, newColumns);
            return boundName;
        }
        if (!boundColumns.contains(column)) {
            boundColumns.add(column);
        }
        return boundName;
    }
}

