/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.render;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.computation.withaxes.AxisSubUnit;
import org.eclipse.birt.chart.computation.withaxes.SeriesRenderingHints;
import org.eclipse.birt.chart.computation.withaxes.SeriesRenderingHints3D;
import org.eclipse.birt.chart.computation.withaxes.StackGroup;
import org.eclipse.birt.chart.computation.withaxes.StackedSeriesLookup;
import org.eclipse.birt.chart.device.IPrimitiveRenderer;
import org.eclipse.birt.chart.engine.extension.i18n.Messages;
import org.eclipse.birt.chart.event.ArcRenderEvent;
import org.eclipse.birt.chart.event.EventObjectCache;
import org.eclipse.birt.chart.event.InteractionEvent;
import org.eclipse.birt.chart.event.LineRenderEvent;
import org.eclipse.birt.chart.event.OvalRenderEvent;
import org.eclipse.birt.chart.event.Polygon3DRenderEvent;
import org.eclipse.birt.chart.event.PolygonRenderEvent;
import org.eclipse.birt.chart.event.PrimitiveRenderEvent;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.event.Text3DRenderEvent;
import org.eclipse.birt.chart.event.TextRenderEvent;
import org.eclipse.birt.chart.event.WrappedInstruction;
import org.eclipse.birt.chart.event.WrappedStructureSource;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.Location3D;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.RiserType;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.LineAttributesImpl;
import org.eclipse.birt.chart.model.attribute.impl.Location3DImpl;
import org.eclipse.birt.chart.model.attribute.impl.LocationImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.Trigger;
import org.eclipse.birt.chart.model.data.impl.TriggerImpl;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.type.BarSeries;
import org.eclipse.birt.chart.render.AxesRenderer;
import org.eclipse.birt.chart.render.ISeriesRenderingHints;
import org.eclipse.birt.chart.script.ScriptHandler;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.chart.util.FillUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public final class Bar
extends AxesRenderer {
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.engine.extension/render");
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    protected double[] computeStackPosition(AxisSubUnit au, double dValue, Axis ax) {
        if (ax.isPercent()) {
            dValue = au.valuePercentage(dValue);
        }
        double dStart = au.getStackedValue(dValue);
        double dEnd = au.stackValue(dValue);
        return new double[]{dStart, dEnd};
    }

    public final void renderSeries(IPrimitiveRenderer ipr, Plot p, ISeriesRenderingHints isrh) throws ChartException {
        double dUnitSpacing;
        ColorDefinition cd;
        try {
            this.validateDataSetCount(isrh);
        }
        catch (ChartException vex) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, (Throwable)vex);
        }
        boolean bRendering3D = this.isDimension3D();
        SeriesRenderingHints srh = null;
        SeriesRenderingHints3D srh3d = null;
        if (bRendering3D) {
            srh3d = (SeriesRenderingHints3D)isrh;
        } else {
            srh = (SeriesRenderingHints)isrh;
        }
        ChartWithAxes cwa = (ChartWithAxes)this.getModel();
        Bounds boClientArea = isrh.getClientAreaBounds(true);
        ScriptHandler sh = this.getRunTimeContext().getScriptHandler();
        logger.log(1, Messages.getString("info.render.series", new Object[]{((Object)((Object)this)).getClass().getName(), new Integer(this.iSeriesIndex + 1), new Integer(this.iSeriesCount)}, this.getRunTimeContext().getULocale()));
        BarSeries bs = (BarSeries)this.getSeries();
        if (!bs.isSetRiser()) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.undefined.riser", new Object[]{bs}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        if (!bs.isSetVisible()) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.series.visibility", new Object[]{bs}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        if (!bs.isVisible()) {
            return;
        }
        RiserType rt = bs.getRiser();
        double dSeriesThickness = bRendering3D ? 0.0 : srh.getSeriesThickness();
        double dZeroLocation = bRendering3D ? srh3d.getPlotZeroLocation() : srh.getZeroLocation();
        double dBaseLocation = -1.0;
        DataPointHints[] dpha = isrh.getDataPoints();
        this.validateNullDatapoint(dpha);
        double sizeForNonCategory = -1.0;
        if (!bRendering3D && !((SeriesRenderingHints)isrh).isCategoryScale() && dpha.length != 0) {
            sizeForNonCategory = this.computeSizeForNonCategoryBar(cwa.isTransposed(), dpha);
        }
        LineAttributes lia = LineAttributesImpl.create((ColorDefinition)((cd = bs.getRiserOutline()) == null ? null : ColorDefinitionImpl.copyInstance((ColorDefinition)cd)), (LineStyle)LineStyle.SOLID_LITERAL, (int)1);
        double dX = 0.0;
        double dY = 0.0;
        double dZ = 0.0;
        double dWidth = 0.0;
        double dHeight = 0.0;
        double dSpacing = 0.0;
        double dValue = 0.0;
        double dWidthZ = 0.0;
        double dSpacingZ = 0.0;
        Location[] loaFrontFace = null;
        List loa3dFace = null;
        boolean bInverted = false;
        double d = dUnitSpacing = !cwa.isSetUnitSpacing() ? 50.0 : cwa.getUnitSpacing();
        if (cwa.getDimension() == ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL) {
            boClientArea.delta(-dSeriesThickness, dSeriesThickness, 0.0, 0.0);
        }
        AxisSubUnit au = null;
        Axis ax = this.getAxis();
        StackedSeriesLookup ssl = null;
        StackGroup sg = null;
        if (!bRendering3D) {
            ssl = srh.getStackedSeriesLookup();
            sg = ssl.getStackGroup((Series)bs);
        }
        int iSharedUnitIndex = sg == null ? 0 : sg.getSharedIndex();
        int iSharedUnitCount = sg == null ? 1 : sg.getSharedCount();
        Label laDataPoint = null;
        Position pDataPoint = null;
        Location loDataPoint = null;
        Location3D loDataPoint3d = null;
        Bounds boDataPoint = null;
        try {
            Label label = laDataPoint = bRendering3D ? srh3d.getLabelAttributes((Series)bs) : srh.getLabelAttributes((Series)bs);
            if (laDataPoint.isVisible()) {
                pDataPoint = bRendering3D ? srh3d.getLabelPosition((Series)bs) : srh.getLabelPosition((Series)bs);
                loDataPoint = LocationImpl.create((double)0.0, (double)0.0);
                loDataPoint3d = Location3DImpl.create((double)0.0, (double)0.0, (double)0.0);
                boDataPoint = BoundsImpl.create((double)0.0, (double)0.0, (double)0.0, (double)0.0);
            }
        }
        catch (Exception ex) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, (Throwable)ex);
        }
        SeriesDefinition sd = this.getSeriesDefinition();
        EList elPalette = sd.getSeriesPalette().getEntries();
        int iPaletteSize = elPalette.size();
        if (iPaletteSize == 0) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.empty.palette", new Object[]{bs}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        boolean bPaletteByCategory = cwa.getLegend().getItemType().getValue() == 1;
        int iThisSeriesIndex = -1;
        if (!bPaletteByCategory && (iThisSeriesIndex = sd.getRunTimeSeries().indexOf(bs)) < 0) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.missing.series.for.palette.index", new Object[]{bs, sd}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        double[] faX = new double[dpha.length];
        double[] faY = new double[dpha.length];
        int i = 0;
        while (i < dpha.length) {
            block122: {
                block138: {
                    block139: {
                        block140: {
                            block141: {
                                EList elTriggers;
                                Fill fixedFill;
                                block137: {
                                    block128: {
                                        block133: {
                                            block136: {
                                                block135: {
                                                    block134: {
                                                        block129: {
                                                            double plotBaseLocation;
                                                            block132: {
                                                                block131: {
                                                                    block130: {
                                                                        double dEnd;
                                                                        double dStart;
                                                                        block123: {
                                                                            block127: {
                                                                                block126: {
                                                                                    block125: {
                                                                                        block124: {
                                                                                            block121: {
                                                                                                faX[i] = Double.NaN;
                                                                                                faY[i] = Double.NaN;
                                                                                                int iOutside = this.checkEntryByType(this.getInternalBaseAxis().getScale(), dpha[i].getBaseValue());
                                                                                                if (iOutside == 0) break block121;
                                                                                                dpha[i].markOutside();
                                                                                                break block122;
                                                                                            }
                                                                                            laDataPoint = bRendering3D ? srh3d.getLabelAttributes((Series)bs) : srh.getLabelAttributes((Series)bs);
                                                                                            Fill f = null;
                                                                                            if (bPaletteByCategory) {
                                                                                                f = (Fill)EcoreUtil.copy((EObject)((Fill)elPalette.get(i % iPaletteSize)));
                                                                                            } else if (iThisSeriesIndex >= 0) {
                                                                                                f = (Fill)EcoreUtil.copy((EObject)((Fill)elPalette.get(iThisSeriesIndex % iPaletteSize)));
                                                                                            }
                                                                                            this.updateTranslucency(f, (Series)bs);
                                                                                            fixedFill = dpha[i] != null && dpha[i].getOrthogonalValue() instanceof Double ? ChartUtil.convertFill((Fill)f, (double)((Double)dpha[i].getOrthogonalValue()), null) : (Fill)EcoreUtil.copy((EObject)f);
                                                                                            if (bRendering3D) {
                                                                                                Location3D lo3d = dpha[i].getLocation3D();
                                                                                                dX = lo3d.getX();
                                                                                                dY = lo3d.getY();
                                                                                                dZ = lo3d.getZ();
                                                                                                dSpacing = dpha[i].getSize2D().getWidth() * dUnitSpacing / 200.0;
                                                                                                dSpacingZ = dpha[i].getSize2D().getHeight() * dUnitSpacing / 200.0;
                                                                                            } else {
                                                                                                Location lo = dpha[i].getLocation();
                                                                                                dX = lo.getX();
                                                                                                dY = lo.getY();
                                                                                                dSpacing = dpha[i].getSize() * dUnitSpacing / 200.0;
                                                                                            }
                                                                                            if (!cwa.isTransposed()) break block123;
                                                                                            if (((SeriesRenderingHints)isrh).isCategoryScale()) {
                                                                                                dHeight = dpha[i].getSize();
                                                                                                dHeight -= 2.0 * dSpacing;
                                                                                                dY += (double)iSharedUnitIndex * (dHeight /= (double)iSharedUnitCount) + dSpacing;
                                                                                            } else {
                                                                                                dHeight = Math.min(sizeForNonCategory, (dpha[i].getSize() - 2.0 * dSpacing) * 0.8);
                                                                                                dSpacing = (dpha[i].getSize() - dHeight) / 2.0;
                                                                                                dY -= dpha[i].getSize() / 2.0 - (double)iSharedUnitIndex * (dHeight /= (double)iSharedUnitCount) - dSpacing;
                                                                                            }
                                                                                            if (this.isStackedOrPercent(bs, ax)) {
                                                                                                au = ssl.getUnit((Series)bs, i);
                                                                                                dValue = Bar.isNaN((Object)dpha[i].getOrthogonalValue()) ? 0.0 : (Double)dpha[i].getOrthogonalValue();
                                                                                                double[] values = this.computeStackPosition(au, dValue, ax);
                                                                                                dStart = values[0];
                                                                                                dEnd = values[1];
                                                                                                try {
                                                                                                    double dMargin = Math.floor(srh.getLocationOnOrthogonal((Object)new Double(dEnd)) - srh.getLocationOnOrthogonal((Object)new Double(dStart)));
                                                                                                    double lastPosition = au.getLastPosition(dValue);
                                                                                                    dBaseLocation = Double.isNaN(lastPosition) ? Math.floor(srh.getLocationOnOrthogonal((Object)new Double(dStart))) : au.getLastPosition(dValue);
                                                                                                    au.setLastPosition(dValue, dBaseLocation, dMargin);
                                                                                                    dX = au.getLastPosition(dValue);
                                                                                                }
                                                                                                catch (Exception ex) {
                                                                                                    throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, (Throwable)ex);
                                                                                                }
                                                                                            } else {
                                                                                                dBaseLocation = dZeroLocation;
                                                                                            }
                                                                                            if (!ChartUtil.mathLT((double)dX, (double)boClientArea.getLeft())) break block124;
                                                                                            if (ChartUtil.mathLT((double)dBaseLocation, (double)boClientArea.getLeft())) break block122;
                                                                                            dX = boClientArea.getLeft();
                                                                                            break block125;
                                                                                        }
                                                                                        if (ChartUtil.mathLT((double)dBaseLocation, (double)boClientArea.getLeft())) {
                                                                                            dBaseLocation = boClientArea.getLeft();
                                                                                        }
                                                                                    }
                                                                                    if (!ChartUtil.mathGT((double)dX, (double)(boClientArea.getLeft() + boClientArea.getWidth()))) break block126;
                                                                                    if (ChartUtil.mathGT((double)dBaseLocation, (double)(boClientArea.getLeft() + boClientArea.getWidth()))) break block122;
                                                                                    dX = boClientArea.getLeft() + boClientArea.getWidth();
                                                                                    break block127;
                                                                                }
                                                                                if (ChartUtil.mathGT((double)dBaseLocation, (double)(boClientArea.getLeft() + boClientArea.getWidth()))) {
                                                                                    dBaseLocation = boClientArea.getLeft() + boClientArea.getWidth();
                                                                                }
                                                                            }
                                                                            dWidth = dBaseLocation - dX;
                                                                            boolean bl = bInverted = dWidth <= 0.0;
                                                                            if (bInverted) {
                                                                                dX = dBaseLocation;
                                                                                dWidth = -dWidth;
                                                                            }
                                                                            break block128;
                                                                        }
                                                                        if (bRendering3D) {
                                                                            dWidth = dpha[i].getSize2D().getWidth();
                                                                            dWidth -= 2.0 * dSpacing;
                                                                            dWidthZ = dpha[i].getSize2D().getHeight();
                                                                            dWidthZ -= 2.0 * dSpacingZ;
                                                                            dX += dSpacing;
                                                                            dZ += dSpacingZ;
                                                                        } else if (((SeriesRenderingHints)isrh).isCategoryScale()) {
                                                                            dWidth = dpha[i].getSize();
                                                                            dWidth -= 2.0 * dSpacing;
                                                                            dX += (double)iSharedUnitIndex * (dWidth /= (double)iSharedUnitCount) + dSpacing;
                                                                        } else {
                                                                            dWidth = Math.min(sizeForNonCategory, (dpha[i].getSize() - 2.0 * dSpacing) * 0.8);
                                                                            dSpacing = (dpha[i].getSize() - dWidth) / 2.0;
                                                                            dX -= dpha[i].getSize() / 2.0 - (double)iSharedUnitIndex * (dWidth /= (double)iSharedUnitCount) - dSpacing;
                                                                        }
                                                                        if (this.isStackedOrPercent(bs, ax)) {
                                                                            if (bRendering3D) {
                                                                                throw new ChartException("org.eclipse.birt.chart.engine.extension", 15, "exception.no.stack.percent.3D.chart", Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
                                                                            }
                                                                            au = ssl.getUnit((Series)bs, i);
                                                                            dValue = Bar.isNaN((Object)dpha[i].getOrthogonalValue()) ? 0.0 : (Double)dpha[i].getOrthogonalValue();
                                                                            double[] values = this.computeStackPosition(au, dValue, ax);
                                                                            dStart = values[0];
                                                                            dEnd = values[1];
                                                                            try {
                                                                                double dMargin = Math.floor(srh.getLocationOnOrthogonal((Object)new Double(dEnd)) - srh.getLocationOnOrthogonal((Object)new Double(dStart)));
                                                                                double lastPosition = au.getLastPosition(dValue);
                                                                                dBaseLocation = Double.isNaN(lastPosition) ? Math.floor(srh.getLocationOnOrthogonal((Object)new Double(dStart))) : au.getLastPosition(dValue);
                                                                                au.setLastPosition(dValue, dBaseLocation, dMargin);
                                                                                dY = au.getLastPosition(dValue);
                                                                            }
                                                                            catch (Exception ex) {
                                                                                throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, (Throwable)ex);
                                                                            }
                                                                        } else {
                                                                            dBaseLocation = dZeroLocation;
                                                                        }
                                                                        if (!bRendering3D) break block129;
                                                                        plotBaseLocation = srh3d.getPlotBaseLocation();
                                                                        if (!(dY < plotBaseLocation)) break block130;
                                                                        if (dBaseLocation < plotBaseLocation) break block122;
                                                                        dY = plotBaseLocation;
                                                                        break block131;
                                                                    }
                                                                    if (dBaseLocation < plotBaseLocation) {
                                                                        dBaseLocation = plotBaseLocation;
                                                                    }
                                                                }
                                                                if (!(dY > plotBaseLocation + srh3d.getPlotHeight())) break block132;
                                                                if (dBaseLocation > plotBaseLocation + srh3d.getPlotHeight()) break block122;
                                                                dY = plotBaseLocation + srh3d.getPlotHeight();
                                                                break block133;
                                                            }
                                                            if (dBaseLocation > plotBaseLocation + srh3d.getPlotHeight()) {
                                                                dBaseLocation = plotBaseLocation + srh3d.getPlotHeight();
                                                            }
                                                            break block133;
                                                        }
                                                        if (!(dY < boClientArea.getTop())) break block134;
                                                        if (dBaseLocation < boClientArea.getTop()) break block122;
                                                        dY = boClientArea.getTop();
                                                        break block135;
                                                    }
                                                    if (dBaseLocation < boClientArea.getTop()) {
                                                        dBaseLocation = boClientArea.getTop();
                                                    }
                                                }
                                                if (!(dY > boClientArea.getTop() + boClientArea.getHeight())) break block136;
                                                if (dBaseLocation > boClientArea.getTop() + boClientArea.getHeight()) break block122;
                                                dY = boClientArea.getTop() + boClientArea.getHeight();
                                                break block133;
                                            }
                                            if (dBaseLocation > boClientArea.getTop() + boClientArea.getHeight()) {
                                                dBaseLocation = boClientArea.getTop() + boClientArea.getHeight();
                                            }
                                        }
                                        dHeight = dBaseLocation - dY;
                                        boolean bl = bRendering3D ? dHeight <= 0.0 : (bInverted = dHeight < 0.0);
                                        if (bInverted) {
                                            dY = dBaseLocation;
                                            dHeight = -dHeight;
                                        }
                                    }
                                    if (rt.getValue() == 0) {
                                        if (bRendering3D) {
                                            loa3dFace = this.computeRiserRectangle3D(bInverted, dX, dY, dZ, dHeight, dWidth, dWidthZ);
                                        } else {
                                            loaFrontFace = this.computeRiserRectangle2D(bInverted, i, faX, faY, dX, dY, dHeight, dWidth);
                                        }
                                    } else if (rt.getValue() == 1) {
                                        if (bRendering3D) {
                                            loa3dFace = this.computeRiserTriangle3D(bInverted, dX, dY, dZ, dHeight, dWidth, dWidthZ);
                                        } else if (this.isStackedOrPercent(bs, ax)) {
                                            StackedSizeHints slh = this.getCurrentStackedSizeHints(i);
                                            double[] size = null;
                                            size = this.isTransposed() ? Bar.computeStacked2DTopNBottomSize(slh, au, dValue, dHeight) : Bar.computeStacked2DTopNBottomSize(slh, au, dValue, dWidth);
                                            loaFrontFace = this.computeStackedRiserTriangle2D(bInverted, i, faX, faY, dX, dY, dHeight, dWidth, size[0], size[1], this.getCurrentStackedSizeHints(i));
                                        } else {
                                            loaFrontFace = this.computeRiserTriangle2D(bInverted, i, faX, faY, dX, dY, dHeight, dWidth);
                                        }
                                    } else if (rt.getValue() == 2) {
                                        if (bRendering3D) {
                                            loa3dFace = this.computeRiserTube3D(bInverted, dX, dY, dZ, dHeight, dWidth, dWidthZ);
                                        } else {
                                            loaFrontFace = this.computeRiserTube2D(bInverted, i, faX, faY, dX, dY, dHeight, dWidth);
                                        }
                                    } else if (rt.getValue() == 3) {
                                        if (bRendering3D) {
                                            loa3dFace = this.computeRiserCone3D(bInverted, dX, dY, dZ, dHeight, dWidth, dWidthZ);
                                        } else if (this.isStackedOrPercent(bs, ax)) {
                                            StackedSizeHints slh = this.getCurrentStackedSizeHints(i);
                                            double[] size = null;
                                            size = this.isTransposed() ? Bar.computeStacked2DTopNBottomSize(slh, au, dValue, dHeight) : Bar.computeStacked2DTopNBottomSize(slh, au, dValue, dWidth);
                                            loaFrontFace = this.computeStackedRiserCone2D(bInverted, i, faX, faY, dX, dY, dHeight, dWidth, size[0], size[1]);
                                        } else {
                                            loaFrontFace = this.computeRiserCone2D(bInverted, i, faX, faY, dX, dY, dHeight, dWidth);
                                        }
                                    } else {
                                        throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.unspecified.riser.type", new Object[]{rt.getName()}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
                                    }
                                    if (!Bar.isNaN((Object)dpha[i].getOrthogonalValue())) break block137;
                                    faX[i] = Double.NaN;
                                    faY[i] = Double.NaN;
                                    break block122;
                                }
                                if (!bRendering3D) {
                                    int j = 0;
                                    while (j < loaFrontFace.length) {
                                        Location location = loaFrontFace[j];
                                        if (location.getX() < boClientArea.getLeft()) {
                                            location.setX(boClientArea.getLeft());
                                        } else if (location.getX() > boClientArea.getLeft() + boClientArea.getWidth()) {
                                            location.setX(boClientArea.getLeft() + boClientArea.getWidth());
                                        }
                                        if (location.getY() < boClientArea.getTop()) {
                                            location.setY(boClientArea.getTop());
                                        } else if (location.getY() > boClientArea.getTop() + boClientArea.getHeight()) {
                                            location.setY(boClientArea.getTop() + boClientArea.getHeight());
                                        }
                                        ++j;
                                    }
                                }
                                if (this.isInteractivityEnabled() && !(elTriggers = bs.getTriggers()).isEmpty()) {
                                    StructureSource iSource = WrappedStructureSource.createSeriesDataPoint((Series)bs, (DataPointHints)dpha[i]);
                                    if (bRendering3D) {
                                        int j = 0;
                                        while (j < loa3dFace.size()) {
                                            Location3D[] points = (Location3D[])loa3dFace.get(j);
                                            if (points.length > 2) {
                                                InteractionEvent iev = this.createEvent(iSource, (List)elTriggers, ipr);
                                                EventObjectCache eventObjectCache = (EventObjectCache)ipr;
                                                StructureSource structureSource = StructureSource.createSeries((Series)bs);
                                                Class<?> clazz = class$0;
                                                if (clazz == null) {
                                                    try {
                                                        clazz = Class.forName("org.eclipse.birt.chart.event.Polygon3DRenderEvent");
                                                    }
                                                    catch (ClassNotFoundException classNotFoundException) {
                                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                    }
                                                }
                                                Polygon3DRenderEvent pre3d = (Polygon3DRenderEvent)eventObjectCache.getEventObject((Object)structureSource, (Class)clazz);
                                                pre3d.setPoints3D(points);
                                                Location panningOffset = this.getPanningOffset();
                                                if (this.get3DEngine().processEvent((PrimitiveRenderEvent)pre3d, panningOffset.getX(), panningOffset.getY()) != null) {
                                                    iev.setHotSpot((PrimitiveRenderEvent)pre3d);
                                                    ipr.enableInteraction(iev);
                                                }
                                            }
                                            ++j;
                                        }
                                    } else {
                                        InteractionEvent iev = this.createEvent(iSource, (List)elTriggers, ipr);
                                        EventObjectCache eventObjectCache = (EventObjectCache)ipr;
                                        StructureSource structureSource = StructureSource.createSeries((Series)bs);
                                        Class<?> clazz = class$1;
                                        if (clazz == null) {
                                            try {
                                                clazz = Class.forName("org.eclipse.birt.chart.event.PolygonRenderEvent");
                                            }
                                            catch (ClassNotFoundException classNotFoundException) {
                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                            }
                                        }
                                        PolygonRenderEvent pre = (PolygonRenderEvent)eventObjectCache.getEventObject((Object)structureSource, (Class)clazz);
                                        pre.setPoints(loaFrontFace);
                                        iev.setHotSpot((PrimitiveRenderEvent)pre);
                                        ipr.enableInteraction(iev);
                                    }
                                }
                                ScriptHandler.callFunction((ScriptHandler)sh, (String)"beforeDrawElement", (Object)dpha[i], (Object)fixedFill);
                                ScriptHandler.callFunction((ScriptHandler)sh, (String)"beforeDrawDataPoint", (Object)dpha[i], (Object)fixedFill, (Object)this.getRunTimeContext().getScriptContext());
                                this.getRunTimeContext().notifyStructureChange("beforeDrawElement", (Object)dpha[i]);
                                this.getRunTimeContext().notifyStructureChange("beforeDrawDataPoint", (Object)dpha[i]);
                                if (dHeight != 0.0) {
                                    if (bRendering3D) {
                                        if (rt.getValue() == 2) {
                                            this.renderRiserTube3D(ipr, WrappedStructureSource.createSeriesDataPoint((Series)bs, (DataPointHints)dpha[i]), loa3dFace, fixedFill, lia, dpha[i]);
                                        } else if (rt.getValue() == 3) {
                                            this.renderRiserCone3D(ipr, WrappedStructureSource.createSeriesDataPoint((Series)bs, (DataPointHints)dpha[i]), loa3dFace, fixedFill, lia, dpha[i]);
                                        } else {
                                            this.render3DPlane(ipr, WrappedStructureSource.createSeriesDataPoint((Series)bs, (DataPointHints)dpha[i]), loa3dFace, fixedFill, lia);
                                        }
                                    } else if (rt.getValue() == 2) {
                                        this.renderRiserTube2D(ipr, WrappedStructureSource.createSeriesDataPoint((Series)bs, (DataPointHints)dpha[i]), dpha[i], loaFrontFace, fixedFill, lia, cwa.getDimension(), cwa.getDimension() == ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL ? dSeriesThickness / 2.0 : dSeriesThickness / 4.0, cwa.getDimension() == ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL, this.isTransposed(), true, bInverted, this.isStackedOrPercent(bs, ax));
                                    } else if (rt.getValue() == 3) {
                                        boolean isStacked = this.isStackedOrPercent(bs, ax);
                                        double coneThickness = cwa.getDimension() == ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL ? dSeriesThickness / 2.0 : dSeriesThickness / 4.0;
                                        double coneBottomHeight = this.computeBottomOvalHeightOfCone(i, coneThickness, loaFrontFace, dValue, isStacked);
                                        this.renderRiserCone2D(ipr, WrappedStructureSource.createSeriesDataPoint((Series)bs, (DataPointHints)dpha[i]), dpha[i], loaFrontFace, fixedFill, lia, cwa.getDimension(), coneThickness, cwa.getDimension() == ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL, this.isTransposed(), true, bInverted, this.isStackedOrPercent(bs, ax), coneBottomHeight);
                                    } else if (rt.getValue() == 1) {
                                        this.renderRiserTriangle2D(ipr, WrappedStructureSource.createSeriesDataPoint((Series)bs, (DataPointHints)dpha[i]), loaFrontFace, fixedFill, lia, cwa.getDimension(), dSeriesThickness, true, bInverted, this.isStackedOrPercent(bs, ax), this.getCurrentStackedSizeHints(i));
                                    } else {
                                        this.renderPlane(ipr, WrappedStructureSource.createSeriesDataPoint((Series)bs, (DataPointHints)dpha[i]), loaFrontFace, fixedFill, lia, cwa.getDimension(), dSeriesThickness, true);
                                    }
                                }
                                ScriptHandler.callFunction((ScriptHandler)sh, (String)"afterDrawElement", (Object)dpha[i], (Object)fixedFill);
                                ScriptHandler.callFunction((ScriptHandler)sh, (String)"afterDrawDataPoint", (Object)dpha[i], (Object)fixedFill, (Object)this.getRunTimeContext().getScriptContext());
                                this.getRunTimeContext().notifyStructureChange("afterDrawElement", (Object)dpha[i]);
                                this.getRunTimeContext().notifyStructureChange("afterDrawDataPoint", (Object)dpha[i]);
                                if (!laDataPoint.isVisible()) break block122;
                                laDataPoint.getCaption().setValue(dpha[i].getDisplayValue());
                                ScriptHandler.callFunction((ScriptHandler)sh, (String)"beforeDrawDataPointLabel", (Object)dpha[i], (Object)laDataPoint, (Object)this.getRunTimeContext().getScriptContext());
                                this.getRunTimeContext().notifyStructureChange("beforeDrawDataPointLabel", (Object)laDataPoint);
                                if (dpha[i].isOutside()) break block138;
                                if (cwa.isTransposed()) break block139;
                                if (!bRendering3D) break block140;
                                if (pDataPoint.getValue() != 5) break block141;
                                if (!bInverted) {
                                    loDataPoint3d.set(dX + dWidth / 2.0, dY - (double)p.getVerticalSpacing(), dZ + dWidthZ / 2.0);
                                    EventObjectCache eventObjectCache = (EventObjectCache)ipr;
                                    StructureSource structureSource = WrappedStructureSource.createSeriesDataPoint((Series)bs, (DataPointHints)dpha[i]);
                                    Class<?> clazz = class$2;
                                    if (clazz == null) {
                                        try {
                                            clazz = Class.forName("org.eclipse.birt.chart.event.Text3DRenderEvent");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    Text3DRenderEvent tre = (Text3DRenderEvent)eventObjectCache.getEventObject((Object)structureSource, (Class)clazz);
                                    tre.setLabel(laDataPoint);
                                    tre.setTextPosition(4);
                                    tre.setAction(2);
                                    Location3D[] loa3d = new Location3D[]{loDataPoint3d, Location3DImpl.create((double)dX, (double)(dY - (double)p.getVerticalSpacing()), (double)(dZ + dWidthZ / 2.0)), Location3DImpl.create((double)dX, (double)(dY - (double)p.getVerticalSpacing() - 16.0), (double)(dZ + dWidthZ / 2.0)), Location3DImpl.create((double)(dX + dWidth), (double)(dY - (double)p.getVerticalSpacing() - 16.0), (double)(dZ + dWidthZ / 2.0)), Location3DImpl.create((double)(dX + dWidth), (double)(dY - (double)p.getVerticalSpacing()), (double)(dZ + dWidthZ / 2.0))};
                                    tre.setBlockBounds3D(loa3d);
                                    this.getDeferredCache().addLabel((TextRenderEvent)tre);
                                } else {
                                    loDataPoint3d.set(dX + dWidth / 2.0, dY + dHeight + (double)p.getVerticalSpacing(), dZ + dWidthZ / 2.0);
                                    EventObjectCache eventObjectCache = (EventObjectCache)ipr;
                                    StructureSource structureSource = WrappedStructureSource.createSeriesDataPoint((Series)bs, (DataPointHints)dpha[i]);
                                    Class<?> clazz = class$2;
                                    if (clazz == null) {
                                        try {
                                            clazz = Class.forName("org.eclipse.birt.chart.event.Text3DRenderEvent");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    Text3DRenderEvent tre = (Text3DRenderEvent)eventObjectCache.getEventObject((Object)structureSource, (Class)clazz);
                                    tre.setAction(2);
                                    tre.setLabel(laDataPoint);
                                    tre.setTextPosition(3);
                                    Location3D[] loa3d = new Location3D[]{loDataPoint3d, Location3DImpl.create((double)(dX + dWidth), (double)(dY + dHeight + (double)p.getVerticalSpacing()), (double)(dZ + dWidthZ / 2.0)), Location3DImpl.create((double)(dX + dWidth), (double)(dY + dHeight + 16.0 + (double)p.getVerticalSpacing()), (double)(dZ + dWidthZ / 2.0)), Location3DImpl.create((double)dX, (double)(dY + dHeight + 16.0 + (double)p.getVerticalSpacing()), (double)(dZ + dWidthZ / 2.0)), Location3DImpl.create((double)dX, (double)(dY + dHeight + (double)p.getVerticalSpacing()), (double)(dZ + dWidthZ / 2.0))};
                                    tre.setBlockBounds3D(loa3d);
                                    this.getDeferredCache().addLabel((TextRenderEvent)tre);
                                }
                                break block138;
                            }
                            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.illegal.datapoint.position.bar3d", new Object[]{pDataPoint.getName()}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
                        }
                        switch (pDataPoint.getValue()) {
                            case 5: {
                                if (!bInverted) {
                                    loDataPoint.set(dX + dWidth / 2.0, dY - (double)p.getVerticalSpacing());
                                    this.renderLabel(WrappedStructureSource.createSeriesDataPoint((Series)bs, (DataPointHints)dpha[i]), 2, laDataPoint, Position.ABOVE_LITERAL, loDataPoint, null);
                                } else {
                                    loDataPoint.set(dX + dWidth / 2.0, dY + dHeight + (double)p.getVerticalSpacing());
                                    this.renderLabel(WrappedStructureSource.createSeriesDataPoint((Series)bs, (DataPointHints)dpha[i]), 2, laDataPoint, Position.BELOW_LITERAL, loDataPoint, null);
                                }
                                break block138;
                            }
                            case 4: {
                                boDataPoint.updateFrom(loaFrontFace);
                                this.renderLabel(WrappedStructureSource.createSeriesDataPoint((Series)bs, (DataPointHints)dpha[i]), 3, laDataPoint, null, null, boDataPoint);
                                break block138;
                            }
                            default: {
                                throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.illegal.datapoint.position.bar", new Object[]{pDataPoint.getName()}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
                            }
                        }
                    }
                    switch (pDataPoint.getValue()) {
                        case 5: {
                            if (!bInverted) {
                                loDataPoint.set(dX - (double)p.getHorizontalSpacing(), dY + dHeight / 2.0);
                                this.renderLabel(WrappedStructureSource.createSeriesDataPoint((Series)bs, (DataPointHints)dpha[i]), 2, laDataPoint, Position.LEFT_LITERAL, loDataPoint, null);
                                break;
                            }
                            loDataPoint.set(dX + dWidth + (double)p.getHorizontalSpacing(), dY + dHeight / 2.0);
                            this.renderLabel(WrappedStructureSource.createSeriesDataPoint((Series)bs, (DataPointHints)dpha[i]), 2, laDataPoint, Position.RIGHT_LITERAL, loDataPoint, null);
                            break;
                        }
                        case 4: {
                            boDataPoint.updateFrom(loaFrontFace);
                            this.renderLabel(WrappedStructureSource.createSeriesDataPoint((Series)bs, (DataPointHints)dpha[i]), 3, laDataPoint, null, null, boDataPoint);
                            break;
                        }
                        default: {
                            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.illegal.datapoint.position.bar", new Object[]{pDataPoint.getName()}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
                        }
                    }
                }
                ScriptHandler.callFunction((ScriptHandler)sh, (String)"afterDrawDataPointLabel", (Object)dpha[i], (Object)laDataPoint, (Object)this.getRunTimeContext().getScriptContext());
                this.getRunTimeContext().notifyStructureChange("afterDrawDataPointLabel", (Object)laDataPoint);
            }
            ++i;
        }
        if (!bRendering3D) {
            List<Object> points = new ArrayList<double[]>();
            int i2 = 0;
            while (i2 < faX.length) {
                points.add(new double[]{faX[i2], faY[i2]});
                ++i2;
            }
            points = this.filterNull(points);
            if (this.isLastRuntimeSeriesInAxis()) {
                this.getRunTimeContext().putState((Object)"stacked_series_location_key", null);
            } else {
                this.getRunTimeContext().putState((Object)"stacked_series_location_key", points);
            }
            if (this.getSeries().getCurveFitting() != null) {
                Location[] larray = this.createLocationArray(points);
                this.renderFittingCurve(ipr, larray, this.getSeries().getCurveFitting(), cwa.getDimension() == ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL, true);
            }
        }
        this.resetAllStackedSizeHints();
    }

    private double computeSizeForNonCategoryBar(boolean isTransposed, DataPointHints[] dpha) {
        double sizeForNonCategory = dpha[0].getSize();
        int i = 0;
        while (i < dpha.length - 1) {
            int j = i + 1;
            while (j < dpha.length) {
                double space = 0.0;
                space = isTransposed ? dpha[j].getLocation().getY() - dpha[i].getLocation().getY() : dpha[j].getLocation().getX() - dpha[i].getLocation().getX();
                if (sizeForNonCategory > (space = Math.abs(space))) {
                    sizeForNonCategory = space;
                }
                ++j;
            }
            ++i;
        }
        sizeForNonCategory = Math.max(sizeForNonCategory * 0.8, dpha[0].getSize() * 0.3);
        return sizeForNonCategory;
    }

    private StackedSizeHints getCurrentStackedSizeHints(int i) {
        Object obj = this.getRunTimeContext().getState((Object)"stacked_series_size_key");
        if (obj == null) {
            this.getRunTimeContext().putState((Object)"stacked_series_size_key", new ArrayList());
            obj = this.getRunTimeContext().getState((Object)"stacked_series_size_key");
        }
        List stackedSizes = (List)obj;
        while (stackedSizes.size() - 1 <= i) {
            stackedSizes.add(new StackedSizeHints());
        }
        StackedSizeHints slh = (StackedSizeHints)stackedSizes.get(i);
        return slh;
    }

    private void resetAllStackedSizeHints() {
        if (this.isLastRuntimeSeriesInAxis()) {
            this.getRunTimeContext().putState((Object)"stacked_series_size_key", null);
        }
    }

    private static double[] computeStacked2DTopNBottomSize(StackedSizeHints stackedSizeHints, AxisSubUnit au, double dValue, double size) {
        double stackedSizePercent = Bar.computeStacked2DTopSizePercent(stackedSizeHints, au, dValue);
        double topSize = 0.0;
        double bottomSize = 0.0;
        if (dValue >= 0.0) {
            if (Double.isNaN(stackedSizeHints.getLastPositiveBottom()) && !Double.isNaN(size)) {
                stackedSizeHints.setLastPositiveBottom(size);
            }
            bottomSize = stackedSizeHints.getLastPositiveBottom();
            stackedSizeHints.setLastPositiveBottom(bottomSize * stackedSizePercent);
        } else {
            if (Double.isNaN(stackedSizeHints.getLastNegativeBottom()) && !Double.isNaN(size)) {
                stackedSizeHints.setLastNegativeBottom(size);
            }
            bottomSize = stackedSizeHints.getLastNegativeBottom();
            stackedSizeHints.setLastNegativeBottom(bottomSize * stackedSizePercent);
        }
        topSize = bottomSize * stackedSizePercent;
        return new double[]{topSize, bottomSize};
    }

    private boolean isStackedOrPercent(BarSeries bs, Axis ax) {
        return bs.isStacked() || ax.isPercent();
    }

    private static double computeStacked2DTopSizePercent(StackedSizeHints stackedSizeHints, AxisSubUnit au, double dValue) {
        double dCurrentTotal = 0.0;
        if (dValue >= 0.0) {
            dCurrentTotal = Double.isNaN(stackedSizeHints.getRemainedPositiveTotal()) ? au.getPositiveTotal() : stackedSizeHints.getRemainedPositiveTotal();
            stackedSizeHints.setRemainedPositiveTotal(dCurrentTotal - dValue);
        } else {
            dCurrentTotal = Double.isNaN(stackedSizeHints.getRemainedNegativeTotal()) ? au.getNegativeTotal() : stackedSizeHints.getRemainedNegativeTotal();
            stackedSizeHints.setRemainedNegativeTotal(dCurrentTotal - dValue);
        }
        double dTopSizePercent = (dCurrentTotal - dValue) / dCurrentTotal;
        return dTopSizePercent;
    }

    private Location[] computeRiserRectangle2D(boolean bInverted, int i, double[] faX, double[] faY, double dX, double dY, double dHeight, double dWidth) {
        Location[] loaFrontFace = new Location[]{LocationImpl.create((double)dX, (double)dY), LocationImpl.create((double)dX, (double)(dY + dHeight)), LocationImpl.create((double)(dX + dWidth), (double)(dY + dHeight)), LocationImpl.create((double)(dX + dWidth), (double)dY)};
        if (this.isTransposed()) {
            faX[i] = bInverted ? dX + dWidth : dX;
            faY[i] = dY + dHeight / 2.0;
        } else {
            faX[i] = dX + dWidth / 2.0;
            faY[i] = bInverted ? dY + dHeight : dY;
        }
        return loaFrontFace;
    }

    private List computeRiserRectangle3D(boolean bInverted, double dX, double dY, double dZ, double dHeight, double dWidth, double dWidthZ) {
        ArrayList<Location3D[]> loa3dFace = new ArrayList<Location3D[]>();
        if (!bInverted) {
            Location3D[] a3dFace = new Location3D[]{Location3DImpl.create((double)dX, (double)(dY + dHeight), (double)dZ), Location3DImpl.create((double)(dX + dWidth), (double)(dY + dHeight), (double)dZ), Location3DImpl.create((double)(dX + dWidth), (double)dY, (double)dZ), Location3DImpl.create((double)dX, (double)dY, (double)dZ)};
            loa3dFace.add(a3dFace);
            a3dFace = new Location3D[]{Location3DImpl.create((double)dX, (double)(dY + dHeight), (double)dZ), Location3DImpl.create((double)dX, (double)dY, (double)dZ), Location3DImpl.create((double)dX, (double)dY, (double)(dZ + dWidthZ)), Location3DImpl.create((double)dX, (double)(dY + dHeight), (double)(dZ + dWidthZ))};
            loa3dFace.add(a3dFace);
            a3dFace = new Location3D[]{Location3DImpl.create((double)dX, (double)dY, (double)dZ), Location3DImpl.create((double)(dX + dWidth), (double)dY, (double)dZ), Location3DImpl.create((double)(dX + dWidth), (double)dY, (double)(dZ + dWidthZ)), Location3DImpl.create((double)dX, (double)dY, (double)(dZ + dWidthZ))};
            loa3dFace.add(a3dFace);
            a3dFace = new Location3D[]{Location3DImpl.create((double)dX, (double)(dY + dHeight), (double)dZ), Location3DImpl.create((double)dX, (double)(dY + dHeight), (double)(dZ + dWidthZ)), Location3DImpl.create((double)(dX + dWidth), (double)(dY + dHeight), (double)(dZ + dWidthZ)), Location3DImpl.create((double)(dX + dWidth), (double)(dY + dHeight), (double)dZ)};
            loa3dFace.add(a3dFace);
            a3dFace = new Location3D[]{Location3DImpl.create((double)(dX + dWidth), (double)(dY + dHeight), (double)(dZ + dWidthZ)), Location3DImpl.create((double)(dX + dWidth), (double)dY, (double)(dZ + dWidthZ)), Location3DImpl.create((double)(dX + dWidth), (double)dY, (double)dZ), Location3DImpl.create((double)(dX + dWidth), (double)(dY + dHeight), (double)dZ)};
            loa3dFace.add(a3dFace);
            a3dFace = new Location3D[]{Location3DImpl.create((double)dX, (double)(dY + dHeight), (double)(dZ + dWidthZ)), Location3DImpl.create((double)dX, (double)dY, (double)(dZ + dWidthZ)), Location3DImpl.create((double)(dX + dWidth), (double)dY, (double)(dZ + dWidthZ)), Location3DImpl.create((double)(dX + dWidth), (double)(dY + dHeight), (double)(dZ + dWidthZ))};
            loa3dFace.add(a3dFace);
        } else {
            Location3D[] a3dFace = new Location3D[]{Location3DImpl.create((double)dX, (double)dY, (double)dZ), Location3DImpl.create((double)dX, (double)(dY + dHeight), (double)dZ), Location3DImpl.create((double)(dX + dWidth), (double)(dY + dHeight), (double)dZ), Location3DImpl.create((double)(dX + dWidth), (double)dY, (double)dZ)};
            loa3dFace.add(a3dFace);
            a3dFace = new Location3D[]{Location3DImpl.create((double)dX, (double)dY, (double)dZ), Location3DImpl.create((double)dX, (double)dY, (double)(dZ + dWidthZ)), Location3DImpl.create((double)dX, (double)(dY + dHeight), (double)(dZ + dWidthZ)), Location3DImpl.create((double)dX, (double)(dY + dHeight), (double)dZ)};
            loa3dFace.add(a3dFace);
            a3dFace = new Location3D[]{Location3DImpl.create((double)dX, (double)dY, (double)dZ), Location3DImpl.create((double)(dX + dWidth), (double)dY, (double)dZ), Location3DImpl.create((double)(dX + dWidth), (double)dY, (double)(dZ + dWidthZ)), Location3DImpl.create((double)dX, (double)dY, (double)(dZ + dWidthZ))};
            loa3dFace.add(a3dFace);
            a3dFace = new Location3D[]{Location3DImpl.create((double)dX, (double)(dY + dHeight), (double)dZ), Location3DImpl.create((double)dX, (double)(dY + dHeight), (double)(dZ + dWidthZ)), Location3DImpl.create((double)(dX + dWidth), (double)(dY + dHeight), (double)(dZ + dWidthZ)), Location3DImpl.create((double)(dX + dWidth), (double)(dY + dHeight), (double)dZ)};
            loa3dFace.add(a3dFace);
            a3dFace = new Location3D[]{Location3DImpl.create((double)(dX + dWidth), (double)dY, (double)(dZ + dWidthZ)), Location3DImpl.create((double)(dX + dWidth), (double)dY, (double)dZ), Location3DImpl.create((double)(dX + dWidth), (double)(dY + dHeight), (double)dZ), Location3DImpl.create((double)(dX + dWidth), (double)(dY + dHeight), (double)(dZ + dWidthZ))};
            loa3dFace.add(a3dFace);
            a3dFace = new Location3D[]{Location3DImpl.create((double)dX, (double)dY, (double)(dZ + dWidthZ)), Location3DImpl.create((double)(dX + dWidth), (double)dY, (double)(dZ + dWidthZ)), Location3DImpl.create((double)(dX + dWidth), (double)(dY + dHeight), (double)(dZ + dWidthZ)), Location3DImpl.create((double)dX, (double)(dY + dHeight), (double)(dZ + dWidthZ))};
            loa3dFace.add(a3dFace);
        }
        return loa3dFace;
    }

    private Location[] computeStackedRiserTriangle2D(boolean bInverted, int i, double[] faX, double[] faY, double dX, double dY, double dHeight, double dWidth, double dTopSize, double dBottomSize, StackedSizeHints ssh) {
        if (ssh.getInitialBounds() == null) {
            Bounds b = BoundsImpl.create((double)dX, (double)dY, (double)dWidth, (double)dHeight);
            ssh.setInitialBounds(b);
        }
        Location[] loaFrontFace = new Location[4];
        if (this.isTransposed()) {
            double dX1 = bInverted ? dX : dX + dWidth;
            double dX2 = bInverted ? dX + dWidth : dX;
            double dTopDelta = (dHeight - dTopSize) / 2.0;
            double dBottomDelta = (dHeight - dBottomSize) / 2.0;
            loaFrontFace[0] = LocationImpl.create((double)dX1, (double)(dY + dBottomDelta + dBottomSize));
            loaFrontFace[1] = LocationImpl.create((double)dX2, (double)(dY + dTopDelta + dTopSize));
            loaFrontFace[2] = LocationImpl.create((double)dX2, (double)(dY + dTopDelta));
            loaFrontFace[3] = LocationImpl.create((double)dX1, (double)(dY + dBottomDelta));
            faX[i] = dX2;
            faY[i] = dY + dHeight / 2.0;
        } else {
            double dY1 = bInverted ? dY : dY + dHeight;
            double dY2 = bInverted ? dY + dHeight : dY;
            double dTopDelta = (dWidth - dTopSize) / 2.0;
            double dBottomDelta = (dWidth - dBottomSize) / 2.0;
            loaFrontFace[0] = LocationImpl.create((double)(dX + dBottomDelta), (double)dY1);
            loaFrontFace[1] = LocationImpl.create((double)(dX + dTopDelta), (double)dY2);
            loaFrontFace[2] = LocationImpl.create((double)(dX + dTopDelta + dTopSize), (double)dY2);
            loaFrontFace[3] = LocationImpl.create((double)(dX + dBottomDelta + dBottomSize), (double)dY1);
            faX[i] = dX + dWidth / 2.0;
            faY[i] = dY2;
        }
        return loaFrontFace;
    }

    private Location[] computeRiserTriangle2D(boolean bInverted, int i, double[] faX, double[] faY, double dX, double dY, double dHeight, double dWidth) {
        Location[] loaFrontFace = new Location[3];
        if (this.isTransposed()) {
            double dX1 = bInverted ? dX : dX + dWidth;
            double dX2 = bInverted ? dX + dWidth : dX;
            loaFrontFace[0] = LocationImpl.create((double)dX1, (double)dY);
            loaFrontFace[1] = LocationImpl.create((double)dX2, (double)(dY + dHeight / 2.0));
            loaFrontFace[2] = LocationImpl.create((double)dX1, (double)(dY + dHeight));
            faX[i] = dX2;
            faY[i] = dY + dHeight / 2.0;
        } else {
            double dY1 = bInverted ? dY : dY + dHeight;
            double dY2 = bInverted ? dY + dHeight : dY;
            loaFrontFace[0] = LocationImpl.create((double)dX, (double)dY1);
            loaFrontFace[1] = LocationImpl.create((double)(dX + dWidth / 2.0), (double)dY2);
            loaFrontFace[2] = LocationImpl.create((double)(dX + dWidth), (double)dY1);
            faX[i] = dX + dWidth / 2.0;
            faY[i] = dY2;
        }
        return loaFrontFace;
    }

    private List computeRiserTriangle3D(boolean bInverted, double dX, double dY, double dZ, double dHeight, double dWidth, double dWidthZ) {
        ArrayList<Location3D[]> loa3dFace = new ArrayList<Location3D[]>();
        if (!bInverted) {
            Location3D[] a3dFace = new Location3D[]{Location3DImpl.create((double)(dX + dWidth), (double)(dY + dHeight), (double)(dZ + dWidthZ)), Location3DImpl.create((double)dX, (double)(dY + dHeight), (double)(dZ + dWidthZ)), Location3DImpl.create((double)(dX + dWidth / 2.0), (double)dY, (double)(dZ + dWidthZ / 2.0))};
            loa3dFace.add(a3dFace);
            a3dFace = new Location3D[]{Location3DImpl.create((double)dX, (double)(dY + dHeight), (double)dZ), Location3DImpl.create((double)(dX + dWidth), (double)(dY + dHeight), (double)dZ), Location3DImpl.create((double)(dX + dWidth / 2.0), (double)dY, (double)(dZ + dWidthZ / 2.0))};
            loa3dFace.add(a3dFace);
            a3dFace = new Location3D[]{Location3DImpl.create((double)dX, (double)(dY + dHeight), (double)(dZ + dWidthZ)), Location3DImpl.create((double)dX, (double)(dY + dHeight), (double)dZ), Location3DImpl.create((double)(dX + dWidth / 2.0), (double)dY, (double)(dZ + dWidthZ / 2.0))};
            loa3dFace.add(a3dFace);
            a3dFace = new Location3D[]{Location3DImpl.create((double)(dX + dWidth), (double)(dY + dHeight), (double)dZ), Location3DImpl.create((double)(dX + dWidth), (double)(dY + dHeight), (double)(dZ + dWidthZ)), Location3DImpl.create((double)(dX + dWidth / 2.0), (double)dY, (double)(dZ + dWidthZ / 2.0))};
            loa3dFace.add(a3dFace);
            a3dFace = new Location3D[]{Location3DImpl.create((double)dX, (double)(dY + dHeight), (double)dZ), Location3DImpl.create((double)dX, (double)(dY + dHeight), (double)(dZ + dWidthZ)), Location3DImpl.create((double)(dX + dWidth), (double)(dY + dHeight), (double)(dZ + dWidthZ)), Location3DImpl.create((double)(dX + dWidth), (double)(dY + dHeight), (double)dZ)};
            loa3dFace.add(a3dFace);
        } else {
            Location3D[] a3dFace = new Location3D[]{Location3DImpl.create((double)dX, (double)dY, (double)(dZ + dWidthZ)), Location3DImpl.create((double)(dX + dWidth), (double)dY, (double)(dZ + dWidthZ)), Location3DImpl.create((double)(dX + dWidth / 2.0), (double)(dY + dHeight), (double)(dZ + dWidthZ / 2.0))};
            loa3dFace.add(a3dFace);
            a3dFace = new Location3D[]{Location3DImpl.create((double)(dX + dWidth), (double)dY, (double)dZ), Location3DImpl.create((double)dX, (double)dY, (double)dZ), Location3DImpl.create((double)(dX + dWidth / 2.0), (double)(dY + dHeight), (double)(dZ + dWidthZ / 2.0))};
            loa3dFace.add(a3dFace);
            a3dFace = new Location3D[]{Location3DImpl.create((double)dX, (double)dY, (double)dZ), Location3DImpl.create((double)dX, (double)dY, (double)(dZ + dWidthZ)), Location3DImpl.create((double)(dX + dWidth / 2.0), (double)(dY + dHeight), (double)(dZ + dWidthZ / 2.0))};
            loa3dFace.add(a3dFace);
            a3dFace = new Location3D[]{Location3DImpl.create((double)(dX + dWidth), (double)dY, (double)(dZ + dWidthZ)), Location3DImpl.create((double)(dX + dWidth), (double)dY, (double)dZ), Location3DImpl.create((double)(dX + dWidth / 2.0), (double)(dY + dHeight), (double)(dZ + dWidthZ / 2.0))};
            loa3dFace.add(a3dFace);
            a3dFace = new Location3D[]{Location3DImpl.create((double)dX, (double)dY, (double)dZ), Location3DImpl.create((double)(dX + dWidth), (double)dY, (double)dZ), Location3DImpl.create((double)(dX + dWidth), (double)dY, (double)(dZ + dWidthZ)), Location3DImpl.create((double)dX, (double)dY, (double)(dZ + dWidthZ))};
            loa3dFace.add(a3dFace);
        }
        return loa3dFace;
    }

    private Location[] computeRiserTube2D(boolean bInverted, int i, double[] faX, double[] faY, double dX, double dY, double dHeight, double dWidth) {
        Location[] loaFrontFace = new Location[]{LocationImpl.create((double)dX, (double)dY), LocationImpl.create((double)dX, (double)(dY + dHeight)), LocationImpl.create((double)(dX + dWidth), (double)(dY + dHeight)), LocationImpl.create((double)(dX + dWidth), (double)dY)};
        if (this.isTransposed()) {
            faX[i] = bInverted ? dX + dWidth : dX;
            faY[i] = dY + dHeight / 2.0;
        } else {
            faX[i] = dX + dWidth / 2.0;
            faY[i] = bInverted ? dY + dHeight : dY;
        }
        return loaFrontFace;
    }

    private List computeRiserTube3D(boolean bInverted, double dX, double dY, double dZ, double dHeight, double dWidth, double dWidthZ) {
        ArrayList<Location3D[]> loa3dFace = new ArrayList<Location3D[]>();
        if (!bInverted) {
            Location3D[] a3dFace = new Location3D[]{Location3DImpl.create((double)dX, (double)(dY + dHeight), (double)dZ), Location3DImpl.create((double)dX, (double)(dY + dHeight), (double)(dZ + dWidthZ)), Location3DImpl.create((double)(dX + dWidth), (double)(dY + dHeight), (double)(dZ + dWidthZ)), Location3DImpl.create((double)(dX + dWidth), (double)(dY + dHeight), (double)dZ)};
            loa3dFace.add(a3dFace);
            a3dFace = new Location3D[]{Location3DImpl.create((double)dX, (double)dY, (double)dZ), Location3DImpl.create((double)(dX + dWidth), (double)dY, (double)dZ), Location3DImpl.create((double)(dX + dWidth), (double)dY, (double)(dZ + dWidthZ)), Location3DImpl.create((double)dX, (double)dY, (double)(dZ + dWidthZ))};
            loa3dFace.add(a3dFace);
        } else {
            Location3D[] a3dFace = new Location3D[]{Location3DImpl.create((double)dX, (double)(dY + dHeight), (double)dZ), Location3DImpl.create((double)dX, (double)(dY + dHeight), (double)(dZ + dWidthZ)), Location3DImpl.create((double)(dX + dWidth), (double)(dY + dHeight), (double)(dZ + dWidthZ)), Location3DImpl.create((double)(dX + dWidth), (double)(dY + dHeight), (double)dZ)};
            loa3dFace.add(a3dFace);
            a3dFace = new Location3D[]{Location3DImpl.create((double)dX, (double)dY, (double)dZ), Location3DImpl.create((double)(dX + dWidth), (double)dY, (double)dZ), Location3DImpl.create((double)(dX + dWidth), (double)dY, (double)(dZ + dWidthZ)), Location3DImpl.create((double)dX, (double)dY, (double)(dZ + dWidthZ))};
            loa3dFace.add(a3dFace);
        }
        return loa3dFace;
    }

    private Location[] computeStackedRiserCone2D(boolean bInverted, int i, double[] faX, double[] faY, double dX, double dY, double dHeight, double dWidth, double dTopSize, double dBottomSize) {
        Location[] loaFrontFace = new Location[4];
        if (this.isTransposed()) {
            double dX1 = bInverted ? dX : dX + dWidth;
            double dX2 = bInverted ? dX + dWidth : dX;
            double dTopDelta = (dHeight - dTopSize) / 2.0;
            double dBottomDelta = (dHeight - dBottomSize) / 2.0;
            loaFrontFace[0] = LocationImpl.create((double)dX1, (double)(dY + dBottomDelta + dBottomSize));
            loaFrontFace[1] = LocationImpl.create((double)dX2, (double)(dY + dTopDelta + dTopSize));
            loaFrontFace[2] = LocationImpl.create((double)dX2, (double)(dY + dTopDelta));
            loaFrontFace[3] = LocationImpl.create((double)dX1, (double)(dY + dBottomDelta));
            faX[i] = dX2;
            faY[i] = dY + dHeight / 2.0;
        } else {
            double dY1 = bInverted ? dY : dY + dHeight;
            double dY2 = bInverted ? dY + dHeight : dY;
            double dTopDelta = (dWidth - dTopSize) / 2.0;
            double dBottomDelta = (dWidth - dBottomSize) / 2.0;
            loaFrontFace[0] = LocationImpl.create((double)(dX + dBottomDelta), (double)dY1);
            loaFrontFace[1] = LocationImpl.create((double)(dX + dTopDelta), (double)dY2);
            loaFrontFace[2] = LocationImpl.create((double)(dX + dTopDelta + dTopSize), (double)dY2);
            loaFrontFace[3] = LocationImpl.create((double)(dX + dBottomDelta + dBottomSize), (double)dY1);
            faX[i] = dX + dWidth / 2.0;
            faY[i] = dY2;
        }
        return loaFrontFace;
    }

    private Location[] computeRiserCone2D(boolean bInverted, int i, double[] faX, double[] faY, double dX, double dY, double dHeight, double dWidth) {
        Location[] loaFrontFace = new Location[3];
        if (this.isTransposed()) {
            double dX1 = bInverted ? dX : dX + dWidth;
            double dX2 = bInverted ? dX + dWidth : dX;
            loaFrontFace[0] = LocationImpl.create((double)dX1, (double)dY);
            loaFrontFace[1] = LocationImpl.create((double)dX2, (double)(dY + dHeight / 2.0));
            loaFrontFace[2] = LocationImpl.create((double)dX1, (double)(dY + dHeight));
            faX[i] = dX2;
            faY[i] = dY + dHeight / 2.0;
        } else {
            double dY1 = bInverted ? dY : dY + dHeight;
            double dY2 = bInverted ? dY + dHeight : dY;
            loaFrontFace[0] = LocationImpl.create((double)dX, (double)dY1);
            loaFrontFace[1] = LocationImpl.create((double)(dX + dWidth / 2.0), (double)dY2);
            loaFrontFace[2] = LocationImpl.create((double)(dX + dWidth), (double)dY1);
            faX[i] = dX + dWidth / 2.0;
            faY[i] = dY2;
        }
        return loaFrontFace;
    }

    private List computeRiserCone3D(boolean bInverted, double dX, double dY, double dZ, double dHeight, double dWidth, double dWidthZ) {
        ArrayList<Location3D[]> loa3dFace = new ArrayList<Location3D[]>();
        if (!bInverted) {
            Location3D[] a3dFace = new Location3D[]{Location3DImpl.create((double)dX, (double)(dY + dHeight), (double)dZ), Location3DImpl.create((double)dX, (double)(dY + dHeight), (double)(dZ + dWidthZ)), Location3DImpl.create((double)(dX + dWidth), (double)(dY + dHeight), (double)(dZ + dWidthZ)), Location3DImpl.create((double)(dX + dWidth), (double)(dY + dHeight), (double)dZ)};
            loa3dFace.add(a3dFace);
            a3dFace = new Location3D[]{Location3DImpl.create((double)(dX + dWidth / 2.0), (double)dY, (double)(dZ + dWidthZ / 2.0))};
            loa3dFace.add(a3dFace);
        } else {
            Location3D[] a3dFace = new Location3D[]{Location3DImpl.create((double)dX, (double)dY, (double)dZ), Location3DImpl.create((double)(dX + dWidth), (double)dY, (double)dZ), Location3DImpl.create((double)(dX + dWidth), (double)dY, (double)(dZ + dWidthZ)), Location3DImpl.create((double)dX, (double)dY, (double)(dZ + dWidthZ))};
            loa3dFace.add(a3dFace);
            a3dFace = new Location3D[]{Location3DImpl.create((double)(dX + dWidth / 2.0), (double)(dY + dHeight), (double)(dZ + dWidthZ / 2.0))};
            loa3dFace.add(a3dFace);
        }
        return loa3dFace;
    }

    protected InteractionEvent createEvent(StructureSource iSource, List elTriggers, IPrimitiveRenderer ipr) {
        InteractionEvent iev = new InteractionEvent((Object)iSource);
        int t = 0;
        while (t < elTriggers.size()) {
            Trigger tg = TriggerImpl.copyInstance((Trigger)((Trigger)elTriggers.get(t)));
            this.processTrigger(tg, iSource);
            iev.addTrigger(tg);
            ++t;
        }
        return iev;
    }

    public final void renderLegendGraphic(IPrimitiveRenderer ipr, Legend lg, Fill fPaletteEntry, Bounds bo) throws ChartException {
        if (bo.getWidth() == 0.0 && bo.getHeight() == 0.0) {
            return;
        }
        BarSeries bs = (BarSeries)this.getSeries();
        ColorDefinition cd = bs.getRiserOutline();
        LineAttributes lia = LineAttributesImpl.create((ColorDefinition)(cd == null ? null : ColorDefinitionImpl.copyInstance((ColorDefinition)cd)), (LineStyle)LineStyle.SOLID_LITERAL, (int)1);
        if (fPaletteEntry == null) {
            fPaletteEntry = ColorDefinitionImpl.RED();
        }
        Location[] loaFrontFace = null;
        switch (bs.getRiser().getValue()) {
            case 0: 
            case 2: {
                loaFrontFace = new Location[]{LocationImpl.create((double)bo.getLeft(), (double)bo.getTop()), LocationImpl.create((double)bo.getLeft(), (double)(bo.getTop() + bo.getHeight())), LocationImpl.create((double)(bo.getLeft() + bo.getWidth()), (double)(bo.getTop() + bo.getHeight())), LocationImpl.create((double)(bo.getLeft() + bo.getWidth()), (double)bo.getTop())};
                break;
            }
            case 1: 
            case 3: {
                loaFrontFace = new Location[]{LocationImpl.create((double)bo.getLeft(), (double)(bo.getTop() + bo.getHeight())), LocationImpl.create((double)(bo.getLeft() + bo.getWidth() / 2.0), (double)bo.getTop()), LocationImpl.create((double)(bo.getLeft() + bo.getWidth()), (double)(bo.getTop() + bo.getHeight()))};
                break;
            }
            default: {
                throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.legend.graphic.unknown.riser", new Object[]{bs.getRiser().getName()}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
            }
        }
        if (bs.getRiser().getValue() == 2) {
            this.renderRiserTube2D(ipr, StructureSource.createLegend((Legend)lg), null, loaFrontFace, fPaletteEntry, lia, this.getModel().getDimension(), 2.0 * this.getDeviceScale(), false, false, false, false, false);
        } else if (bs.getRiser().getValue() == 3) {
            this.renderRiserCone2D(ipr, StructureSource.createLegend((Legend)lg), null, loaFrontFace, fPaletteEntry, lia, this.getModel().getDimension(), 2.0 * this.getDeviceScale(), false, false, false, false, false, 2.0 * this.getDeviceScale());
        } else {
            this.renderPlane(ipr, StructureSource.createLegend((Legend)lg), loaFrontFace, fPaletteEntry, lia, this.getModel().getDimension(), 3.0 * this.getDeviceScale(), false);
        }
    }

    private Location[] createLocationArray(List ll) {
        Location[] loa = new Location[ll.size()];
        int i = 0;
        while (i < loa.length) {
            double[] obj = (double[])ll.get(i);
            loa[i] = LocationImpl.create((double)obj[0], (double)obj[1]);
            ++i;
        }
        return loa;
    }

    public void compute(Bounds bo, Plot p, ISeriesRenderingHints isrh) throws ChartException {
    }

    private void renderRiserTube2D(IPrimitiveRenderer ipr, Object oSource, DataPointHints dpha, Location[] loaFront, Fill f, LineAttributes lia, ChartDimension cd, double dSeriesThickness, boolean bOffset, boolean bTransposed, boolean bDeferred, boolean bInverted, boolean bStacked) throws ChartException {
        EList elTriggers;
        Location origin;
        double dWidth;
        f = FillUtil.convertFillToGradient((Fill)f, (boolean)bTransposed);
        Fill fBrighter = FillUtil.getBrighterFill((Fill)f);
        LineAttributes liaBorder = LineAttributesImpl.copyInstance((LineAttributes)lia);
        if (liaBorder.getColor() == null) {
            liaBorder.setColor(FillUtil.getDarkerColor((Fill)f));
        }
        EventObjectCache eventObjectCache = (EventObjectCache)ipr;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.birt.chart.event.PolygonRenderEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PolygonRenderEvent pre = (PolygonRenderEvent)eventObjectCache.getEventObject(oSource, (Class)clazz);
        EventObjectCache eventObjectCache2 = (EventObjectCache)ipr;
        Class<?> clazz2 = class$3;
        if (clazz2 == null) {
            try {
                clazz2 = class$3 = Class.forName("org.eclipse.birt.chart.event.LineRenderEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LineRenderEvent lre = (LineRenderEvent)eventObjectCache2.getEventObject(oSource, (Class)clazz2);
        EventObjectCache eventObjectCache3 = (EventObjectCache)ipr;
        Class<?> clazz3 = class$4;
        if (clazz3 == null) {
            try {
                clazz3 = class$4 = Class.forName("org.eclipse.birt.chart.event.OvalRenderEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        OvalRenderEvent ore = (OvalRenderEvent)eventObjectCache3.getEventObject(oSource, (Class)clazz3);
        EventObjectCache eventObjectCache4 = (EventObjectCache)ipr;
        Class<?> clazz4 = class$5;
        if (clazz4 == null) {
            try {
                clazz4 = class$5 = Class.forName("org.eclipse.birt.chart.event.ArcRenderEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ArcRenderEvent are = (ArcRenderEvent)eventObjectCache4.getEventObject(oSource, (Class)clazz4);
        double d = dWidth = bTransposed ? loaFront[1].getY() - loaFront[0].getY() : loaFront[2].getX() - loaFront[1].getX();
        if (bOffset) {
            int i = 0;
            while (i < loaFront.length) {
                if (bTransposed) {
                    loaFront[i].setX(loaFront[i].getX() + dSeriesThickness);
                } else {
                    loaFront[i].setY(loaFront[i].getY() - dSeriesThickness);
                }
                ++i;
            }
        }
        pre.setPoints(loaFront);
        pre.setBackground(f);
        pre.setOutline(lia);
        if (bDeferred) {
            this.dc.addPlane((PrimitiveRenderEvent)pre, 2);
        } else {
            ipr.fillPolygon(pre);
        }
        if (this.isTransposed()) {
            lre.setStart(loaFront[1]);
            lre.setEnd(loaFront[2]);
        } else {
            lre.setStart(loaFront[0]);
            lre.setEnd(loaFront[1]);
        }
        lre.setLineAttributes(liaBorder);
        if (bDeferred) {
            this.dc.addLine(lre);
        } else {
            ipr.drawLine(lre);
        }
        if (this.isTransposed()) {
            lre.setStart(loaFront[0]);
            lre.setEnd(loaFront[3]);
        } else {
            lre.setStart(loaFront[2]);
            lre.setEnd(loaFront[3]);
        }
        lre.setLineAttributes(liaBorder);
        if (bDeferred) {
            this.dc.addLine(lre);
        } else {
            ipr.drawLine(lre);
        }
        if (bTransposed) {
            origin = loaFront[0];
            ore.setBounds(BoundsImpl.create((double)(origin.getX() - dSeriesThickness), (double)(origin.getY() + dWidth), (double)(dSeriesThickness * 2.0), (double)Math.abs(dWidth)));
        } else {
            origin = loaFront[1];
            ore.setBounds(BoundsImpl.create((double)origin.getX(), (double)(origin.getY() - dSeriesThickness), (double)dWidth, (double)(dSeriesThickness * 2.0)));
        }
        ore.setBackground(f);
        ore.setOutline(lia);
        if (bDeferred) {
            this.dc.addPlane((PrimitiveRenderEvent)ore, 2);
        } else {
            ipr.fillOval(ore);
        }
        are.setBackground(null);
        are.setOutline(liaBorder);
        are.setBounds(ore.getBounds());
        are.setAngleExtent(180.0);
        are.setStyle(1);
        if (bTransposed) {
            are.setStartAngle(90.0);
        } else {
            are.setStartAngle(180.0);
        }
        if (bDeferred) {
            this.dc.addPlane((PrimitiveRenderEvent)are, 1);
        } else {
            ipr.drawArc(are);
        }
        if (bTransposed) {
            origin = loaFront[3];
            ore.setBounds(BoundsImpl.create((double)(origin.getX() - dSeriesThickness), (double)(origin.getY() + dWidth), (double)(dSeriesThickness * 2.0), (double)Math.abs(dWidth)));
        } else {
            origin = loaFront[0];
            ore.setBounds(BoundsImpl.create((double)origin.getX(), (double)(origin.getY() - dSeriesThickness), (double)dWidth, (double)(dSeriesThickness * 2.0)));
        }
        ore.setBackground(fBrighter);
        ore.setOutline(liaBorder);
        if (bStacked) {
            if (!bTransposed) {
                if (!bInverted) {
                    if (bDeferred) {
                        this.dc.addPlane((PrimitiveRenderEvent)ore, 3);
                    } else {
                        ipr.fillOval(ore);
                        ipr.drawOval(ore);
                    }
                }
            } else if (bInverted) {
                if (bDeferred) {
                    this.dc.addPlane((PrimitiveRenderEvent)ore, 3);
                } else {
                    ipr.fillOval(ore);
                    ipr.drawOval(ore);
                }
            }
        } else if (bDeferred) {
            this.dc.addPlane((PrimitiveRenderEvent)ore, 3);
        } else {
            ipr.fillOval(ore);
            ipr.drawOval(ore);
        }
        if (this.isInteractivityEnabled() && dpha != null && !(elTriggers = this.getSeries().getTriggers()).isEmpty()) {
            StructureSource iSource = WrappedStructureSource.createSeriesDataPoint((Series)this.getSeries(), (DataPointHints)dpha);
            InteractionEvent iev = this.createEvent(iSource, (List)elTriggers, ipr);
            iev.setHotSpot((PrimitiveRenderEvent)ore);
            ipr.enableInteraction(iev);
        }
    }

    private void renderRiserCone2D(IPrimitiveRenderer ipr, Object oSource, DataPointHints dpha, Location[] loaFront, Fill f, LineAttributes lia, ChartDimension cd, double dSeriesThickness, boolean bOffset, boolean bTransposed, boolean bDeferred, boolean bInverted, boolean bIsStacked, double ovalHeight) throws ChartException {
        EList elTriggers;
        LineAttributes liaBorder;
        f = FillUtil.convertFillToGradient((Fill)f, (boolean)bTransposed);
        EventObjectCache eventObjectCache = (EventObjectCache)ipr;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.birt.chart.event.PolygonRenderEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PolygonRenderEvent pre = (PolygonRenderEvent)eventObjectCache.getEventObject(oSource, (Class)clazz);
        EventObjectCache eventObjectCache2 = (EventObjectCache)ipr;
        Class<?> clazz2 = class$3;
        if (clazz2 == null) {
            try {
                clazz2 = class$3 = Class.forName("org.eclipse.birt.chart.event.LineRenderEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LineRenderEvent lre = (LineRenderEvent)eventObjectCache2.getEventObject(oSource, (Class)clazz2);
        EventObjectCache eventObjectCache3 = (EventObjectCache)ipr;
        Class<?> clazz3 = class$5;
        if (clazz3 == null) {
            try {
                clazz3 = class$5 = Class.forName("org.eclipse.birt.chart.event.ArcRenderEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ArcRenderEvent are = (ArcRenderEvent)eventObjectCache3.getEventObject(oSource, (Class)clazz3);
        double dBottomWidth = 0.0;
        dBottomWidth = bIsStacked ? (bTransposed ? loaFront[0].getY() - loaFront[3].getY() : loaFront[3].getX() - loaFront[0].getX()) : (bTransposed ? loaFront[2].getY() - loaFront[0].getY() : loaFront[2].getX() - loaFront[0].getX());
        double dTopWidth = 0.0;
        dTopWidth = bIsStacked ? (bTransposed ? loaFront[1].getY() - loaFront[2].getY() : loaFront[2].getX() - loaFront[1].getX()) : Double.NaN;
        if (bOffset) {
            int i = 0;
            while (i < loaFront.length) {
                if (bTransposed) {
                    loaFront[i].setX(loaFront[i].getX() + dSeriesThickness);
                } else {
                    loaFront[i].setY(loaFront[i].getY() - dSeriesThickness);
                }
                ++i;
            }
        }
        if ((liaBorder = LineAttributesImpl.copyInstance((LineAttributes)lia)).getColor() == null) {
            liaBorder.setColor(FillUtil.getDarkerColor((Fill)f));
        }
        Bounds boundsBottom = bTransposed ? (bIsStacked ? BoundsImpl.create((double)(loaFront[3].getX() - ovalHeight), (double)(loaFront[3].getY() + dBottomWidth), (double)(ovalHeight * 2.0), (double)Math.abs(dBottomWidth)) : BoundsImpl.create((double)(loaFront[0].getX() - ovalHeight), (double)(loaFront[0].getY() + dBottomWidth), (double)(ovalHeight * 2.0), (double)Math.abs(dBottomWidth))) : BoundsImpl.create((double)loaFront[0].getX(), (double)(loaFront[0].getY() - ovalHeight), (double)dBottomWidth, (double)(ovalHeight * 2.0));
        double topHeight = ovalHeight * dTopWidth / dBottomWidth;
        Bounds boundsTop = bTransposed ? (bIsStacked ? BoundsImpl.create((double)(loaFront[2].getX() - topHeight), (double)(loaFront[2].getY() + dTopWidth), (double)(topHeight * 2.0), (double)Math.abs(dTopWidth)) : null) : BoundsImpl.create((double)loaFront[1].getX(), (double)(loaFront[1].getY() - topHeight), (double)dTopWidth, (double)(topHeight * 2.0));
        are.setOutline(liaBorder);
        are.setBounds(boundsBottom);
        are.setBackground(f);
        are.setAngleExtent(360.0);
        are.setStyle(1);
        if (bTransposed) {
            are.setStartAngle(90.0);
        } else {
            are.setStartAngle(180.0);
        }
        if (!bIsStacked) {
            if (bDeferred) {
                this.dc.addPlane((PrimitiveRenderEvent)are, 3);
            } else {
                ipr.drawArc(are);
                ipr.fillArc(are);
            }
        } else if (bTransposed) {
            if (bInverted) {
                if (bDeferred) {
                    this.dc.addPlane((PrimitiveRenderEvent)are, 3);
                } else {
                    ipr.drawArc(are);
                    ipr.fillArc(are);
                }
            }
        } else if (!bInverted) {
            if (bDeferred) {
                this.dc.addPlane((PrimitiveRenderEvent)are, 3);
            } else {
                ipr.drawArc(are);
                ipr.fillArc(are);
            }
        }
        if (boundsTop != null) {
            are.setOutline(liaBorder);
            are.setBounds(boundsTop);
            are.setBackground(f);
            are.setAngleExtent(360.0);
            are.setStyle(1);
            if (bTransposed) {
                are.setStartAngle(90.0);
            } else {
                are.setStartAngle(180.0);
            }
            if (bIsStacked) {
                if (bTransposed) {
                    if (!bInverted) {
                        if (bDeferred) {
                            this.dc.addPlane((PrimitiveRenderEvent)are, 3);
                        } else {
                            ipr.drawArc(are);
                            ipr.fillArc(are);
                        }
                    }
                } else if (bInverted) {
                    if (bDeferred) {
                        this.dc.addPlane((PrimitiveRenderEvent)are, 3);
                    } else {
                        ipr.drawArc(are);
                        ipr.fillArc(are);
                    }
                }
            }
        }
        pre.setPoints(loaFront);
        pre.setBackground(f);
        pre.setOutline(null);
        if (bDeferred) {
            this.dc.addPlane((PrimitiveRenderEvent)pre, 2);
        } else {
            ipr.fillPolygon(pre);
        }
        lre.setLineAttributes(liaBorder);
        lre.setStart(loaFront[0]);
        lre.setEnd(loaFront[1]);
        if (bDeferred) {
            this.dc.addLine(lre);
        } else {
            ipr.drawLine(lre);
        }
        lre.setLineAttributes(liaBorder);
        if (bIsStacked) {
            lre.setStart(loaFront[3]);
            lre.setEnd(loaFront[2]);
        } else {
            lre.setStart(loaFront[2]);
            lre.setEnd(loaFront[1]);
        }
        if (bDeferred) {
            this.dc.addLine(lre);
        } else {
            ipr.drawLine(lre);
        }
        if (this.isInteractivityEnabled() && dpha != null && !(elTriggers = this.getSeries().getTriggers()).isEmpty()) {
            StructureSource iSource = WrappedStructureSource.createSeriesDataPoint((Series)this.getSeries(), (DataPointHints)dpha);
            InteractionEvent iev = this.createEvent(iSource, (List)elTriggers, ipr);
            iev.setHotSpot((PrimitiveRenderEvent)are);
            ipr.enableInteraction(iev);
        }
    }

    private void renderRiserTriangle2D(IPrimitiveRenderer ipr, Object oSource, Location[] loaFront, Fill f, LineAttributes lia, ChartDimension cd, double dSeriesThickness, boolean bDeferred, boolean bInverted, boolean bIsStacked, StackedSizeHints ssh) throws ChartException {
        if (cd.getValue() == 0) {
            EventObjectCache eventObjectCache = (EventObjectCache)ipr;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.birt.chart.event.PolygonRenderEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            PolygonRenderEvent pre = (PolygonRenderEvent)eventObjectCache.getEventObject(oSource, (Class)clazz);
            pre.setPoints(loaFront);
            pre.setBackground(f);
            pre.setOutline(lia);
            ipr.fillPolygon(pre);
            ipr.drawPolygon(pre);
            return;
        }
        boolean bSolidColor = f instanceof ColorDefinition;
        Fill fDarker = null;
        Fill fBrighter = null;
        if (cd.getValue() == 1) {
            fDarker = FillUtil.getDarkerFill((Fill)f);
            fBrighter = FillUtil.getBrighterFill((Fill)f);
        }
        int nSides = loaFront.length;
        Location[][] loaa = new Location[nSides + 1][];
        double dSmallestY = 0.0;
        int i = 0;
        while (i < nSides) {
            int j = i + 1;
            if (j >= loaFront.length) {
                j = 0;
            }
            Location[] loa = new Location[]{LocationImpl.create((double)loaFront[i].getX(), (double)loaFront[i].getY()), LocationImpl.create((double)loaFront[j].getX(), (double)loaFront[j].getY()), LocationImpl.create((double)(loaFront[j].getX() + dSeriesThickness), (double)(loaFront[j].getY() - dSeriesThickness)), LocationImpl.create((double)(loaFront[i].getX() + dSeriesThickness), (double)(loaFront[i].getY() - dSeriesThickness))};
            loaa[i] = loa;
            ++i;
        }
        loaa[nSides] = loaFront;
        int i2 = 0;
        while (i2 < nSides - 1) {
            Location[] loaI = loaa[i2];
            int j = i2 + 1;
            while (j < nSides) {
                Location[] loaJ = loaa[j];
                double dI = Bar.getY((Location[])loaI, (int)4);
                double dJ = Bar.getY((Location[])loaJ, (int)4);
                if (ChartUtil.mathGT((double)dJ, (double)dI)) {
                    loaa[i2] = loaJ;
                    loaa[j] = loaI;
                    loaI = loaJ;
                } else if (ChartUtil.mathEqual((double)dJ, (double)dI) && ChartUtil.mathGT((double)(dI = Bar.getX((Location[])loaI, (int)4)), (double)(dJ = Bar.getX((Location[])loaJ, (int)4)))) {
                    loaa[i2] = loaJ;
                    loaa[j] = loaI;
                    loaI = loaJ;
                }
                ++j;
            }
            ++i2;
        }
        int iSmallestYIndex = 0;
        int i3 = 0;
        while (i3 < nSides) {
            double dY = Bar.getY((Location[])loaa[i3], (int)4);
            if (i3 == 0) {
                dSmallestY = dY;
            } else if (ChartUtil.mathGT((double)dSmallestY, (double)dY)) {
                dSmallestY = dY;
                iSmallestYIndex = i3;
            }
            ++i3;
        }
        ArrayList<PrimitiveRenderEvent> alModel = new ArrayList<PrimitiveRenderEvent>(nSides + 1);
        int i4 = 0;
        while (i4 <= nSides + 1) {
            if (!(this.isTransposed() && bIsStacked && (i4 == 2 || i4 == 0) || !this.isTransposed() && bIsStacked && i4 == 3)) {
                EventObjectCache eventObjectCache = (EventObjectCache)ipr;
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.birt.chart.event.PolygonRenderEvent");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                PolygonRenderEvent pre = (PolygonRenderEvent)eventObjectCache.getEventObject(oSource, (Class)clazz);
                if (i4 == nSides + 1) {
                    Bounds b = ssh.getInitialBounds();
                    if (b != null && bInverted) {
                        Location[] l = new Location[4];
                        if (this.isTransposed()) {
                            l[0] = LocationImpl.create((double)loaa[i4 - 1][0].getX(), (double)b.getTop());
                            l[1] = LocationImpl.create((double)loaa[i4 - 1][1].getX(), (double)b.getTop());
                            l[2] = LocationImpl.create((double)loaa[i4 - 1][2].getX(), (double)(b.getTop() + b.getHeight()));
                            l[3] = LocationImpl.create((double)loaa[i4 - 1][3].getX(), (double)(b.getTop() + b.getHeight()));
                        } else {
                            l[0] = LocationImpl.create((double)b.getLeft(), (double)loaa[i4 - 1][0].getY());
                            l[1] = LocationImpl.create((double)b.getLeft(), (double)loaa[i4 - 1][1].getY());
                            l[2] = LocationImpl.create((double)(b.getLeft() + b.getWidth()), (double)loaa[i4 - 1][2].getY());
                            l[3] = LocationImpl.create((double)(b.getLeft() + b.getWidth()), (double)loaa[i4 - 1][3].getY());
                        }
                        pre.setPoints(l);
                        pre.setOutline(lia);
                        if (bDeferred) {
                            alModel.add(pre.copy());
                        } else {
                            ipr.fillPolygon(pre);
                        }
                    }
                } else {
                    pre.setOutline(lia);
                    pre.setPoints(loaa[i4]);
                    if (i4 < nSides) {
                        pre.setDepth(-dSeriesThickness);
                    } else {
                        pre.setDepth(0.0);
                    }
                    Fill fP = i4 == nSides ? f : (i4 == iSmallestYIndex ? fBrighter : fDarker);
                    pre.setBackground(fP);
                    if (bDeferred) {
                        alModel.add(pre.copy());
                    } else {
                        ipr.fillPolygon(pre);
                    }
                    if (i4 != nSides) {
                        if (i4 == iSmallestYIndex) {
                            if (!bSolidColor) {
                                pre.setBackground((Fill)LIGHT_GLASS);
                            }
                            if (bDeferred) {
                                alModel.add(pre.copy());
                            } else {
                                ipr.fillPolygon(pre);
                            }
                        } else {
                            if (!bSolidColor) {
                                pre.setBackground((Fill)DARK_GLASS);
                            }
                            if (bDeferred) {
                                alModel.add(pre.copy());
                            } else {
                                ipr.fillPolygon(pre);
                            }
                        }
                    }
                    if (!bDeferred) {
                        ipr.drawPolygon(pre);
                    }
                }
            }
            ++i4;
        }
        if (!alModel.isEmpty()) {
            this.dc.addModel(new WrappedInstruction(this.getDeferredCache(), alModel, 2));
        }
    }

    private void renderRiserTube3D(IPrimitiveRenderer ipr, Object oSource, List loaFace, Fill f, LineAttributes lia, DataPointHints dpha) throws ChartException {
        EList elTriggers;
        if (loaFace == null || loaFace.size() != 2) {
            throw new IllegalArgumentException();
        }
        EventObjectCache eventObjectCache = (EventObjectCache)ipr;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.chart.event.Polygon3DRenderEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Polygon3DRenderEvent pre = (Polygon3DRenderEvent)eventObjectCache.getEventObject(oSource, (Class)clazz);
        Point2D.Double[] ovalsTop = null;
        Point2D.Double[] ovalsBottom = null;
        double yTop = 0.0;
        double yBottom = 0.0;
        int i = 0;
        while (i < loaFace.size()) {
            Location3D[] locations = (Location3D[])loaFace.get(i);
            Point2D.Double pointA = new Point2D.Double(locations[0].getX(), locations[0].getZ());
            Point2D.Double pointB = new Point2D.Double(locations[2].getX(), locations[2].getZ());
            if (i == 0) {
                ovalsTop = Bar.computeOvalPoints(30, pointA, pointB);
                yTop = locations[0].getY();
            } else {
                ovalsBottom = Bar.computeOvalPoints(30, pointA, pointB);
                yBottom = locations[0].getY();
            }
            ++i;
        }
        Location3D[] topPoints = new Location3D[30];
        Location3D[] bottomPoints = new Location3D[30];
        int i2 = 0;
        while (i2 < 30) {
            topPoints[i2] = Location3DImpl.create((double)ovalsTop[i2].getX(), (double)yTop, (double)ovalsTop[i2].getY());
            bottomPoints[i2] = Location3DImpl.create((double)ovalsBottom[i2].getX(), (double)yBottom, (double)ovalsBottom[i2].getY());
            int preSize = i2 - 1;
            if (i2 == 0) {
                preSize = 29;
                topPoints[preSize] = Location3DImpl.create((double)ovalsTop[preSize].getX(), (double)yTop, (double)ovalsTop[preSize].getY());
                bottomPoints[preSize] = Location3DImpl.create((double)ovalsBottom[preSize].getX(), (double)yBottom, (double)ovalsBottom[preSize].getY());
            }
            pre.setPoints3D(new Location3D[]{topPoints[i2], bottomPoints[i2], bottomPoints[preSize], topPoints[preSize]});
            pre.setBackground(f);
            pre.setDoubleSided(false);
            this.dc.addPlane((PrimitiveRenderEvent)pre, 2);
            ++i2;
        }
        pre.setDoubleSided(false);
        pre.setBrightness(10.0);
        pre.setPoints3D(topPoints, yBottom < yTop);
        pre.setOutline(lia);
        pre.setBackground(f);
        this.dc.addPlane((PrimitiveRenderEvent)pre, 3);
        pre.setDoubleSided(false);
        pre.setPoints3D(bottomPoints, yBottom > yTop);
        pre.setOutline(lia);
        pre.setBackground(f);
        this.dc.addPlane((PrimitiveRenderEvent)pre, 3);
        if (this.isInteractivityEnabled() && !(elTriggers = this.getSeries().getTriggers()).isEmpty()) {
            StructureSource iSource = WrappedStructureSource.createSeriesDataPoint((Series)this.getSeries(), (DataPointHints)dpha);
            int i3 = 0;
            while (i3 < topPoints.length) {
                InteractionEvent iev = this.createEvent(iSource, (List)elTriggers, ipr);
                EventObjectCache eventObjectCache2 = (EventObjectCache)ipr;
                StructureSource structureSource = StructureSource.createSeries((Series)this.getSeries());
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("org.eclipse.birt.chart.event.Polygon3DRenderEvent");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Polygon3DRenderEvent pre3d = (Polygon3DRenderEvent)eventObjectCache2.getEventObject((Object)structureSource, (Class)clazz2);
                int preSize = i3 == 0 ? 29 : i3 - 1;
                pre3d.setPoints3D(new Location3D[]{topPoints[preSize], bottomPoints[preSize], bottomPoints[i3], topPoints[i3]});
                Location panningOffset = this.getPanningOffset();
                if (this.get3DEngine().processEvent((PrimitiveRenderEvent)pre3d, panningOffset.getX(), panningOffset.getY()) != null) {
                    iev.setHotSpot((PrimitiveRenderEvent)pre3d);
                    ipr.enableInteraction(iev);
                }
                ++i3;
            }
        }
    }

    private void renderRiserCone3D(IPrimitiveRenderer ipr, Object oSource, List loaFace, Fill f, LineAttributes lia, DataPointHints dpha) throws ChartException {
        EList elTriggers;
        if (loaFace == null || loaFace.size() != 2) {
            throw new IllegalArgumentException();
        }
        EventObjectCache eventObjectCache = (EventObjectCache)ipr;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.chart.event.Polygon3DRenderEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Polygon3DRenderEvent pre = (Polygon3DRenderEvent)eventObjectCache.getEventObject(oSource, (Class)clazz);
        Location3D[] locations = (Location3D[])loaFace.get(0);
        Point2D.Double pointA = new Point2D.Double(locations[0].getX(), locations[0].getZ());
        Point2D.Double pointB = new Point2D.Double(locations[2].getX(), locations[2].getZ());
        Point2D.Double[] ovals = Bar.computeOvalPoints(30, pointA, pointB);
        double yBottom = locations[0].getY();
        Location3D pTop = ((Location3D[])loaFace.get(1))[0];
        Location3D[] bottomPoints = new Location3D[30];
        int i = 0;
        while (i < 30) {
            bottomPoints[i] = Location3DImpl.create((double)ovals[i].getX(), (double)yBottom, (double)ovals[i].getY());
            int preSize = i - 1;
            if (i == 0) {
                preSize = 29;
                bottomPoints[preSize] = Location3DImpl.create((double)ovals[preSize].getX(), (double)yBottom, (double)ovals[preSize].getY());
            }
            if (pTop.getY() - yBottom > 0.0) {
                pre.setPoints3D(new Location3D[]{bottomPoints[i], bottomPoints[preSize], pTop});
            } else {
                pre.setPoints3D(new Location3D[]{bottomPoints[i], pTop, bottomPoints[preSize]});
            }
            pre.setBackground(f);
            pre.setDoubleSided(false);
            this.dc.addPlane((PrimitiveRenderEvent)pre, 2);
            ++i;
        }
        pre.setDoubleSided(false);
        pre.setPoints3D(bottomPoints, pTop.getY() - yBottom < 0.0);
        pre.setOutline(lia);
        pre.setBackground(f);
        this.dc.addPlane((PrimitiveRenderEvent)pre, 3);
        if (this.isInteractivityEnabled() && !(elTriggers = this.getSeries().getTriggers()).isEmpty()) {
            StructureSource iSource = WrappedStructureSource.createSeriesDataPoint((Series)this.getSeries(), (DataPointHints)dpha);
            int i2 = 0;
            while (i2 < bottomPoints.length) {
                InteractionEvent iev = this.createEvent(iSource, (List)elTriggers, ipr);
                EventObjectCache eventObjectCache2 = (EventObjectCache)ipr;
                StructureSource structureSource = StructureSource.createSeries((Series)this.getSeries());
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("org.eclipse.birt.chart.event.Polygon3DRenderEvent");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Polygon3DRenderEvent pre3d = (Polygon3DRenderEvent)eventObjectCache2.getEventObject((Object)structureSource, (Class)clazz2);
                int preSize = i2 == 0 ? 29 : i2 - 1;
                pre3d.setPoints3D(new Location3D[]{bottomPoints[preSize], bottomPoints[i2], pTop});
                Location panningOffset = this.getPanningOffset();
                if (this.get3DEngine().processEvent((PrimitiveRenderEvent)pre3d, panningOffset.getX(), panningOffset.getY()) != null) {
                    iev.setHotSpot((PrimitiveRenderEvent)pre3d);
                    ipr.enableInteraction(iev);
                }
                ++i2;
            }
        }
    }

    private static Point2D.Double[] computeOvalPoints(int size, Point2D.Double pointA, Point2D.Double pointB) {
        Point2D.Double original = new Point2D.Double();
        original.x = (pointA.x + pointB.x) / 2.0;
        original.y = (pointA.y + pointB.y) / 2.0;
        double width = Math.abs(pointA.x - pointB.x);
        double height = Math.abs(pointA.y - pointB.y);
        return Bar.computeOvalPoints(size, width, height, original);
    }

    private static Point2D.Double[] computeOvalPoints(int size, double width, double height, Point2D.Double original) {
        if (size <= 0 || width <= 0.0 || height <= 0.0) {
            throw new IllegalArgumentException();
        }
        Point2D.Double[] points = new Point2D.Double[size];
        double interval = Math.PI * 2 / (double)size;
        double dWidth = width / 2.0;
        double dHeight = height / 2.0;
        double degree = 0.0;
        int i = 0;
        while (i < size) {
            points[i] = new Point2D.Double(dWidth * Math.cos(degree) + original.x, dHeight * Math.sin(degree) + original.y);
            ++i;
            degree += interval;
        }
        return points;
    }

    private double computeBottomOvalHeightOfCone(int iSeriesIndex, double defaultThickness, Location[] loaFrontFace, double dValue, boolean isStacked) {
        double width = 0.0;
        double initialWidth = 0.0;
        StackedSizeHints ssh = this.getCurrentStackedSizeHints(iSeriesIndex);
        if (isStacked) {
            width = this.isTransposed() ? loaFrontFace[0].getY() - loaFrontFace[3].getY() : loaFrontFace[3].getX() - loaFrontFace[0].getX();
        } else {
            double d = width = this.isTransposed() ? loaFrontFace[2].getY() - loaFrontFace[0].getY() : loaFrontFace[2].getX() - loaFrontFace[0].getX();
        }
        if (dValue >= 0.0) {
            if (Double.isNaN(ssh.getInitialPositiveConeBottomWidth())) {
                ssh.setInitialPositiveConeBottomWidth(width);
            }
            initialWidth = ssh.getInitialPositiveConeBottomWidth();
        } else {
            if (Double.isNaN(ssh.getInitialNegativeConeBottomWidth())) {
                ssh.setInitialNegativeConeBottomWidth(width);
            }
            initialWidth = ssh.getInitialNegativeConeBottomWidth();
        }
        double value = defaultThickness * width / initialWidth;
        return value < 2.0 ? 2.0 : value;
    }

    public class StackedSizeHints {
        public double fdLastPositiveBottom = Double.NaN;
        public double fdRemainedPositiveTotal = Double.NaN;
        public double fdLastNegativeBottom = Double.NaN;
        public double fdRemainedNegativeTotal = Double.NaN;
        private double fdInitialPositiveConeBottomWidth = Double.NaN;
        private double fdInitialNegativeConeBottomWidth = Double.NaN;
        private Bounds fbInitialTriangleBounds = null;

        public double getLastPositiveBottom() {
            return this.fdLastPositiveBottom;
        }

        public void setLastPositiveBottom(double fdPositiveDelta) {
            this.fdLastPositiveBottom = fdPositiveDelta;
        }

        public double getRemainedPositiveTotal() {
            return this.fdRemainedPositiveTotal;
        }

        public void setRemainedPositiveTotal(double fdRemainedPositiveTotal) {
            this.fdRemainedPositiveTotal = fdRemainedPositiveTotal;
        }

        public double getLastNegativeBottom() {
            return this.fdLastNegativeBottom;
        }

        public void setLastNegativeBottom(double fdNegativeDelta) {
            this.fdLastNegativeBottom = fdNegativeDelta;
        }

        public double getRemainedNegativeTotal() {
            return this.fdRemainedNegativeTotal;
        }

        public void setRemainedNegativeTotal(double fdRemainedNegativeTotal) {
            this.fdRemainedNegativeTotal = fdRemainedNegativeTotal;
        }

        public double getInitialPositiveConeBottomWidth() {
            return this.fdInitialPositiveConeBottomWidth;
        }

        public void setInitialPositiveConeBottomWidth(double dInitialPositiveConeBottomWidth) {
            this.fdInitialPositiveConeBottomWidth = dInitialPositiveConeBottomWidth;
        }

        public double getInitialNegativeConeBottomWidth() {
            return this.fdInitialNegativeConeBottomWidth;
        }

        public void setInitialNegativeConeBottomWidth(double dInitialNegativeConeBottomWidth) {
            this.fdInitialNegativeConeBottomWidth = dInitialNegativeConeBottomWidth;
        }

        public Bounds getInitialBounds() {
            return this.fbInitialTriangleBounds;
        }

        public void setInitialBounds(Bounds initialBounds) {
            this.fbInitialTriangleBounds = initialBounds;
        }
    }
}

