/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.databuilders;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.cosmos.rm.validation.internal.common.IValidationConstants;
import org.eclipse.cosmos.rm.validation.internal.common.IValidationMessage;
import org.eclipse.cosmos.rm.validation.internal.common.IValidationOutput;
import org.eclipse.cosmos.rm.validation.internal.databuilders.IDataBuilder;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDataBuilder<T>
extends DefaultHandler
implements IDataBuilder<T> {
    protected Locator locator;
    private String targetNamespace;
    private String defaultNamespace;
    private Map<String, String> prefixMap;
    private boolean validity;
    private IValidationMessage errorMessage;
    private byte currentPhase;
    private String filePath;
    private int supportedEvents;
    private IValidationOutput<?, ?> messageOutputter;

    public AbstractDataBuilder() {
        this.setStructureValidity(true);
        this.targetNamespace = "";
        this.prefixMap = new Hashtable<String, String>();
    }

    @Override
    public void endDefinitions() {
    }

    @Override
    public void endInstances() {
    }

    @Override
    public byte getPhase() {
        return 0;
    }

    @Override
    public void startDefinitions() {
        this.currentPhase = 1;
    }

    @Override
    public void startInstances() {
        this.currentPhase = (byte)16;
    }

    public byte getCurrentPhase() {
        return this.currentPhase;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("http://www.w3.org/2001/XMLSchema".equals(uri) && "schema".equals(localName)) {
            this.targetNamespace = attributes.getValue("targetNamespace");
            int i = 0;
            int attributeCount = attributes.getLength();
            while (i < attributeCount) {
                String[] attributeName = this.tokenizeName(attributes.getQName(i));
                if ("xmlns".equals(attributeName[0])) {
                    this.prefixMap.put(attributeName[1], attributes.getValue(i));
                } else if ("xmlns".equals(attributeName[1])) {
                    this.defaultNamespace = attributes.getValue(i);
                }
                ++i;
            }
        }
    }

    protected String[] tokenizeName(String qName) {
        String[] tokenizedQName = qName.split(":");
        if (tokenizedQName.length <= 1) {
            String[] stringArray = new String[2];
            stringArray[1] = tokenizedQName[0];
            return stringArray;
        }
        return new String[]{tokenizedQName[0], tokenizedQName[1]};
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("http://www.w3.org/2001/XMLSchema".equals(uri) && "schema".equals(localName)) {
            this.targetNamespace = "";
            this.prefixMap.clear();
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public boolean isStructureValid() {
        return this.validity;
    }

    @Override
    public void setStructureValidity(boolean validity) {
        this.validity = validity;
    }

    @Override
    public IValidationMessage getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public void setErrorMessage(IValidationMessage error) {
        this.errorMessage = error;
    }

    protected void appendToErrorMessage(String error) {
        String errMsg = this.errorMessage.getAttribute("attribute.message", null);
        if (errMsg == null) {
            errMsg = "";
        }
        if (errMsg.length() > 0) {
            errMsg = String.valueOf(errMsg) + IValidationConstants.LINE_SEPARATOR;
        }
        errMsg = String.valueOf(errMsg) + error;
    }

    public Map<String, String> getPrefixMap() {
        return this.prefixMap;
    }

    public void setPrefixMap(Map<String, String> prefix) {
        this.prefixMap = prefix;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public void setDefaultNamespace(String defaultNamespace) {
        this.defaultNamespace = defaultNamespace;
    }

    @Override
    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    @Override
    public String getFilePath() {
        return this.filePath;
    }

    @Override
    public void comment(char[] cs, int i, int j) {
    }

    protected void addEvent(int event) {
        this.addEvents(new int[]{event});
    }

    protected void addEvents(int[] events) {
        int i = 0;
        while (i < events.length) {
            this.supportedEvents |= 1 << events[i];
            ++i;
        }
    }

    @Override
    public int getSupportedEvents() {
        return this.supportedEvents;
    }

    @Override
    public IValidationOutput<?, ?> getMessageOutputter() {
        return this.messageOutputter;
    }

    @Override
    public void setMessageOutputter(IValidationOutput<?, ?> messageOutputter) {
        this.messageOutputter = messageOutputter;
    }
}

