/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.databuilders;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cosmos.rm.validation.internal.artifacts.RuleBinding;
import org.eclipse.cosmos.rm.validation.internal.artifacts.RuleBindings;
import org.eclipse.cosmos.rm.validation.internal.artifacts.Schematron;
import org.eclipse.cosmos.rm.validation.internal.common.XMLInternalUtility;
import org.eclipse.cosmos.rm.validation.internal.databuilders.AbstractDataBuilder;
import org.eclipse.cosmos.rm.validation.internal.reference.SMLExtensionFunctions;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementSchematronCacheBuilder
extends AbstractDataBuilder<RuleBindings> {
    public static final String ID = "org.eclipse.cosmos.rm.validation.ElementSchematronCacheBuilder";
    private RuleBindings dataStructure;
    protected StringBuffer buffer;
    protected String name;
    protected String type;
    protected String targetNamespace;
    private Map<String, String> schemaAttributes;
    private boolean schematronFound = false;
    private Map<String, String> prefixLookup;
    private List<RuleBinding> ruleBindings = new ArrayList<RuleBinding>();
    private RuleBinding currentRuleBinding = null;
    private boolean aliasFound = false;
    private boolean aliasesFound = false;
    private List<String> aliases;
    private boolean instance = false;
    private List<Schematron.Pattern> patterns;
    private Schematron.Pattern pattern;
    private Schematron.Rule rule;
    private boolean ruleElementHit;
    private boolean patternElementHit;
    private boolean ruleAliasFound = false;
    private boolean documentAliasFound = false;

    public ElementSchematronCacheBuilder() {
        this.dataStructure = new RuleBindings();
        this.patterns = new ArrayList<Schematron.Pattern>();
        this.addEvent(1);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("instances".equals(localName)) {
            this.instance = false;
            return;
        }
        if ("documentAlias".equals(localName)) {
            this.documentAliasFound = false;
            return;
        }
        if ("ruleAlias".equals(localName)) {
            this.ruleAliasFound = false;
            return;
        }
        if ("ruleBinding".equals(localName)) {
            if (this.currentRuleBinding.isValid()) {
                this.ruleBindings.add(this.currentRuleBinding);
            }
            this.currentRuleBinding = null;
            return;
        }
        if ("http://purl.oclc.org/dsdl/schematron".equals(uri)) {
            XMLInternalUtility.addElement(this.getBuffer(), 0, qName, true, true);
            if ("rule".equals(localName)) {
                this.pattern.addRule(this.rule);
                this.ruleElementHit = false;
                this.rule = null;
            } else if ("pattern".equals(localName)) {
                this.patterns.add(this.pattern);
                this.patternElementHit = false;
                this.pattern = null;
            } else if (this.schematronFound && "schema".equals(localName)) {
                int lineNumber = this.locator == null ? -1 : this.locator.getLineNumber();
                Schematron schematronRule = new Schematron(this.buffer, this.patterns, this.prefixLookup, lineNumber);
                if (this.name != null) {
                    this.dataStructure.bindRule(this.targetNamespace, this.name, schematronRule);
                } else if (this.type != null) {
                    this.dataStructure.bindRule(this.targetNamespace, String.valueOf(this.type) + "$typeDelim", schematronRule);
                } else if (this.aliases != null && this.ruleBindings.size() > 0) {
                    for (RuleBinding binding : this.ruleBindings) {
                        String docAlias = binding.getAlias();
                        if (docAlias == null) {
                            this.dataStructure.addGloballyBoundRule(schematronRule);
                            continue;
                        }
                        String ruleAlias = binding.getRule();
                        if (!this.aliases.contains(ruleAlias)) continue;
                        this.dataStructure.bindRule(docAlias, schematronRule);
                    }
                } else if (this.targetNamespace == null) {
                    this.ruleBindings.size();
                }
                this.prefixLookup = new HashMap<String, String>();
                this.buffer = null;
                this.name = null;
                this.schematronFound = false;
                this.aliases = null;
                this.patterns.clear();
            }
        }
        if ("http://www.w3.org/2001/XMLSchema".equals(uri)) {
            if ("schema".equals(localName)) {
                this.schemaAttributes = null;
                this.targetNamespace = null;
            } else if ("element".equals(localName)) {
                this.name = null;
            } else if ("complexType".equals(localName)) {
                this.type = null;
            }
        } else if ("http://www.w3.org/2008/01/sml-if".equals(uri)) {
            if ("aliases".equals(localName)) {
                this.aliasesFound = false;
            } else if (this.aliasFound && "alias".equals(localName)) {
                this.aliasFound = false;
            }
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("instances".equals(localName)) {
            this.instance = true;
            return;
        }
        if ("http://www.w3.org/2001/XMLSchema".equals(uri)) {
            if ("schema".equals(localName)) {
                this.schematronFound = false;
                this.targetNamespace = attributes.getValue("targetNamespace");
                this.schemaAttributes = new HashMap<String, String>();
                int x = 0;
                while (x < attributes.getLength()) {
                    String key = attributes.getQName(x);
                    if (key.startsWith("xmlns")) {
                        this.schemaAttributes.put(attributes.getQName(x), attributes.getValue(x));
                    }
                    ++x;
                }
            } else if ("element".equals(localName)) {
                this.name = attributes.getValue("name");
            } else if ("complexType".equals(localName)) {
                this.type = attributes.getValue("name");
            }
        } else if ("http://www.w3.org/2008/01/sml-if".equals(uri)) {
            if ("ruleBinding".equals(localName)) {
                this.currentRuleBinding = new RuleBinding();
            } else if ("ruleAlias".equals(localName)) {
                this.ruleAliasFound = true;
            } else if ("documentAlias".equals(localName)) {
                this.documentAliasFound = true;
            } else if ("aliases".equals(localName)) {
                this.aliasesFound = true;
                this.aliases = new ArrayList<String>();
            } else if (this.aliasesFound && "alias".equals(localName)) {
                this.aliasFound = true;
            }
        } else if ("http://purl.oclc.org/dsdl/schematron".equals(uri) && "schema".equals(localName)) {
            this.schematronFound = true;
            this.buffer = new StringBuffer();
        }
        if (this.buffer != null) {
            if ("http://purl.oclc.org/dsdl/schematron".equals(uri)) {
                if ("rule".equals(localName)) {
                    this.ruleElementHit = true;
                    this.rule = new Schematron.Rule();
                    if (this.locator != null) {
                        this.rule.setLineNumber(this.locator.getLineNumber());
                    }
                    StringBuffer ruleFragment = this.rule.getFragment();
                    ruleFragment.append("<").append(qName).append(this.printRuleAttributes(attributes)).append(">");
                    return;
                }
                if ("pattern".equals(localName)) {
                    this.patternElementHit = true;
                    this.pattern = new Schematron.Pattern();
                } else if ("ns".equals(localName)) {
                    if (this.prefixLookup == null) {
                        this.prefixLookup = new HashMap<String, String>();
                    }
                    this.prefixLookup.put(attributes.getValue("prefix"), attributes.getValue("uri").trim());
                }
                this.getBuffer().append("<").append(qName).append(this.printReplaceSMLFNAttributes(attributes)).append(">");
            } else if ("element".equals(localName) && "http://www.w3.org/2001/XMLSchema".equals(uri)) {
                this.buffer.append("<").append(qName).append(this.printSchNamespaceAttributes(attributes)).append(">");
            } else {
                this.getBuffer().append("<").append(qName).append(this.printAttributes(attributes)).append(">");
            }
        }
    }

    private StringBuffer getBuffer() {
        StringBuffer buff = this.buffer;
        if (this.ruleElementHit) {
            buff = this.rule.getFragment();
        } else if (this.patternElementHit) {
            buff = this.pattern.getFragment();
        }
        return buff;
    }

    /*
     * Unable to fully structure code
     */
    protected StringBuffer printRuleAttributes(Attributes attributes) {
        buffer = new StringBuffer();
        x = 0;
        while (x < attributes.getLength()) {
            attributeValue = attributes.getValue(x);
            if (!"context".equals(attributes.getLocalName(x))) ** GOTO lbl-1000
            this.rule.setContext(attributeValue);
            if (attributeValue.indexOf("deref") > -1) {
                buffer.append(" ").append(attributes.getQName(x)).append("=").append("\"").append("/*[1]").append("\"");
                this.rule.setMatchContainsDeref(true);
            } else lbl-1000:
            // 2 sources

            {
                buffer.append(" ").append(attributes.getQName(x)).append("=").append("\"").append(attributeValue).append("\"");
            }
            ++x;
        }
        return buffer;
    }

    protected StringBuffer printReplaceSMLFNAttributes(Attributes attributes) {
        StringBuffer buffer = new StringBuffer();
        int x = 0;
        while (x < attributes.getLength()) {
            if ("uri".equals(attributes.getLocalName(x)) && "http://www.w3.org/2008/01/sml-function".equals(attributes.getValue(x))) {
                buffer.append(" ").append(attributes.getQName(x)).append("=").append("\"").append(SMLExtensionFunctions.class.getName()).append("\"");
            } else {
                buffer.append(" ").append(attributes.getQName(x)).append("=").append("\"").append(attributes.getValue(x)).append("\"");
            }
            ++x;
        }
        return buffer;
    }

    protected StringBuffer printSchNamespaceAttributes(Attributes attributes) {
        StringBuffer buffer = new StringBuffer();
        int x = 0;
        while (x < attributes.getLength()) {
            buffer.append(" ").append(attributes.getQName(x)).append("=").append("\"").append(attributes.getValue(x)).append("\"");
            this.schemaAttributes.remove(attributes.getQName(x));
            ++x;
        }
        for (String key : this.schemaAttributes.keySet()) {
            buffer.append(" ").append(key).append("=").append("\"").append(this.schemaAttributes.get(key)).append("\"");
        }
        return buffer;
    }

    protected StringBuffer printAttributes(Attributes attributes) {
        StringBuffer buffer = new StringBuffer();
        int x = 0;
        while (x < attributes.getLength()) {
            buffer.append(" ").append(attributes.getQName(x)).append("=").append("\"").append(attributes.getValue(x)).append("\"");
            ++x;
        }
        return buffer;
    }

    @Override
    public RuleBindings getDataStructure() {
        return this.dataStructure;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.instance) {
            return;
        }
        if (this.ruleElementHit && this.rule != null) {
            StringBuffer buffer = this.rule.getFragment();
            buffer.append(new String(ch, start, length));
        }
        if (this.ruleAliasFound && this.currentRuleBinding != null) {
            String currentRule = this.currentRuleBinding.getRule();
            if (currentRule == null) {
                currentRule = "";
            }
            this.currentRuleBinding.setRule(String.valueOf(currentRule) + new String(ch, start, length));
        }
        if (this.documentAliasFound && this.currentRuleBinding != null) {
            String currentDocumentAlias = this.currentRuleBinding.getAlias();
            if (currentDocumentAlias == null) {
                currentDocumentAlias = "";
            }
            this.currentRuleBinding.setAlias(String.valueOf(currentDocumentAlias) + new String(ch, start, length));
        }
        if (this.aliasFound) {
            this.aliases.add(new String(ch, start, length));
        }
    }

    @Override
    public byte getPhase() {
        return 3;
    }
}

