/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.databuilders;

import org.eclipse.cosmos.rm.validation.internal.common.SMLIFIdentity;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.validation.internal.databuilders.AbstractDataBuilder;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityDataBuilder
extends AbstractDataBuilder<SMLIFIdentity> {
    public static final String ID = "org.eclipse.cosmos.rm.validation.IdentityDataBuilder";
    private SMLIFIdentity smlIfIdentity = new SMLIFIdentity();
    private boolean identityElementHit;
    private boolean nameElementHit;
    private boolean descriptionElementHit;
    private String name = "";
    private String description = "";

    public IdentityDataBuilder() {
        super.addEvent(1);
    }

    @Override
    public byte getPhase() {
        return 2;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.elementNotification(uri, localName, true);
        if ("identity".equals(localName)) {
            int i = 0;
            int count = attributes.getLength();
            while (i < count) {
                if ("http://www.w3.org/XML/1998/namespace".equals(attributes.getURI(i)) && "base".equals(attributes.getLocalName(i))) {
                    this.smlIfIdentity.setBaseURI(attributes.getValue(i));
                    break;
                }
                ++i;
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.nameElementHit) {
            this.name = String.valueOf(this.name) + new String(ch, start, length);
        } else if (this.descriptionElementHit) {
            this.description = String.valueOf(this.description) + new String(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.elementNotification(uri, localName, false);
    }

    private void elementNotification(String uri, String localName, boolean start) {
        if (!"http://www.w3.org/2008/01/sml-if".equals(uri)) {
            return;
        }
        if ("identity".equals(localName)) {
            this.identityElementHit = start;
        } else if (this.identityElementHit) {
            if ("name".equals(localName)) {
                this.nameElementHit = start;
                if (!start) {
                    this.smlIfIdentity.setName(this.name);
                }
            } else if ("description".equals(localName)) {
                this.descriptionElementHit = start;
                if (!start) {
                    this.smlIfIdentity.setDescription(this.description);
                }
            }
        }
    }

    @Override
    public SMLIFIdentity getDataStructure() {
        return this.smlIfIdentity;
    }

    public static String retrieveBaseURI() {
        SMLIFIdentity smlIdentity = (SMLIFIdentity)SMLValidatorUtil.retrieveDataStructure(ID);
        return smlIdentity == null ? null : smlIdentity.getBaseURI();
    }
}

