/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.databuilders;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.cosmos.rm.validation.internal.artifacts.SchemaBindingStructure;
import org.eclipse.cosmos.rm.validation.internal.databuilders.AbstractDataBuilder;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaBindingBuilder
extends AbstractDataBuilder<List<SchemaBindingStructure>> {
    public static final String ID = "org.eclipse.cosmos.rm.validation.SchemaBindingBuilder";
    private List<SchemaBindingStructure> schemaBindings = new ArrayList<SchemaBindingStructure>();
    private SchemaBindingStructure currentSchemaBinding = null;
    private boolean isDocumentAliasHit = false;
    private boolean isSchemaBindingHit = false;
    private StringBuffer documentAlias = new StringBuffer();

    public SchemaBindingBuilder() {
        super.addEvent(1);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (uri != null && uri.equals("http://www.w3.org/2008/01/sml-if") && ("schemaBinding".equals(localName) || "defaultSchema".equals(localName))) {
            this.schemaBindings.add(this.currentSchemaBinding);
            this.currentSchemaBinding = null;
            this.isSchemaBindingHit = false;
        } else if (uri != null && uri.equals("http://www.w3.org/2008/01/sml-if") && "documentAlias".equals(localName) && this.isSchemaBindingHit) {
            this.isDocumentAliasHit = false;
            this.currentSchemaBinding.addInstanceDocAlias(this.documentAlias.toString());
            this.documentAlias.setLength(0);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (uri != null && uri.equals("http://www.w3.org/2008/01/sml-if") && "documentAlias".equals(localName) && this.isSchemaBindingHit) {
            this.isDocumentAliasHit = true;
        } else if (uri != null && uri.equals("http://www.w3.org/2008/01/sml-if") && localName.equals("schemaBinding")) {
            this.currentSchemaBinding = new SchemaBindingStructure();
            this.isSchemaBindingHit = true;
        } else if (uri != null && uri.equals("http://www.w3.org/2008/01/sml-if") && localName.equals("defaultSchema")) {
            this.currentSchemaBinding = new SchemaBindingStructure();
            this.currentSchemaBinding.setDefaultSchema(true);
            this.isSchemaBindingHit = true;
        } else if (uri != null && uri.equals("http://www.w3.org/2008/01/sml-if") && localName.equals("documentAlias")) {
            if (this.currentSchemaBinding != null) {
                this.currentSchemaBinding.addInstanceDocAlias(this.documentAlias.toString());
                this.documentAlias.setLength(0);
            }
        } else if (uri != null && uri.equals("http://www.w3.org/2008/01/sml-if") && localName.equals("namespaceBinding")) {
            int idx = attributes.getIndex("namespace");
            if (idx != -1) {
                this.currentSchemaBinding.setNamespace(attributes.getValue(idx));
            }
            if ((idx = attributes.getIndex("aliases")) != -1) {
                StringTokenizer tokenizer = new StringTokenizer(attributes.getValue(idx));
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    this.currentSchemaBinding.addSchemaDocAlias(token);
                }
            }
        }
    }

    @Override
    public List<SchemaBindingStructure> getDataStructure() {
        return this.schemaBindings;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.isDocumentAliasHit) {
            String string = new String(ch, start, length);
            if (this.documentAlias.length() > 0 && string.charAt(0) == '\n' && string.trim().length() > 0) {
                this.documentAlias.append(' ');
            }
            this.documentAlias.append(string.trim());
        }
    }

    @Override
    public byte getPhase() {
        return 3;
    }
}

