/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.reference;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import org.eclipse.cosmos.rm.validation.internal.common.SMLIFIdentity;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidationMessages;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.validation.internal.reference.BadContextException;
import org.eclipse.cosmos.rm.validation.internal.reference.BadExpressionException;
import org.eclipse.cosmos.rm.validation.internal.reference.URIReference;
import org.eclipse.cosmos.rm.validation.internal.reference.XPointer;
import org.eclipse.cosmos.rm.validation.internal.reference.XPointerExpression;
import org.eclipse.cosmos.rm.validation.internal.reference.XPointerSyntaxException;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DerefXPathFunction
implements XPathFunction {
    public static final int ARITY = 1;
    private static DerefXPathFunction instance;

    public Object evaluate(List arguments) throws XPathFunctionException {
        if (arguments == null || arguments.size() <= 0) {
            throw new XPathFunctionException(SMLValidationMessages.errorInvalidArgument);
        }
        ArrayNodeList result = new ArrayNodeList();
        if (arguments.get(0) instanceof String) {
            int i = 0;
            int argCount = arguments.size();
            while (i < argCount) {
                this.evaluateExpression(result, SMLValidatorUtil.removeLineBreaks((String)arguments.get(i)));
                ++i;
            }
            return result;
        }
        SMLIFIdentity identity = (SMLIFIdentity)SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.IdentityDataBuilder");
        Map inheritanceMap = (Map)SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.TypeInheritanceDataBuilderImpl");
        Map map = inheritanceMap = inheritanceMap == null ? new Hashtable() : inheritanceMap;
        if (identity == null) {
            throw new XPathFunctionException(SMLValidationMessages.errorMissingStructure);
        }
        NodeList nodeList = null;
        nodeList = (NodeList)arguments.get(0);
        if (nodeList.getLength() <= 0) {
            throw new XPathFunctionException(SMLValidationMessages.errorInvalidArgument);
        }
        int i = 0;
        int nodeCount = nodeList.getLength();
        while (i < nodeCount) {
            Node currentNode = nodeList.item(i);
            String localName = currentNode.getLocalName();
            String uri = currentNode.getNamespaceURI();
            String string = uri = uri == null ? "" : uri;
            if (localName == null) {
                throw new XPathFunctionException(SMLValidationMessages.errorDetermineName);
            }
            if (!SMLValidatorUtil.isReference(currentNode)) {
                throw new XPathFunctionException(NLS.bind((String)SMLValidationMessages.errorWrongType, (Object)localName));
            }
            NodeList currentChildNodes = currentNode.getChildNodes();
            if (nodeList != null) {
                StringBuffer referenceExpression = new StringBuffer();
                int j = 0;
                int childNodeCount = currentChildNodes.getLength();
                while (j < childNodeCount) {
                    Node currentChildNode = currentChildNodes.item(j);
                    if ("http://www.w3.org/2008/01/sml".equals(currentChildNode.getNamespaceURI()) && "uri".equals(currentChildNode.getLocalName())) {
                        NodeList uriNodes = currentChildNode.getChildNodes();
                        int k = 0;
                        int uriNodeCount = uriNodes.getLength();
                        while (k < uriNodeCount) {
                            Node uriNode = uriNodes.item(k);
                            if (3 == uriNode.getNodeType() && uriNode.getNodeValue() != null) {
                                referenceExpression.append(SMLValidatorUtil.removeLineBreaks(uriNode.getNodeValue(), false));
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
                String referenceExp = referenceExpression.toString();
                if (referenceExp != null) {
                    this.evaluateExpression(result, referenceExp);
                }
            }
            ++i;
        }
        return result;
    }

    public void evaluateExpression(ArrayNodeList result, String referenceExp) throws XPathFunctionException {
        Exception exception = null;
        try {
            URIReference uriReference = new URIReference(referenceExp);
            Node context = null;
            try {
                context = uriReference.retrieveDocumentDOM();
            }
            catch (SMLValidatorUtil.RemoteRetrievalException remoteRetrievalException) {
                return;
            }
            if (context == null) {
                return;
            }
            String fragmentExpression = uriReference.getFragment();
            if (fragmentExpression == null) {
                result.add(context);
                return;
            }
            XPointerExpression xpointerExpression = XPointer.compile(fragmentExpression);
            result.add((Node)xpointerExpression.evaluate(context));
        }
        catch (XPointerSyntaxException e) {
            exception = e;
        }
        catch (URISyntaxException e) {
            exception = e;
        }
        catch (BadContextException e) {
            exception = e;
        }
        catch (BadExpressionException e) {
            exception = e;
        }
        if (exception != null) {
            throw new XPathFunctionException(exception);
        }
    }

    public Object evaluate(String referenceExp) throws XPathFunctionException {
        Node context;
        URIReference uriReference;
        Exception exception;
        block13: {
            SMLIFIdentity identity = (SMLIFIdentity)SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.IdentityDataBuilder");
            if (identity == null) {
                throw new XPathFunctionException(SMLValidationMessages.errorMissingStructure);
            }
            exception = null;
            if (referenceExp == null) {
                return null;
            }
            uriReference = new URIReference(referenceExp);
            try {
                context = uriReference.retrieveDocumentDOM();
            }
            catch (SMLValidatorUtil.RemoteRetrievalException remoteRetrievalException) {
                return null;
            }
            if (context != null) break block13;
            return null;
        }
        try {
            String fragmentExpression = uriReference.getFragment();
            if (fragmentExpression == null) {
                return context;
            }
            XPointerExpression xpointerExpression = XPointer.compile(fragmentExpression);
            return xpointerExpression.evaluate(context);
        }
        catch (XPointerSyntaxException e) {
            exception = e;
        }
        catch (URISyntaxException e) {
            exception = e;
        }
        catch (BadContextException e) {
            exception = e;
        }
        catch (BadExpressionException e) {
            exception = e;
        }
        if (exception != null) {
            throw new XPathFunctionException(exception);
        }
        return null;
    }

    public static XPathFunction instance() {
        if (instance == null) {
            instance = new DerefXPathFunction();
        }
        return instance;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArrayNodeList
    extends ArrayList<Node>
    implements NodeList {
        private static final long serialVersionUID = 7992097730072474662L;

        private ArrayNodeList() {
        }

        @Override
        public int getLength() {
            return super.size();
        }

        @Override
        public Node item(int index) {
            return (Node)super.get(index);
        }
    }
}

