/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.smlvalidators;

import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathFunctionException;
import org.eclipse.cosmos.rm.validation.internal.artifacts.ElementLocation;
import org.eclipse.cosmos.rm.validation.internal.artifacts.ElementTypeMap;
import org.eclipse.cosmos.rm.validation.internal.artifacts.TargetElementNode;
import org.eclipse.cosmos.rm.validation.internal.artifacts.TargetSchemaNode;
import org.eclipse.cosmos.rm.validation.internal.artifacts.TypeNode;
import org.eclipse.cosmos.rm.validation.internal.common.AbstractValidationOutput;
import org.eclipse.cosmos.rm.validation.internal.common.IValidationOutput;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidationMessages;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.validation.internal.core.AbstractSMLValidator;
import org.eclipse.cosmos.rm.validation.internal.databuilders.DataBuilderRegistry;
import org.eclipse.cosmos.rm.validation.internal.databuilders.DocumentDOMBuilder;
import org.eclipse.cosmos.rm.validation.internal.databuilders.ElementDeclarationBuilder;
import org.eclipse.cosmos.rm.validation.internal.databuilders.ElementTypeMapDataBuilder;
import org.eclipse.cosmos.rm.validation.internal.databuilders.GroupDeclarationBuilder;
import org.eclipse.cosmos.rm.validation.internal.databuilders.SubstitutionBuilder;
import org.eclipse.cosmos.rm.validation.internal.databuilders.TargetInstanceBuilder;
import org.eclipse.cosmos.rm.validation.internal.databuilders.TargetSchemaBuilder;
import org.eclipse.cosmos.rm.validation.internal.databuilders.TypeDeclarationBuilder;
import org.eclipse.cosmos.rm.validation.internal.databuilders.TypeInheritanceDataBuilderImpl;
import org.eclipse.cosmos.rm.validation.internal.reference.DerefXPathFunction;
import org.eclipse.cosmos.rm.validation.internal.reference.URIReference;
import org.eclipse.cosmos.rm.validation.internal.util.ParserHelper;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetValidator
extends AbstractSMLValidator {
    private Map<String, TargetSchemaNode> targetSchemaBuilderStructure;
    private Map<TargetElementNode, Object> targetInstanceBuilderStructure;
    private Map<String, Object> documentDOMBuilderElems;
    private Map<String, Map<String, String>> substitutionElementElems;
    private ElementTypeMap elementTypeMapBuilderStructure;
    private Map<String, Map<Object, TypeNode>> inheritance;
    private TypeDeclarationBuilder typeDeclarationBuilder;
    private IValidationOutput<String, Object> validationLogger;

    @Override
    public void initialize(Map<String, Object> validationAttribute) {
        super.initialize(validationAttribute);
        DataBuilderRegistry builderRegistry = DataBuilderRegistry.instance();
        builderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.TypeInheritanceDataBuilderImpl", new TypeInheritanceDataBuilderImpl());
        builderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.ElementTypeMapDataBuilder", new ElementTypeMapDataBuilder());
        builderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.TargetSchemaBuilder", new TargetSchemaBuilder());
        builderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.TargetInstanceBuilder", new TargetInstanceBuilder());
        builderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.SubstitutionBuilder", new SubstitutionBuilder());
        builderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.DocumentDOMBuilder", new DocumentDOMBuilder());
        builderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.TypeDeclarationBuilder", new TypeDeclarationBuilder());
        builderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.ElementDeclarationBuilder", new ElementDeclarationBuilder());
        builderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.GroupDeclarationBuilder", new GroupDeclarationBuilder());
    }

    @Override
    public boolean validate() {
        this.setTaskName(SMLValidationMessages.validationTarget);
        this.validationLogger = this.getValidationOutput();
        this.documentDOMBuilderElems = (Map)SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.DocumentDOMBuilder");
        this.substitutionElementElems = (Map)SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.SubstitutionBuilder");
        this.targetSchemaBuilderStructure = (Map)SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.TargetSchemaBuilder");
        this.targetInstanceBuilderStructure = (Map)SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.TargetInstanceBuilder");
        this.elementTypeMapBuilderStructure = (ElementTypeMap)SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.ElementTypeMapDataBuilder");
        this.inheritance = (Map)SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.TypeInheritanceDataBuilderImpl");
        this.typeDeclarationBuilder = (TypeDeclarationBuilder)DataBuilderRegistry.instance().getDataStructureBuilder("org.eclipse.cosmos.rm.validation.TypeDeclarationBuilder");
        return this.validateValues() && this.validateTargetInstance();
    }

    private boolean validateValues() {
        for (String elementName : this.targetSchemaBuilderStructure.keySet()) {
            TargetSchemaNode schemaNode = this.targetSchemaBuilderStructure.get(elementName);
            QName targetElement = schemaNode.getTargetElement();
            if (targetElement == null || this.elementTypeMapBuilderStructure.getType(targetElement.getNamespaceURI(), targetElement.getLocalPart()) != null) continue;
            ElementLocation location = schemaNode.getLocation();
            this.validationLogger.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(location.getFilePath(), location.getLineNumber(), NLS.bind((String)SMLValidationMessages.targetElementInvalidValue, (Object)(String.valueOf(targetElement.getPrefix()) + ":" + targetElement.getLocalPart()))));
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean validateTargetInstance() {
        iter = this.targetInstanceBuilderStructure.keySet().iterator();
        if (this.typeDeclarationBuilder.isStructureValid()) ** GOTO lbl17
        this.validationLogger.reportMessage(this.typeDeclarationBuilder.getErrorMessage());
        return false;
lbl-1000:
        // 1 sources

        {
            targetElementNode = iter.next();
            targetSchemaNode = this.targetSchemaBuilderStructure.get(targetElementNode.getName());
            if (targetSchemaNode == null && (subGroupMap = this.substitutionElementElems.get(targetElementNode.getUri())) != null && (subGroup = subGroupMap.get(targetElementNode.getName())) != null) {
                targetSchemaNode = this.targetSchemaBuilderStructure.get(ParserHelper.removeNameSpace(subGroup));
            }
            if (targetSchemaNode.getTargetRequired() && !TargetValidator.isURIValid(targetElementNode.getTargetURI())) {
                errorParams = new String[]{targetElementNode.getName(), String.valueOf(targetElementNode.getLocation().getLineNumber()), String.valueOf(targetElementNode.getLocation().getColumnNumber())};
                this.validationLogger.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(targetElementNode.getLocation().getFilePath(), targetElementNode.getLocation().getLineNumber(), NLS.bind((String)SMLValidationMessages.unresolveTargetURI, (Object[])errorParams)));
                return false;
            }
            if (targetSchemaNode.getTargetElement() != null && !this.validateTargetElement(targetElementNode, targetSchemaNode)) {
                return false;
            }
            if (targetSchemaNode.getTargetType() == null || this.validateTargetType(targetElementNode, targetSchemaNode)) continue;
            return false;
lbl17:
            // 2 sources

            ** while (iter.hasNext())
        }
lbl18:
        // 1 sources

        return true;
    }

    protected boolean validateTargetType(TargetElementNode targetElementNode, TargetSchemaNode targetSchemaNode) {
        boolean valid;
        String targetElementUri = targetElementNode.getTargetURI();
        String targetElementNamespace = targetElementNode.getUri();
        try {
            URIReference targetURI = new URIReference(targetElementUri);
            targetElementUri = targetURI.getDocumentReference();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        String getTargetType = this.elementTypeMapBuilderStructure.getType(targetElementNode.getUri(), targetElementUri);
        if (getTargetType != null && this.compareElementInstance(this.qNameToString(targetSchemaNode.getTargetType()), getTargetType)) {
            return true;
        }
        if (getTargetType != null) {
            Map<Object, TypeNode> inheritanceMap = this.inheritance.get(targetElementNamespace);
            boolean valid2 = false;
            if (inheritanceMap != null) {
                TypeNode parent = inheritanceMap.get(getTargetType);
                while (parent != null) {
                    if (this.compareElementInstance(parent.getType(), this.qNameToString(targetSchemaNode.getTargetType()))) {
                        valid2 = true;
                        break;
                    }
                    parent = inheritanceMap.get(parent.getType());
                }
            }
            if (valid2) {
                return true;
            }
        }
        String targetTypeUri = null;
        Object alias = this.documentDOMBuilderElems.get(targetElementUri);
        if (alias != null && alias instanceof Element) {
            targetTypeUri = ((Element)alias).getNodeName();
            targetElementNamespace = ((Element)alias).getNamespaceURI();
        }
        if (targetTypeUri != null) {
            getTargetType = this.elementTypeMapBuilderStructure.getType(targetElementNamespace, targetTypeUri);
        }
        if (getTargetType != null && this.compareElementInstance(getTargetType, this.qNameToString(targetSchemaNode.getTargetType()))) {
            return true;
        }
        if (getTargetType != null) {
            Map<Object, TypeNode> inheritanceMap = this.inheritance.get(targetElementNamespace);
            valid = false;
            if (inheritanceMap != null) {
                TypeNode parent = inheritanceMap.get(getTargetType);
                while (parent != null) {
                    if (this.compareElementInstance(parent.getType(), this.qNameToString(targetSchemaNode.getTargetType()))) {
                        valid = true;
                        break;
                    }
                    parent = inheritanceMap.get(parent.getType());
                }
            }
            if (valid) {
                return true;
            }
        }
        Map<String, String> substitionGroup = this.substitutionElementElems.get(targetElementUri);
        valid = false;
        while (substitionGroup != null) {
            getTargetType = this.elementTypeMapBuilderStructure.getType(targetElementUri, (String)((Object)substitionGroup));
            if (this.compareElementInstance(substitionGroup, this.qNameToString(targetSchemaNode.getTargetType()))) {
                valid = true;
                break;
            }
            substitionGroup = this.substitutionElementElems.get(substitionGroup);
        }
        if (valid || alias == null) {
            return true;
        }
        Object[] errorParams = new String[]{targetElementNode.getName(), targetElementNode.getLocation().getLineNumber() < 0 ? SMLValidationMessages.commonUnknown : String.valueOf(targetElementNode.getLocation().getLineNumber()), targetElementNode.getLocation().getColumnNumber() < 0 ? SMLValidationMessages.commonUnknown : String.valueOf(targetElementNode.getLocation().getColumnNumber()), targetElementUri, this.qNameToString(targetSchemaNode.getTargetType())};
        this.validationLogger.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(targetElementNode.getLocation().getFilePath(), targetElementNode.getLocation().getLineNumber(), NLS.bind((String)SMLValidationMessages.targetTypeInvalid, (Object[])errorParams)));
        return false;
    }

    protected boolean validateTargetElement(TargetElementNode targetElementNode, TargetSchemaNode targetSchemaNode) {
        String targetElementUri = targetElementNode.getTargetURI();
        String targetElementNamespace = targetElementNode.getUri();
        try {
            URIReference targetURI = new URIReference(targetElementUri);
            targetElementUri = targetURI.getDocumentReference();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        if (this.compareElementInstance(this.qNameToString(targetSchemaNode.getTargetElement()), targetElementUri)) {
            return true;
        }
        Object alias = this.documentDOMBuilderElems.get(targetElementUri);
        if (alias != null && alias instanceof Element) {
            targetElementUri = ((Element)alias).getNodeName();
            targetElementNamespace = ((Element)alias).getNamespaceURI();
        }
        if (this.compareElementInstance(targetElementUri, this.qNameToString(targetSchemaNode.getTargetElement()))) {
            return true;
        }
        Map<String, String> substitionGroupMap = this.substitutionElementElems.get(targetElementNamespace);
        boolean valid = false;
        if (substitionGroupMap != null) {
            String substitionGroup = substitionGroupMap.get(targetElementUri);
            while (substitionGroup != null) {
                if (this.compareElementInstance(substitionGroup, this.qNameToString(targetSchemaNode.getTargetElement()))) {
                    valid = true;
                    break;
                }
                substitionGroup = ParserHelper.removeNameSpace(substitionGroup);
                substitionGroup = substitionGroupMap.get(substitionGroup);
            }
        }
        if (valid || alias == null) {
            return true;
        }
        Object[] errorParams = new String[5];
        errorParams[0] = targetElementNode.getName();
        errorParams[1] = targetElementNode.getLocation().getLineNumber() < 0 ? SMLValidationMessages.commonUnknown : String.valueOf(targetElementNode.getLocation().getLineNumber());
        errorParams[2] = targetElementNode.getLocation().getColumnNumber() < 0 ? SMLValidationMessages.commonUnknown : String.valueOf(targetElementNode.getLocation().getColumnNumber());
        errorParams[3] = targetElementUri;
        QName targetElement = targetSchemaNode.getTargetElement();
        String prefix = targetElement.getPrefix();
        errorParams[4] = prefix != null && prefix.length() > 0 ? String.valueOf(prefix) + ":" + targetElement.getLocalPart() : targetElement.getLocalPart();
        this.validationLogger.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(targetElementNode.getLocation().getFilePath(), targetElementNode.getLocation().getLineNumber(), NLS.bind((String)SMLValidationMessages.invalidTargetInstance, (Object[])errorParams)));
        return false;
    }

    private String qNameToString(QName qName) {
        String prefix = qName.getPrefix();
        return prefix == null || prefix.length() <= 0 ? qName.getLocalPart() : String.valueOf(prefix) + ":" + qName.getLocalPart();
    }

    protected boolean compareElementInstance(Object elem1, Object elem2) {
        return ParserHelper.removeNameSpace((String)elem1).equals(ParserHelper.removeNameSpace((String)elem2));
    }

    protected static boolean isURIValid(String uri) {
        try {
            return ((DerefXPathFunction)DerefXPathFunction.instance()).evaluate(SMLValidatorUtil.removeLineBreaks(uri)) != null;
        }
        catch (XPathFunctionException xPathFunctionException) {
            return false;
        }
    }
}

