/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.ws.dm.muws.impl;

import java.text.ParseException;
import java.util.Date;
import javax.xml.namespace.QName;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.util.xml.XsdUtils;
import org.apache.muse.ws.dm.muws.MuwsConstants;
import org.apache.muse.ws.dm.muws.StateTransition;
import org.apache.muse.ws.dm.muws.StateType;
import org.apache.muse.ws.dm.muws.impl.SimpleStateType;
import org.apache.muse.ws.resource.basefaults.BaseFault;
import org.apache.muse.ws.resource.ext.faults.InvalidMessageFormatFault;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SimpleStateTransition
implements StateTransition {
    private static Messages _MESSAGES = MessagesFactory.get((Object)(class$org$apache$muse$ws$dm$muws$impl$SimpleStateTransition == null ? (class$org$apache$muse$ws$dm$muws$impl$SimpleStateTransition = SimpleStateTransition.class$("org.apache.muse.ws.dm.muws.impl.SimpleStateTransition")) : class$org$apache$muse$ws$dm$muws$impl$SimpleStateTransition));
    private StateType _entered = null;
    private StateType _previous = null;
    private Date _transitionTime = new Date();
    static /* synthetic */ Class class$org$apache$muse$ws$dm$muws$impl$SimpleStateTransition;

    public SimpleStateTransition(Element xml) throws BaseFault {
        Element enteredXML;
        if (xml == null) {
            throw new NullPointerException(_MESSAGES.get("NullSTElement"));
        }
        String timeString = xml.getAttribute("Time");
        if (timeString == null || timeString.length() == 0) {
            throw new InvalidMessageFormatFault(_MESSAGES.get("NoTransitionTime"));
        }
        try {
            this._transitionTime = XsdUtils.getLocalTime((String)timeString);
        }
        catch (ParseException error) {
            throw new InvalidMessageFormatFault((Throwable)error);
        }
        Element previousXML = XmlUtils.getElement((Node)xml, (QName)MuwsConstants.PREVIOUS_QNAME);
        if (previousXML != null) {
            this._previous = new SimpleStateType(previousXML);
        }
        if ((enteredXML = XmlUtils.getElement((Node)xml, (QName)MuwsConstants.ENTERED_QNAME)) == null) {
            throw new InvalidMessageFormatFault(_MESSAGES.get("NoEnteredState"));
        }
        this._entered = new SimpleStateType(enteredXML);
    }

    public SimpleStateTransition(StateType previous, StateType entered) {
        if (entered == null) {
            throw new NullPointerException(_MESSAGES.get("NullState"));
        }
        this._previous = previous;
        this._entered = entered;
    }

    public StateType getEnteredState() {
        return this._entered;
    }

    public StateType getPreviousState() {
        return this._previous;
    }

    public Date getTransitionTime() {
        return this._transitionTime;
    }

    public Element toXML() {
        return this.toXML(XmlUtils.EMPTY_DOC);
    }

    public Element toXML(Document doc) {
        if (doc == null) {
            throw new NullPointerException(_MESSAGES.get("NullDocument"));
        }
        Element root = XmlUtils.createElement((Document)doc, (QName)MuwsConstants.TRANSITION_QNAME);
        Date time = this.getTransitionTime();
        root.setAttribute("Time", XsdUtils.getLocalTimeString((Date)time));
        StateType previous = this.getPreviousState();
        if (previous != null) {
            Element previousXML = previous.toXML(doc);
            XmlUtils.setElement((Element)root, (QName)MuwsConstants.PREVIOUS_QNAME, (Node)previousXML, (boolean)true);
        }
        StateType entered = this.getEnteredState();
        Element enteredXML = entered.toXML(doc);
        XmlUtils.setElement((Element)root, (QName)MuwsConstants.ENTERED_QNAME, (Node)enteredXML, (boolean)true);
        return root;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

