/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation.withaxes;

public class AxisTickCoordinates
implements Cloneable {
    private final int size;
    private double dStart;
    private double dEnd;
    private double dStep;

    AxisTickCoordinates(int size, double dStart, double dEnd, double dStep) {
        this.size = size;
        this.dStart = dStart;
        this.dEnd = dEnd;
        this.dStep = dStep;
    }

    void setEndPoints(double dStart, double dEnd) {
        this.dStart = dStart;
        this.dEnd = dEnd;
        this.dStep = (dEnd - dStart) / (double)this.size;
    }

    public int size() {
        return this.size;
    }

    public double getStart() {
        return this.dStart;
    }

    public double getEnd() {
        return this.dEnd;
    }

    public double getStep() {
        return this.dStep;
    }

    public double getCoordinate(int index) {
        if (index == this.size - 1) {
            return this.dEnd;
        }
        return this.dStart + (double)index * this.dStep;
    }

    public double getNormalizedCoordinate(int index) {
        if (index == this.size - 1) {
            return this.dEnd - this.dStart;
        }
        return (double)index * this.dStep;
    }

    public Object clone() {
        return new AxisTickCoordinates(this.size, this.dStart, this.dEnd, this.dStep);
    }
}

