/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.de;

import java.util.logging.Logger;
import org.eclipse.birt.report.item.crosstab.core.ICrosstabConstants;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.extension.IReportItem;
import org.eclipse.birt.report.model.api.extension.ReportItem;

public class AbstractCrosstabItemHandle
extends ReportItem
implements ICrosstabConstants {
    protected ExtendedItemHandle handle;
    protected ModuleHandle moduleHandle;
    protected static Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.item.crosstab.core.de.AbstractCrosstabItemHandle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    protected AbstractCrosstabItemHandle(DesignElementHandle element) {
        if (!(element instanceof ExtendedItemHandle)) {
            throw new IllegalArgumentException("the element is not valid ExtendedItemHandle!");
        }
        this.handle = (ExtendedItemHandle)element;
        this.moduleHandle = element.getModuleHandle();
    }

    public DesignElementHandle getModelHandle() {
        return this.handle;
    }

    protected IReportItem findExtendedItem(String name, String extensionName) {
        if (extensionName == null) {
            throw new IllegalArgumentException("extension name can not be null");
        }
        DesignElementHandle element = this.moduleHandle.findElement(name);
        return CrosstabUtil.getReportItem(element, extensionName);
    }

    public CommandStack getCommandStack() {
        return this.moduleHandle.getCommandStack();
    }

    public DesignElementHandle getCrosstabHandle() {
        ExtendedItemHandle e = this.handle;
        while (e != null) {
            if ("Crosstab".equals(e.getStringProperty("extensionName"))) {
                return e;
            }
            e = e.getContainer();
        }
        return null;
    }

    public CrosstabReportItemHandle getCrosstab() {
        return (CrosstabReportItemHandle)CrosstabUtil.getReportItem(this.getCrosstabHandle());
    }

    public AbstractCrosstabItemHandle getContainer() {
        if (this.handle != null) {
            DesignElementHandle deh = this.handle.getContainer();
            if (!(deh instanceof ExtendedItemHandle)) {
                return null;
            }
            String exName = deh.getStringProperty("extensionName");
            if ("Crosstab".equals(exName) || "CrosstabView".equals(exName) || "DimensionView".equals(exName) || "LevelView".equals(exName) || "MeasureView".equals(exName)) {
                try {
                    return (AbstractCrosstabItemHandle)((ExtendedItemHandle)deh).getReportItem();
                }
                catch (ExtendedElementException extendedElementException) {
                    return null;
                }
            }
        }
        return null;
    }

    public IReportItem copy() {
        return null;
    }

    public Logger getLogger() {
        return logger;
    }

    public ModuleHandle getModuleHandle() {
        return this.moduleHandle;
    }
}

