/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.mdr.registration.common.internal;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.eclipse.cosmos.dc.mdr.registration.common.internal.SerializerUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EndPointReferenceSerializer {
    private static EndPointReferenceSerializer instance;

    private EndPointReferenceSerializer() {
    }

    public static EndPointReferenceSerializer getInstance() {
        if (instance == null) {
            instance = new EndPointReferenceSerializer();
        }
        return instance;
    }

    public Element toXML(MDRReference[] identifiers) {
        Element mdrIdentifiersElem = XmlUtils.createElement((QName)new QName("mdrAddresses"));
        Document document = mdrIdentifiersElem.getOwnerDocument();
        int i = 0;
        while (i < identifiers.length) {
            Element mdrId = XmlUtils.createElement((QName)new QName("addressEntry"));
            Attr attr = document.createAttribute("endPointReference");
            attr.setNodeValue(identifiers[i].getEndPointReferenceURI());
            mdrId.setAttributeNode(attr);
            attr = document.createAttribute("defaultResourceId");
            attr.setNodeValue(identifiers[i].getDefaultResourceId());
            mdrId.setAttributeNode(attr);
            mdrIdentifiersElem.appendChild(mdrId);
            ++i;
        }
        return mdrIdentifiersElem;
    }

    public MDRReference[] fromXML(Element mdrIdentifiers) {
        if (!mdrIdentifiers.hasChildNodes()) {
            return new MDRReference[0];
        }
        Element rootNode = SerializerUtil.findNode(mdrIdentifiers, "mdrAddresses");
        if (rootNode == null) {
            return new MDRReference[0];
        }
        ArrayList<MDRReference> mdrIdList = new ArrayList<MDRReference>();
        NodeList children = rootNode.getChildNodes();
        int i = 0;
        int childCount = children.getLength();
        while (i < childCount) {
            String[] values;
            Node node = children.item(i);
            if ("addressEntry".equals(node.getLocalName()) && (values = this.retrieveAttributes(node.getAttributes(), new String[]{"endPointReference", "defaultResourceId"})) != null && values.length == 2) {
                mdrIdList.add(new MDRReference(values[0], values[1]));
            }
            ++i;
        }
        return mdrIdList.toArray(new MDRReference[mdrIdList.size()]);
    }

    private String[] retrieveAttributes(NamedNodeMap attributes, String[] attributeNames) {
        String[] value = new String[attributeNames.length];
        int i = 0;
        while (i < attributeNames.length) {
            Node node = attributes.getNamedItem(attributeNames[i]);
            String nodeValue = null;
            if (node == null || (nodeValue = node.getNodeValue()) == null) {
                return new String[0];
            }
            value[i] = nodeValue;
            ++i;
        }
        return value;
    }

    public static class MDRReference {
        private String endPointReferenceURI;
        private String defaultResourceId;
        private EndpointReference epr;

        public MDRReference(EndpointReference epr) {
            this.epr = epr;
        }

        public MDRReference(String endPointReferenceURI, String defaultResourceId) {
            this.endPointReferenceURI = endPointReferenceURI;
            this.defaultResourceId = defaultResourceId;
        }

        public MDRReference() {
        }

        public String getEndPointReferenceURI() {
            return this.endPointReferenceURI;
        }

        public void setEndPointReferenceURI(String endPointReference) {
            this.endPointReferenceURI = endPointReference;
        }

        public String getDefaultResourceId() {
            return this.defaultResourceId;
        }

        public void setDefaultResourceId(String defaultResourceId) {
            this.defaultResourceId = defaultResourceId;
        }

        public EndpointReference getEpr() {
            return this.epr;
        }

        public void setEpr(EndpointReference epr) {
            this.epr = epr;
        }
    }
}

