/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.repository.internal.operations;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.rmi.server.ExportException;
import java.util.List;
import java.util.Map;
import org.eclipse.cosmos.rm.repository.core.ISMLRepository;
import org.eclipse.cosmos.rm.repository.exception.RepositoryOperationException;
import org.eclipse.cosmos.rm.repository.internal.ISMLRepositoryConstants;
import org.eclipse.cosmos.rm.repository.internal.RepositoryMessages;
import org.eclipse.cosmos.rm.repository.internal.SMLRepositoryUtil;
import org.eclipse.cosmos.rm.repository.internal.resource.SMLIFIdentity;
import org.eclipse.cosmos.rm.repository.resource.ISMLDocument;
import org.eclipse.cosmos.rm.repository.resource.ISMLIFIdentity;
import org.eclipse.cosmos.rm.repository.resource.ISMLMetadata;
import org.eclipse.cosmos.rm.validation.internal.artifacts.RuleBinding;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidatorUtil;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportOperation {
    private StringBuffer smlifFileBuffer = new StringBuffer();
    private String rootFileName = "";
    private StringBuffer definitions = new StringBuffer();
    private StringBuffer instances = new StringBuffer();
    private StringBuffer ruleBindingsBuffer = new StringBuffer();
    private ISMLRepository repository;

    public ExportOperation(ISMLRepository repository) {
        this.repository = repository;
    }

    protected void createDirectoryStructureFor(File smlifFile) throws RepositoryOperationException {
        boolean mkdirsResult = false;
        if (!smlifFile.getParentFile().exists() && !(mkdirsResult = smlifFile.getParentFile().mkdirs())) {
            throw new RepositoryOperationException(NLS.bind((String)RepositoryMessages.exportErrorCouldNotCreateDirectoryStructure, (Object)smlifFile.getName()));
        }
    }

    protected boolean fileExistsAndIsReadable(File file) throws ExportException {
        String name = file.getName();
        if (!file.exists()) {
            throw new ExportException(NLS.bind((String)RepositoryMessages.exportErrorFileNotFound, (Object)name));
        }
        if (!file.canRead()) {
            throw new ExportException(NLS.bind((String)RepositoryMessages.exportErrorFileNotReadable, (Object)name));
        }
        return true;
    }

    protected void addFileToDefinitionsAndInstances(Map<String, String[]> aliases, ISMLDocument document, boolean useMetadata) {
        ISMLMetadata metadata = document.getMetadata();
        String name = metadata.getId().trim();
        if (name == null) {
            return;
        }
        if (metadata.getDocumentType() == 0) {
            if (this.definitions.length() == 0) {
                this.definitions.append(ISMLRepositoryConstants.definitionsStart);
            }
            this.addFileToSection(document, this.definitions, aliases, useMetadata);
        } else if (metadata.getDocumentType() == 1) {
            if (this.instances.length() == 0) {
                this.instances.append(ISMLRepositoryConstants.instancesStart);
            }
            this.addFileToSection(document, this.instances, aliases, useMetadata);
        }
    }

    protected void addFileToSection(ISMLDocument file, StringBuffer sectionBuffer, Map<String, String[]> aliases, boolean useMetadata) {
        sectionBuffer.append(this.getFileAlias(file, aliases, useMetadata));
        sectionBuffer.append(this.getFileContent(file));
        sectionBuffer.append(ISMLRepositoryConstants.docDataEnd);
    }

    protected StringBuffer getFileAlias(ISMLDocument file, Map<String, String[]> aliases, boolean useMetadata) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(ISMLRepositoryConstants.docAliasesStart);
        String id = file.getMetadata().getId();
        String[] documentAliases = aliases.get(id);
        documentAliases = documentAliases == null ? aliases.get(SMLRepositoryUtil.getAlternativeId(this.repository, id)) : documentAliases;
        String[] finalAliases = null;
        int finalAliasSize = 0;
        String[] metaDataAliases = useMetadata ? file.getMetadata().getAliases() : null;
        finalAliasSize = metaDataAliases == null ? 0 : metaDataAliases.length;
        finalAliases = new String[finalAliasSize += documentAliases == null ? 0 : documentAliases.length];
        if (metaDataAliases != null) {
            System.arraycopy(metaDataAliases, 0, finalAliases, 0, metaDataAliases.length);
        }
        if (documentAliases != null) {
            System.arraycopy(documentAliases, 0, finalAliases, metaDataAliases == null ? 0 : metaDataAliases.length, documentAliases.length);
        }
        if (finalAliases.length <= 0) {
            this.appendAliasToBuffer(SMLRepositoryUtil.getDocumentName(file), buffer);
        } else {
            int i = 0;
            while (i < finalAliases.length) {
                this.appendAliasToBuffer(finalAliases[i], buffer);
                ++i;
            }
        }
        buffer.append(ISMLRepositoryConstants.docAliasesEnd);
        buffer.append("\n");
        return buffer;
    }

    protected void appendAliasToBuffer(String alias, StringBuffer buffer) {
        buffer.append(ISMLRepositoryConstants.docAliasStart).append(alias).append(ISMLRepositoryConstants.docAliasEnd);
    }

    protected StringBuffer getFileContent(ISMLDocument modelUnitFile) {
        StringBuffer result;
        block17: {
            result = new StringBuffer();
            BufferedReader reader = null;
            try {
                try {
                    File file = new File(modelUnitFile.getMetadata().getId());
                    reader = new LineNumberReader(new FileReader(file));
                    String line = ((LineNumberReader)reader).readLine();
                    while (line != null) {
                        int idx = line.indexOf("?>");
                        if (idx != -1) {
                            result.append(line.substring(idx + 2));
                        } else {
                            result.append(line).append("\n");
                        }
                        line = ((LineNumberReader)reader).readLine();
                    }
                }
                catch (IOException exc) {
                    exc.printStackTrace();
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }

    public void exportFromFiles(ISMLDocument[] modelUnits, Map<String, String[]> aliases, RuleBinding[] ruleBindings, ISMLIFIdentity identity, boolean useMetadata, boolean replaceTarget) throws RepositoryOperationException {
        File smlifFile = new File(identity.getId());
        if (!replaceTarget && !smlifFile.exists()) {
            throw new RepositoryOperationException(NLS.bind((String)"File {0} to be appended to does not exist", (Object)identity.getId()), null);
        }
        this.rootFileName = smlifFile.getName();
        String modelName = SMLRepositoryUtil.isNullOrEmpty(identity.getName()) ? this.rootFileName : identity.getName();
        ((SMLIFIdentity)identity).setName(modelName);
        SMLRepositoryUtil.appendSMLIFIdentityInformation(this.smlifFileBuffer, identity);
        this.buildRuleBindings(modelUnits, ruleBindings, useMetadata);
        try {
            int i = 0;
            while (i < modelUnits.length) {
                String filePath = modelUnits[i].getMetadata().getId();
                File file = new File(filePath);
                if (this.fileExistsAndIsReadable(file)) {
                    if (file.isDirectory()) {
                        throw new RepositoryOperationException(NLS.bind((String)RepositoryMessages.exportErrorNameShouldNotBeDirectory, (Object)filePath), null);
                    }
                    this.addFileToDefinitionsAndInstances(aliases, modelUnits[i], useMetadata);
                }
                ++i;
            }
        }
        catch (ExportException e) {
            throw new RepositoryOperationException(e.getLocalizedMessage(), e);
        }
        this.appendDefinitionsAndInstances();
        if (smlifFile.exists()) {
            smlifFile.delete();
        }
        this.createDirectoryStructureFor(smlifFile);
        try {
            PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(smlifFile), "UTF-8"));
            writer.print(this.smlifFileBuffer.toString());
            writer.close();
        }
        catch (IOException exc) {
            throw new RepositoryOperationException(exc.getLocalizedMessage(), exc);
        }
    }

    protected void buildRuleBindings(ISMLDocument[] modelUnits, RuleBinding[] ruleBindings, boolean useMetadata) {
        if (ruleBindings == null) {
            return;
        }
        int i = 0;
        while (i < ruleBindings.length) {
            this.writeRuleBinding(ruleBindings[i].getRule(), ruleBindings[i].getAlias());
            ++i;
        }
        if (useMetadata) {
            i = 0;
            while (i < modelUnits.length) {
                Map<String, List<String>> bindings = modelUnits[i].getMetadata().getBoundRules();
                if (bindings != null) {
                    for (String alias : bindings.keySet()) {
                        List<String> rules = bindings.get(alias);
                        int j = 0;
                        int ruleCount = rules.size();
                        while (j < ruleCount) {
                            this.writeRuleBinding(rules.get(j), alias);
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
        if (this.ruleBindingsBuffer.length() > 0) {
            this.ruleBindingsBuffer.insert(0, ISMLRepositoryConstants.ruleBindingsStart);
            this.ruleBindingsBuffer.append(ISMLRepositoryConstants.ruleBindingsEnd);
        }
    }

    private void writeRuleBinding(String ruleAlias, String docAlias) {
        this.ruleBindingsBuffer.append("\t\t" + SMLValidatorUtil.beginTagFor((String)"smlif", (String)"ruleBinding") + "\n");
        if (docAlias != null) {
            this.ruleBindingsBuffer.append("\t\t\t" + SMLValidatorUtil.createElementTag((String)"smlif", (String)"documentAlias", (String)docAlias) + "\n");
        }
        this.ruleBindingsBuffer.append("\t\t\t" + SMLValidatorUtil.createElementTag((String)"smlif", (String)"ruleAlias", (String)ruleAlias) + "\n");
        this.ruleBindingsBuffer.append("\t\t" + SMLValidatorUtil.endTagFor((String)"smlif", (String)"ruleBinding") + "\n");
    }

    protected void appendDefinitionsAndInstances() {
        if (this.hasRuleBindings()) {
            this.smlifFileBuffer.append("\n").append(this.ruleBindingsBuffer);
        }
        if (this.hasDefinitions()) {
            this.definitions.append(ISMLRepositoryConstants.definitionsEnd);
            this.smlifFileBuffer.append("\n").append(this.definitions);
        }
        if (this.hasInstances()) {
            this.instances.append(ISMLRepositoryConstants.instancesEnd);
            this.smlifFileBuffer.append("\n").append(this.instances);
        }
        this.smlifFileBuffer.append(ISMLRepositoryConstants.smlifEnd);
    }

    protected boolean hasRuleBindings() {
        return this.ruleBindingsBuffer.length() > 0;
    }

    protected boolean hasDefinitions() {
        return this.definitions.length() > 0;
    }

    protected boolean hasInstances() {
        return this.instances.length() > 0;
    }
}

