/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.management.common.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.cosmos.me.management.annotations.ManagedResourceCapability;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingUtil {
    private static Annotation[] EMPTY_ANNOTATION_LIST = new Annotation[0];

    public static void extractFields(Class clazz, HashMap<String, Field> map) {
        Field[] fields;
        Field[] fieldArray = fields = clazz.getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (map.get(field.getName()) == null) {
                map.put(field.getName(), field);
            }
            ++n2;
        }
    }

    public static void getAnnotationsFromHierarchy(Class clazz, HashMap<Class, Annotation> map) {
        Annotation[] annotations;
        if (clazz == null) {
            return;
        }
        Annotation[] annotationArray = annotations = clazz.getAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (map.get(annotation.annotationType()) == null) {
                map.put(annotation.annotationType(), annotation);
            }
            ++n2;
        }
        BindingUtil.getAnnotationsFromHierarchy(clazz.getSuperclass(), map);
    }

    public static void getAnnotationsFromInterface(Class clazz, HashMap<Class, Annotation> map) {
        if (clazz == null) {
            return;
        }
        if (clazz.isInterface()) {
            BindingUtil.getAnnotationsFromHierarchy(clazz, map);
        } else {
            Class<?>[] interfazes;
            Class<?>[] classArray = interfazes = clazz.getInterfaces();
            int n = interfazes.length;
            int n2 = 0;
            while (n2 < n) {
                BindingUtil.getAnnotationsFromHierarchy(clazz, map);
                ++n2;
            }
            BindingUtil.getAnnotationsFromInterface(clazz.getSuperclass(), map);
        }
    }

    public static Annotation[] getAnnotations(Class clazz) {
        HashMap<Class, Annotation> map = new HashMap<Class, Annotation>();
        BindingUtil.getAnnotationsFromHierarchy(clazz, map);
        BindingUtil.getAnnotationsFromInterface(clazz, map);
        if (map.isEmpty()) {
            return EMPTY_ANNOTATION_LIST;
        }
        return map.values().toArray(EMPTY_ANNOTATION_LIST);
    }

    public static Annotation[] getAnnotations(Method method) {
        Annotation[] annotations;
        HashMap<Class, Annotation> map = new HashMap<Class, Annotation>();
        Annotation[] annotationArray = annotations = method.getAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (map.get(annotation.annotationType()) == null) {
                map.put(annotation.annotationType(), annotation);
            }
            ++n2;
        }
        BindingUtil.getMethodAnnotationsFromHierarchy(method, method.getDeclaringClass(), map);
        BindingUtil.getMethodAnnotationsFromInterface(method, method.getDeclaringClass(), map);
        if (map.isEmpty()) {
            return EMPTY_ANNOTATION_LIST;
        }
        return map.values().toArray(EMPTY_ANNOTATION_LIST);
    }

    public static Annotation[][] getParameterAnnotations(Method method) {
        HashMap[] maps = new HashMap[method.getParameterTypes().length];
        Annotation[][] annotationSet = method.getParameterAnnotations();
        int i = 0;
        while (i < annotationSet.length) {
            Annotation[] annotations = annotationSet[i];
            HashMap<Class<? extends Annotation>, Annotation> map = maps[i] = new HashMap<Class<? extends Annotation>, Annotation>();
            Annotation[] annotationArray = annotations;
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation annotation = annotationArray[n2];
                if (map.get(annotation.annotationType()) == null) {
                    map.put(annotation.annotationType(), annotation);
                }
                ++n2;
            }
            ++i;
        }
        BindingUtil.getMethodParameterAnnotationsFromHierarchy(method, method.getDeclaringClass(), maps);
        BindingUtil.getMethodParameterAnnotationsFromInterface(method, method.getDeclaringClass(), maps);
        ArrayList<Annotation[]> list = new ArrayList<Annotation[]>();
        HashMap[] hashMapArray = maps;
        int n = maps.length;
        int n3 = 0;
        while (n3 < n) {
            HashMap map = hashMapArray[n3];
            list.add(map.values().toArray(new Annotation[0]));
            ++n3;
        }
        return (Annotation[][])list.toArray((T[])new Annotation[0][]);
    }

    public static void getMethodAnnotationsFromHierarchy(Method method, Class clazz, HashMap<Class, Annotation> map) {
        Method superMethod = BindingUtil.getMethodFromSuper(method, clazz);
        if (superMethod != null) {
            Annotation[] annotations;
            Annotation[] annotationArray = annotations = superMethod.getAnnotations();
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation annotation = annotationArray[n2];
                if (map.get(annotation.annotationType()) == null) {
                    map.put(annotation.annotationType(), annotation);
                }
                ++n2;
            }
            BindingUtil.getMethodAnnotationsFromHierarchy(method, superMethod.getDeclaringClass().getSuperclass(), map);
        }
    }

    public static void getMethodAnnotationsFromInterface(Method method, Class clazz, HashMap<Class, Annotation> map) {
        Class<?>[] interfazes;
        int n;
        if (clazz == null) {
            return;
        }
        if (clazz.isInterface()) {
            try {
                Annotation annotation;
                Annotation[] annotations;
                Method iMethod = clazz.getMethod(method.getName(), method.getParameterTypes());
                Annotation[] annotationArray = annotations = iMethod.getAnnotations();
                int n2 = annotations.length;
                n = 0;
                while (n < n2) {
                    annotation = annotationArray[n];
                    if (map.get(annotation.annotationType()) == null) {
                        map.put(annotation.annotationType(), annotation);
                    }
                    ++n;
                }
                if (clazz.getAnnotation(ManagedResourceCapability.class) != null && map.get((annotation = clazz.getAnnotation(ManagedResourceCapability.class)).annotationType()) == null) {
                    map.put(annotation.annotationType(), annotation);
                }
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        Class<?>[] classArray = interfazes = clazz.getInterfaces();
        n = interfazes.length;
        int n3 = 0;
        while (n3 < n) {
            Class<?> interfaze = classArray[n3];
            BindingUtil.getMethodAnnotationsFromInterface(method, interfaze, map);
            ++n3;
        }
    }

    public static void getMethodParameterAnnotationsFromHierarchy(Method method, Class clazz, HashMap<Class, Annotation>[] maps) {
        Method superMethod = BindingUtil.getMethodFromSuper(method, clazz);
        if (superMethod != null) {
            Annotation[][] annotationSet = superMethod.getParameterAnnotations();
            int i = 0;
            while (i < annotationSet.length) {
                Annotation[] annotations = annotationSet[i];
                maps[i] = new HashMap<Class<? extends Annotation>, Annotation>();
                HashMap<Class<? extends Annotation>, Annotation> map = maps[i];
                Annotation[] annotationArray = annotations;
                int n = annotations.length;
                int n2 = 0;
                while (n2 < n) {
                    Annotation annotation = annotationArray[n2];
                    if (map.get(annotation.annotationType()) == null) {
                        map.put(annotation.annotationType(), annotation);
                    }
                    ++n2;
                }
                ++i;
            }
            BindingUtil.getMethodParameterAnnotationsFromHierarchy(method, superMethod.getDeclaringClass().getSuperclass(), maps);
        }
    }

    public static void getMethodParameterAnnotationsFromInterface(Method method, Class clazz, HashMap<Class, Annotation>[] maps) {
        Class<?>[] interfazes;
        if (clazz == null) {
            return;
        }
        if (clazz.isInterface()) {
            try {
                Method iMethod = clazz.getMethod(method.getName(), method.getParameterTypes());
                Annotation[][] annotationSet = iMethod.getParameterAnnotations();
                int i = 0;
                while (i < annotationSet.length) {
                    Annotation[] annotations = annotationSet[i];
                    maps[i] = new HashMap<Class<? extends Annotation>, Annotation>();
                    HashMap<Class<? extends Annotation>, Annotation> map = maps[i];
                    Annotation[] annotationArray = annotations;
                    int n = annotations.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Annotation annotation = annotationArray[n2];
                        if (map.get(annotation.annotationType()) == null) {
                            map.put(annotation.annotationType(), annotation);
                        }
                        ++n2;
                    }
                    ++i;
                }
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        Class<?>[] classArray = interfazes = clazz.getInterfaces();
        int n = interfazes.length;
        int n3 = 0;
        while (n3 < n) {
            Class<?> interfaze = classArray[n3];
            BindingUtil.getMethodParameterAnnotationsFromInterface(method, interfaze, maps);
            ++n3;
        }
    }

    public static Annotation[] getAnnotations(Field field) {
        new HashMap();
        return EMPTY_ANNOTATION_LIST;
    }

    public static Annotation getAnnotation(Class annotation, Class clazz) {
        Object ret = clazz.getAnnotation(annotation);
        if (ret != null) {
            return ret;
        }
        ret = BindingUtil.getAnnotationFromHierarchy(annotation, clazz);
        if (ret != null) {
            return ret;
        }
        return BindingUtil.getAnnotationFromInterface(annotation, clazz);
    }

    public static Annotation getAnnotationFromInterface(Class annotation, Class clazz) {
        Class<?>[] interfazes;
        if (clazz == null) {
            return null;
        }
        Object ret = clazz.getAnnotation(annotation);
        if (ret != null) {
            return ret;
        }
        Class<?>[] classArray = interfazes = clazz.getInterfaces();
        int n = interfazes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> interfaze = classArray[n2];
            ret = BindingUtil.getAnnotationFromInterface(annotation, interfaze);
            if (ret != null) {
                return ret;
            }
            ++n2;
        }
        return null;
    }

    public static Annotation getAnnotationFromHierarchy(Class annotation, Class clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.getAnnotation(annotation) != null) {
            return clazz.getAnnotation(annotation);
        }
        return BindingUtil.getAnnotationFromHierarchy(annotation, clazz.getSuperclass());
    }

    private static Method getMethodFromSuper(Method method, Class superClazz) {
        if (superClazz == null) {
            return null;
        }
        try {
            return superClazz.getMethod(method.getName(), method.getParameterTypes());
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return BindingUtil.getMethodFromSuper(method, superClazz.getSuperclass());
        }
        return null;
    }

    public static Annotation getMethodAnnotation(Class annotation, Method method) {
        Object ret = method.getAnnotation(annotation);
        if (ret != null) {
            return ret;
        }
        ret = BindingUtil.getMethodAnnotationFromHierarchy(method, annotation, method.getDeclaringClass().getSuperclass());
        if (ret != null) {
            return ret;
        }
        ret = BindingUtil.getMethodAnnotationFromInterface(method, annotation, method.getDeclaringClass());
        return ret;
    }

    public static Annotation getMethodAnnotationFromHierarchy(Method method, Class annotation, Class clazz) {
        Method superMethod = BindingUtil.getMethodFromSuper(method, clazz);
        Annotation ret = null;
        if (superMethod != null && (ret = (Annotation)superMethod.getAnnotation(annotation)) == null) {
            return BindingUtil.getMethodAnnotationFromHierarchy(method, annotation, superMethod.getDeclaringClass().getSuperclass());
        }
        return ret;
    }

    public static Annotation getMethodAnnotationFromInterface(Method method, Class annotation, Class clazz) {
        Class<?>[] interfazes;
        if (clazz == null) {
            return null;
        }
        Annotation ret = null;
        if (clazz.isInterface()) {
            try {
                Method iMethod = clazz.getMethod(method.getName(), method.getParameterTypes());
                ret = annotation.equals(ManagedResourceCapability.class) ? (Annotation)clazz.getAnnotation(annotation) : (Annotation)iMethod.getAnnotation(annotation);
                if (ret != null) {
                    return ret;
                }
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        Class<?>[] classArray = interfazes = clazz.getInterfaces();
        int n = interfazes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> interfaze = classArray[n2];
            ret = BindingUtil.getMethodAnnotationFromInterface(method, annotation, interfaze);
            if (ret != null) {
                return ret;
            }
            ++n2;
        }
        return null;
    }

    public static boolean equivalentMethod(Method iMethod, Method mMethod) {
        Class<?>[] mParms;
        Class<?>[] iParms;
        boolean ok = true;
        if (!iMethod.getName().equals(mMethod.getName())) {
            return false;
        }
        if (iMethod.getReturnType().equals(mMethod.getReturnType()) && (iParms = iMethod.getParameterTypes()).length == (mParms = mMethod.getParameterTypes()).length) {
            int i = 0;
            Class<?>[] classArray = iParms;
            int n = iParms.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> pClass = classArray[n2];
                if (!pClass.equals(mParms[i++])) {
                    ok = false;
                    break;
                }
                ++n2;
            }
        }
        return ok;
    }
}

