/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.management.common.util;

public class TextUtils {
    static final String QUOTE = "&quot;";
    static final String LESS_THAN = "&lt;";
    static final String GREATER_THAN = "&gt;";
    static final String AMPERSAND = "&amp;";

    public static String escapeForMarkup(String strin) {
        return TextUtils.escapeForMarkup(new StringBuffer(strin));
    }

    public static String escapeForMarkup(StringBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        int len = buffer.length();
        int i = 0;
        while (i < len) {
            char c = buffer.charAt(i);
            switch (c) {
                case '\"': {
                    result.append(QUOTE);
                    break;
                }
                case '<': {
                    result.append(LESS_THAN);
                    break;
                }
                case '>': {
                    result.append(GREATER_THAN);
                    break;
                }
                case '&': {
                    result.append(AMPERSAND);
                    break;
                }
                case '\r': {
                    result.append(c);
                    break;
                }
                case '\n': {
                    result.append(c);
                    break;
                }
                case '\t': {
                    result.append(c);
                    break;
                }
                default: {
                    if (c <= ' ' || c >= '\u007f') break;
                    result.append(c);
                }
            }
            ++i;
        }
        return result.toString();
    }
}

