/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.birt.helper;

import java.net.URI;
import java.util.Collection;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.WsaConstants;
import org.eclipse.cosmos.common.exceptions.CosmosException;
import org.eclipse.cosmos.dc.logging.datamgr.client.LoggingDataManagerClient;
import org.eclipse.cosmos.dc.logging.datamgr.common.CBESeverityCount;
import org.eclipse.tptp.logging.events.cbe.CommonBaseEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewHelper {
    private static NewHelper instance = new NewHelper();

    public static NewHelper getNewHelperInstance() {
        return instance;
    }

    public Collection<CommonBaseEvent> getAllCBE(String address, String logfile) throws Exception {
        Collection e = null;
        LoggingDataManagerClient dmc = null;
        URI addr = null;
        System.out.println("GetAllCBE " + address + " " + logfile);
        try {
            addr = new URI(address);
        }
        catch (Exception exception) {
            return null;
        }
        EndpointReference epr = new EndpointReference(addr);
        epr.addParameter(WsaConstants.DEFAULT_RESOURCE_ID_QNAME, (Object)"LoggingDataManager");
        dmc = new LoggingDataManagerClient(epr);
        try {
            e = dmc.getAllCBE(logfile);
        }
        catch (CosmosException ex) {
            ex.printStackTrace();
            return null;
        }
        return e;
    }

    public Collection<CBESeverityCount> getCBECountBySeverity(String address, String logfile) throws Exception {
        Collection sev = null;
        LoggingDataManagerClient dmc = null;
        URI addr = null;
        System.out.println("CBECountBySeverity " + address + " " + logfile);
        try {
            addr = new URI(address);
        }
        catch (Exception exception) {
            return null;
        }
        EndpointReference epr = new EndpointReference(addr);
        epr.addParameter(WsaConstants.DEFAULT_RESOURCE_ID_QNAME, (Object)"LoggingDataManager");
        dmc = new LoggingDataManagerClient(epr);
        try {
            sev = dmc.getCBECountBySeverity(logfile);
        }
        catch (CosmosException ex) {
            ex.printStackTrace();
        }
        return sev;
    }
}

