/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.ws.resource.metadata.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.util.xml.XmlSerializable;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.resource.metadata.WsrmdConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class PropertyMetadata
implements XmlSerializable {
    private static Messages _MESSAGES = MessagesFactory.get((Object)(class$org$apache$muse$ws$resource$metadata$impl$PropertyMetadata == null ? (class$org$apache$muse$ws$resource$metadata$impl$PropertyMetadata = PropertyMetadata.class$("org.apache.muse.ws.resource.metadata.impl.PropertyMetadata")) : class$org$apache$muse$ws$resource$metadata$impl$PropertyMetadata));
    public static final int READ_ONLY = 1;
    public static final int READ_WRITE = 2;
    public static final int APPENDABLE = 3;
    public static final int CONSTANT = 4;
    public static final int MUTABLE = 5;
    private Map _extendedMetadata = null;
    private Collection _initialValues = null;
    private int _modifiability = 2;
    private int _mutability = 5;
    private QName _qname = null;
    private Collection _staticValues = null;
    private Collection _validValues = null;
    private String _valueLowerBound = null;
    private String _valueUpperBound = null;
    static /* synthetic */ Class class$org$apache$muse$ws$resource$metadata$impl$PropertyMetadata;

    public PropertyMetadata(QName qname, String modifiability, String mutability) {
        if (qname == null) {
            throw new NullPointerException(_MESSAGES.get("NullPropertyName"));
        }
        this._qname = qname;
        this.setModifiability(modifiability);
        this.setMutability(mutability);
        this._extendedMetadata = new HashMap();
        this.setInitialValues(Collections.EMPTY_LIST);
        this.setStaticValues(Collections.EMPTY_LIST);
        this.setValidValues(Collections.EMPTY_LIST);
    }

    public PropertyMetadata(Element property) {
        if (property == null) {
            throw new NullPointerException(_MESSAGES.get("NullPropertyElement"));
        }
        String nameString = property.getAttribute("name");
        if (nameString == null || nameString.length() == 0) {
            throw new RuntimeException(_MESSAGES.get("NoPropertyName"));
        }
        this._qname = XmlUtils.parseQName((String)nameString, (Element)property);
        this._modifiability = this.parseModifiability(property);
        this._mutability = this.parseMutability(property);
        if (this._mutability == 4 && this._modifiability != 1) {
            Object[] filler = new Object[]{this._qname};
            String message = _MESSAGES.get("ConstantButNotReadOnly", filler);
            throw new IllegalStateException(message);
        }
        this._initialValues = this.parseInitialValues(property);
        this._staticValues = this.parseStaticValues(property);
        this._validValues = this.parseValidValues(property);
        Element rangeXML = XmlUtils.getElement((Node)property, (QName)WsrmdConstants.VALID_RANGE_QNAME);
        if (rangeXML != null) {
            this._valueLowerBound = rangeXML.getAttribute("lowerBound");
            this._valueUpperBound = rangeXML.getAttribute("upperBound");
            if (this._valueLowerBound != null && this._valueLowerBound.length() == 0) {
                this._valueLowerBound = null;
            }
            if (this._valueUpperBound != null && this._valueUpperBound.length() == 0) {
                this._valueUpperBound = null;
            }
        }
        this._extendedMetadata = this.parseExtendedMetadata(property);
    }

    public String getExtendedMetadata(QName elementName) {
        return (String)this._extendedMetadata.get(elementName);
    }

    public Collection getExtendedMetadataNames() {
        return Collections.unmodifiableSet(this._extendedMetadata.keySet());
    }

    public Collection getInitialValues() {
        return Collections.unmodifiableCollection(this._initialValues);
    }

    public String getLowerBound() {
        return this._valueLowerBound;
    }

    public int getModifiability() {
        return this._modifiability;
    }

    public String getModifiabilityString() {
        return this._modifiability == 1 ? "read-only" : "read-write";
    }

    public int getMutability() {
        return this._mutability;
    }

    public String getMutabilityString() {
        if (this._modifiability == 4) {
            return "constant";
        }
        if (this._modifiability == 3) {
            return "appendable";
        }
        return "mutable";
    }

    public QName getPropertyName() {
        return this._qname;
    }

    public Collection getStaticValues() {
        return Collections.unmodifiableCollection(this._staticValues);
    }

    public String getUpperBound() {
        return this._valueUpperBound;
    }

    public Collection getValidValues() {
        return Collections.unmodifiableCollection(this._validValues);
    }

    private boolean isElementInCollection(Collection setOfValues, Object value) {
        Element valueXML = null;
        if (value instanceof Element) {
            valueXML = (Element)value;
        } else {
            QName qname = this.getPropertyName();
            valueXML = XmlUtils.createElement((Document)XmlUtils.EMPTY_DOC, (QName)qname, (Object)value);
        }
        Iterator i = setOfValues.iterator();
        while (i.hasNext()) {
            Element next = (Element)i.next();
            if (!XmlUtils.equals((Element)next, (Element)valueXML)) continue;
            return true;
        }
        return false;
    }

    public boolean isInitialValue(Object value) {
        return this.isElementInCollection(this._initialValues, value);
    }

    public boolean isStaticValue(Object value) {
        return this.isElementInCollection(this._staticValues, value);
    }

    public boolean isValidValue(Object value) {
        if (this._validValues.isEmpty()) {
            return true;
        }
        return this.isElementInCollection(this._validValues, value);
    }

    private Collection parseElementCollection(Element property, QName qname) {
        ArrayList<Element> values = new ArrayList<Element>();
        Element valuesXML = XmlUtils.getElement((Node)property, (QName)qname);
        if (valuesXML != null) {
            Element[] children = XmlUtils.getAllElements((Node)valuesXML);
            for (int n = 0; n < children.length; ++n) {
                values.add(children[n]);
            }
        }
        return values;
    }

    private Map parseExtendedMetadata(Element property) {
        HashMap<QName, String> extended = new HashMap<QName, String>();
        Element[] children = XmlUtils.getAllElements((Node)property);
        for (int n = 0; n < children.length; ++n) {
            QName qname = XmlUtils.getElementQName((Element)children[n]);
            if (qname.equals(WsrmdConstants.VALID_VALUES_QNAME) || qname.equals(WsrmdConstants.VALID_RANGE_QNAME) || qname.equals(WsrmdConstants.STATIC_VALUES_QNAME) || qname.equals(WsrmdConstants.INITIAL_VALUES_QNAME)) continue;
            String value = XmlUtils.extractText((Element)children[n]);
            extended.put(qname, value);
        }
        return extended;
    }

    private Collection parseInitialValues(Element property) {
        return this.parseElementCollection(property, WsrmdConstants.INITIAL_VALUES_QNAME);
    }

    private int parseModifiability(Element property) {
        String value = property.getAttribute("modifiability");
        if (value == null || value.length() == 0) {
            return 2;
        }
        if (value.equals("read-only")) {
            return 1;
        }
        if (value.equals("read-write")) {
            return 2;
        }
        String name = property.getAttribute("name");
        Object[] filler = new Object[]{name, value};
        throw new RuntimeException(_MESSAGES.get("InvalidModifiability", filler));
    }

    private int parseMutability(Element property) {
        String value = property.getAttribute("mutability");
        if (value == null || value.length() == 0) {
            return 5;
        }
        if (value.equals("appendable")) {
            return 3;
        }
        if (value.equals("constant")) {
            return 4;
        }
        if (value.equals("mutable")) {
            return 5;
        }
        String name = property.getAttribute("name");
        Object[] filler = new Object[]{name, value};
        throw new RuntimeException(_MESSAGES.get("InvalidMutability", filler));
    }

    private Collection parseStaticValues(Element property) {
        return this.parseElementCollection(property, WsrmdConstants.STATIC_VALUES_QNAME);
    }

    private Collection parseValidValues(Element property) {
        return this.parseElementCollection(property, WsrmdConstants.VALID_VALUES_QNAME);
    }

    public void setExtendedMetadata(QName elementName, String value) {
        this._extendedMetadata.put(elementName, value);
    }

    public void setInitialValues(Collection values) {
        this._initialValues = new ArrayList(values);
    }

    public void setLowerBound(String value) {
        if (!this.getValidValues().isEmpty()) {
            Object[] filler = new Object[]{this.getPropertyName()};
            throw new RuntimeException(_MESSAGES.get("ValidValuesExists", filler));
        }
        this._valueLowerBound = value;
    }

    public void setModifiability(String value) {
        if (value.equalsIgnoreCase("read-only")) {
            this._modifiability = 1;
        } else if (value.equalsIgnoreCase("read-write")) {
            this._modifiability = 2;
        } else {
            Object[] filler = new Object[]{this._qname, value};
            throw new RuntimeException(_MESSAGES.get("InvalidModifiability", filler));
        }
    }

    public void setMutability(String value) {
        if (value.equalsIgnoreCase("constant")) {
            this._mutability = 4;
        } else if (value.equalsIgnoreCase("appendable")) {
            this._mutability = 3;
        } else if (value.equalsIgnoreCase("mutable")) {
            this._mutability = 5;
        } else {
            Object[] filler = new Object[]{this._qname, value};
            throw new RuntimeException(_MESSAGES.get("InvalidMutability", filler));
        }
    }

    public void setPropertyName(QName propertyName) {
        if (propertyName == null) {
            throw new NullPointerException(_MESSAGES.get("NullPropertyName"));
        }
        this._qname = propertyName;
    }

    public void setStaticValues(Collection values) {
        this._staticValues = new ArrayList(values);
    }

    public void setUpperBound(String value) {
        if (!this.getValidValues().isEmpty()) {
            Object[] filler = new Object[]{this.getPropertyName()};
            throw new RuntimeException(_MESSAGES.get("ValidValuesExists", filler));
        }
        this._valueUpperBound = value;
    }

    public void setValidValues(Collection values) {
        if (this.getLowerBound() != null || this.getUpperBound() != null) {
            Object[] filler = new Object[]{this.getPropertyName(), this.getLowerBound(), this.getUpperBound()};
            throw new RuntimeException(_MESSAGES.get("ValidValueRangeExists", filler));
        }
        this._validValues = new ArrayList(values);
    }

    public Element toXML() {
        return this.toXML(XmlUtils.EMPTY_DOC);
    }

    public Element toXML(Document doc) {
        Element root = XmlUtils.createElement((Document)doc, (QName)WsrmdConstants.PROPERTY_QNAME);
        QName qname = this.getPropertyName();
        root.setAttribute("name", XmlUtils.toString((QName)qname));
        XmlUtils.setNamespaceAttribute((Element)root, (String)qname.getPrefix(), (String)qname.getNamespaceURI());
        root.setAttribute("modifiability", this.getModifiabilityString());
        root.setAttribute("mutability", this.getMutabilityString());
        Element validValues = XmlUtils.createElement((Document)doc, (QName)WsrmdConstants.VALID_VALUES_QNAME);
        Element staticValues = XmlUtils.createElement((Document)doc, (QName)WsrmdConstants.STATIC_VALUES_QNAME);
        Element initialValues = XmlUtils.createElement((Document)doc, (QName)WsrmdConstants.INITIAL_VALUES_QNAME);
        Element[] values = new Element[]{validValues, staticValues, initialValues};
        Collection[] instances = new Collection[]{this.getValidValues(), this.getStaticValues(), this.getInitialValues()};
        String lowerBound = this.getLowerBound();
        String upperBound = this.getUpperBound();
        if (instances[0].isEmpty() && (lowerBound != null || upperBound != null)) {
            values[0] = XmlUtils.createElement((Document)doc, (QName)WsrmdConstants.VALID_RANGE_QNAME);
            if (lowerBound != null) {
                values[0].setAttribute("lowerBound", lowerBound);
            }
            if (upperBound != null) {
                values[0].setAttribute("upperBound", upperBound);
            }
        }
        for (int n = 0; n < values.length; ++n) {
            root.appendChild(values[n]);
            Iterator i = instances[n].iterator();
            while (i.hasNext()) {
                Element next = (Element)i.next();
                next = (Element)doc.importNode(next, true);
                values[n].appendChild(next);
            }
        }
        Iterator i = this.getExtendedMetadataNames().iterator();
        while (i.hasNext()) {
            QName name = (QName)i.next();
            String value = this.getExtendedMetadata(name);
            XmlUtils.setElement((Element)root, (QName)name, (Object)value);
        }
        return root;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

