/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.ws.resource.properties.query.impl;

import javax.xml.namespace.QName;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.util.xml.XmlSerializable;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.resource.ext.faults.InvalidMessageFormatFault;
import org.apache.muse.ws.resource.properties.WsrpConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class QueryRequest
implements XmlSerializable {
    private static Messages _MESSAGES = MessagesFactory.get((Object)(class$org$apache$muse$ws$resource$properties$query$impl$QueryRequest == null ? (class$org$apache$muse$ws$resource$properties$query$impl$QueryRequest = QueryRequest.class$("org.apache.muse.ws.resource.properties.query.impl.QueryRequest")) : class$org$apache$muse$ws$resource$properties$query$impl$QueryRequest));
    private String _dialect = null;
    private String _query = null;
    static /* synthetic */ Class class$org$apache$muse$ws$resource$properties$query$impl$QueryRequest;

    public QueryRequest(Element request) throws InvalidMessageFormatFault {
        if (request == null) {
            throw new NullPointerException(_MESSAGES.get("NullRequestElement"));
        }
        Element expression = XmlUtils.getElement((Node)request, (QName)WsrpConstants.QUERY_EXPRESSION_QNAME);
        if (expression == null) {
            throw new InvalidMessageFormatFault(_MESSAGES.get("NoQueryExpressionFound"));
        }
        this._dialect = expression.getAttribute("Dialect");
        if (this._dialect == null || this._dialect.length() == 0) {
            throw new InvalidMessageFormatFault(_MESSAGES.get("NoDialectFound"));
        }
        this._query = XmlUtils.extractText((Element)expression);
        if (this._query == null) {
            throw new InvalidMessageFormatFault(_MESSAGES.get("NoQueryFound"));
        }
    }

    public QueryRequest(String query, String dialect) {
        if (query == null) {
            throw new NullPointerException(_MESSAGES.get("NullQuery"));
        }
        if (dialect == null) {
            throw new NullPointerException(_MESSAGES.get("NullDialect"));
        }
        this._query = query;
        this._dialect = dialect;
    }

    public String getDialect() {
        return this._dialect;
    }

    public String getQuery() {
        return this._query;
    }

    public String toString() {
        return XmlUtils.toString((Node)this.toXML(), (boolean)false);
    }

    public Element toXML() {
        return this.toXML(XmlUtils.EMPTY_DOC);
    }

    public Element toXML(Document doc) {
        if (doc == null) {
            throw new NullPointerException(_MESSAGES.get("NullDocument"));
        }
        Element root = XmlUtils.createElement((Document)doc, (QName)WsrpConstants.QUERY_QNAME);
        Element query = XmlUtils.createElement((Document)doc, (QName)WsrpConstants.QUERY_EXPRESSION_QNAME);
        root.appendChild(query);
        query.setAttribute("Dialect", this.getDialect());
        Text text = doc.createTextNode(this.getQuery());
        query.appendChild(text);
        return root;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

