/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.ws.resource.sg.impl;

import java.io.File;
import java.io.IOException;
import javax.xml.namespace.QName;
import org.apache.muse.core.AbstractFilePersistence;
import org.apache.muse.core.Resource;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.resource.WsResource;
import org.apache.muse.ws.resource.sg.Entry;
import org.apache.muse.ws.resource.sg.ServiceGroup;
import org.apache.muse.ws.resource.sg.ServiceGroupPersistence;
import org.apache.muse.ws.resource.sg.WssgConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ServiceGroupFilePersistence
extends AbstractFilePersistence
implements ServiceGroupPersistence {
    private WsResource _serviceGroup = null;

    protected void createResourceFile(EndpointReference epr, Resource resource, File resourceFile) throws SoapFault {
        Entry entry = (Entry)resource.getCapability("http://docs.oasis-open.org/wsrf/sgw-2/ServiceGroupEntry");
        Element entryXML = entry.toXML();
        try {
            XmlUtils.toFile((Node)entryXML, (File)resourceFile);
        }
        catch (IOException error) {
            throw new SoapFault((Throwable)error);
        }
    }

    protected String getFilePrefix() {
        return "service-group-entry-";
    }

    public WsResource getServiceGroup() {
        return this._serviceGroup;
    }

    protected Resource reloadResource(String contextPath, Element resourceXML) throws SoapFault {
        Element entryEprXML = XmlUtils.getElement((Node)resourceXML, (QName)WssgConstants.SG_ENTRY_EPR_QNAME);
        EndpointReference entryEPR = new EndpointReference(entryEprXML);
        Element memberEprXML = XmlUtils.getElement((Node)resourceXML, (QName)WssgConstants.MEMBER_SERVICE_EPR_QNAME);
        EndpointReference memberEPR = new EndpointReference(memberEprXML);
        WsResource entryResource = (WsResource)this.getResourceManager().getResource(entryEPR);
        Entry entryCap = (Entry)entryResource.getCapability("http://docs.oasis-open.org/wsrf/sgw-2/ServiceGroupEntry");
        WsResource sgResource = this.getServiceGroup();
        entryCap.setServiceGroup(sgResource);
        entryCap.setMemberEPR(memberEPR);
        ServiceGroup sgCap = (ServiceGroup)sgResource.getCapability("http://docs.oasis-open.org/wsrf/sgw-2/ServiceGroup");
        sgCap.addEntry(memberEPR, entryResource);
        return entryResource;
    }

    public void resourceAdded(EndpointReference epr, Resource resource) throws SoapFault {
        this.createResourceFile(epr, resource);
    }

    public void resourceRemoved(EndpointReference epr) throws SoapFault {
        this.destroyResourceFile(epr);
    }

    public void setServiceGroup(WsResource serviceGroup) {
        this._serviceGroup = serviceGroup;
    }
}

