/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.ws.notification.impl;

import java.io.File;
import java.io.IOException;
import javax.xml.namespace.QName;
import org.apache.muse.core.AbstractFilePersistence;
import org.apache.muse.core.Resource;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.notification.Filter;
import org.apache.muse.ws.notification.NotificationProducer;
import org.apache.muse.ws.notification.NotificationProducerPersistence;
import org.apache.muse.ws.notification.SubscriptionManager;
import org.apache.muse.ws.notification.WsnConstants;
import org.apache.muse.ws.notification.impl.FilterFactory;
import org.apache.muse.ws.resource.WsResource;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NotificationProducerFilePersistence
extends AbstractFilePersistence
implements NotificationProducerPersistence {
    private NotificationProducer _producer = null;

    protected void createResourceFile(EndpointReference epr, Resource resource, File resourceFile) throws SoapFault {
        SubscriptionManager sub = (SubscriptionManager)resource.getCapability("http://docs.oasis-open.org/wsn/bw-2/SubscriptionManager");
        Element subXML = sub.toXML();
        try {
            XmlUtils.toFile((Node)subXML, (File)resourceFile);
        }
        catch (IOException error) {
            throw new SoapFault((Throwable)error);
        }
    }

    protected String getFilePrefix() {
        return "subscription-";
    }

    public NotificationProducer getNotificationProducer() {
        return this._producer;
    }

    protected Resource reloadResource(String contextPath, Element resourceXML) throws SoapFault {
        Element subEprXML = XmlUtils.getElement((Node)resourceXML, (QName)WsnConstants.SUBSCRIPTION_EPR_QNAME);
        EndpointReference subEPR = new EndpointReference(subEprXML);
        Element consumerEprXML = XmlUtils.getElement((Node)resourceXML, (QName)WsnConstants.CONSUMER_QNAME);
        EndpointReference consumerEPR = new EndpointReference(consumerEprXML);
        Element producerEprXML = XmlUtils.getElement((Node)resourceXML, (QName)WsnConstants.PRODUCER_QNAME);
        EndpointReference producerEPR = new EndpointReference(producerEprXML);
        Element filterXML = XmlUtils.getElement((Node)resourceXML, (QName)WsnConstants.FILTER_QNAME);
        Filter filter = FilterFactory.getInstance().newInstance(filterXML);
        WsResource subResource = (WsResource)this.getResourceManager().getResource(subEPR);
        SubscriptionManager sub = (SubscriptionManager)subResource.getCapability("http://docs.oasis-open.org/wsn/bw-2/SubscriptionManager");
        sub.setConsumerReference(consumerEPR);
        sub.setProducerReference(producerEPR);
        sub.setFilter(filter);
        this.getNotificationProducer().addSubscription(subResource);
        return subResource;
    }

    public void resourceAdded(EndpointReference epr, Resource resource) throws SoapFault {
        this.createResourceFile(epr, resource);
    }

    public void resourceRemoved(EndpointReference epr) throws SoapFault {
        this.destroyResourceFile(epr);
    }

    public void setNotificationProducer(NotificationProducer producer) {
        this._producer = producer;
    }
}

