/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.ws.notification.impl;

import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.muse.util.LoggingUtils;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.util.xml.XPathUtils;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.notification.Filter;
import org.apache.muse.ws.notification.NotificationMessage;
import org.apache.muse.ws.notification.WsnConstants;
import org.apache.muse.ws.notification.faults.InvalidProducerPropertiesExpressionFault;
import org.apache.muse.ws.resource.WsResource;
import org.apache.muse.ws.resource.properties.ResourcePropertyCollection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ProducerPropertiesFilter
implements Filter {
    private static Messages _MESSAGES = MessagesFactory.get((Object)(class$org$apache$muse$ws$notification$impl$ProducerPropertiesFilter == null ? (class$org$apache$muse$ws$notification$impl$ProducerPropertiesFilter = ProducerPropertiesFilter.class$("org.apache.muse.ws.notification.impl.ProducerPropertiesFilter")) : class$org$apache$muse$ws$notification$impl$ProducerPropertiesFilter));
    private WsResource _resource = null;
    private String _expression = null;
    static /* synthetic */ Class class$org$apache$muse$ws$notification$impl$ProducerPropertiesFilter;

    public ProducerPropertiesFilter(String expression, String dialect) throws InvalidProducerPropertiesExpressionFault {
        if (!dialect.equals("http://www.w3.org/TR/1999/REC-xpath-19991116")) {
            Object[] filler = new Object[]{dialect, "http://www.w3.org/TR/1999/REC-xpath-19991116"};
            throw new InvalidProducerPropertiesExpressionFault(_MESSAGES.get("InvalidDialect", filler));
        }
        this._expression = expression;
    }

    public boolean accepts(NotificationMessage message) {
        try {
            ResourcePropertyCollection props = this._resource.getPropertyCollection();
            Element wsrpDoc = props.getResourcePropertyDocument();
            return XPathUtils.isMatch((Node)wsrpDoc, (String)this._expression);
        }
        catch (Throwable error) {
            LoggingUtils.logError((Logger)this._resource.getLog(), (Throwable)error);
            return false;
        }
    }

    public WsResource getResource() {
        return this._resource;
    }

    public void setResource(WsResource resource) {
        this._resource = resource;
    }

    public String toString() {
        return XmlUtils.toString((Node)this.toXML(), (boolean)false);
    }

    public Element toXML() {
        return this.toXML(XmlUtils.EMPTY_DOC);
    }

    public Element toXML(Document doc) {
        Element filter = XmlUtils.createElement((Document)doc, (QName)WsnConstants.FILTER_QNAME);
        Element props = XmlUtils.createElement((Document)doc, (QName)WsnConstants.PRODUCER_PROPERTIES_QNAME, (Object)this._expression);
        props.setAttribute("Dialect", "http://www.w3.org/TR/1999/REC-xpath-19991116");
        filter.appendChild(props);
        return filter;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

