/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.ws.notification.impl;

import java.text.ParseException;
import java.util.Date;
import javax.xml.namespace.QName;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.util.xml.XmlSerializable;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.notification.Filter;
import org.apache.muse.ws.notification.WsnConstants;
import org.apache.muse.ws.notification.impl.FilterFactory;
import org.apache.muse.ws.resource.basefaults.BaseFault;
import org.apache.muse.ws.resource.ext.faults.InvalidMessageFormatFault;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Subscribe
implements XmlSerializable {
    private static Messages _MESSAGES = MessagesFactory.get((Object)(class$org$apache$muse$ws$notification$impl$Subscribe == null ? (class$org$apache$muse$ws$notification$impl$Subscribe = Subscribe.class$("org.apache.muse.ws.notification.impl.Subscribe")) : class$org$apache$muse$ws$notification$impl$Subscribe));
    private EndpointReference _consumer = null;
    private Filter _filter = null;
    private Date _terminationTime = null;
    static /* synthetic */ Class class$org$apache$muse$ws$notification$impl$Subscribe;

    public Subscribe(Element xml) throws BaseFault {
        Element eprXML = XmlUtils.getElement((Node)xml, (QName)WsnConstants.CONSUMER_QNAME);
        if (eprXML == null) {
            throw new NullPointerException(_MESSAGES.get("NullConsumerElement"));
        }
        try {
            this._consumer = new EndpointReference(eprXML);
        }
        catch (SoapFault error) {
            throw new InvalidMessageFormatFault((Throwable)error);
        }
        Element filterXML = XmlUtils.getElement((Node)xml, (QName)WsnConstants.FILTER_QNAME);
        FilterFactory factory = FilterFactory.getInstance();
        this._filter = factory.newInstance(filterXML);
        Element timeXML = XmlUtils.getElement((Node)xml, (QName)WsnConstants.INIT_TERMINATION_TIME_QNAME);
        try {
            if (timeXML != null) {
                this._terminationTime = XmlUtils.getDate((Element)timeXML);
            }
        }
        catch (ParseException error) {
            Object[] filler = new Object[]{error.getMessage()};
            throw new InvalidMessageFormatFault(_MESSAGES.get("InvalidTerminationTime", filler));
        }
    }

    public Subscribe(EndpointReference consumer, Filter filter, Date terminationTime) {
        if (consumer == null) {
            throw new NullPointerException(_MESSAGES.get("NullConsumerEPR"));
        }
        this._consumer = new EndpointReference(consumer, WsnConstants.CONSUMER_QNAME);
        this._filter = filter;
        this._terminationTime = terminationTime;
    }

    public EndpointReference getConsumerReference() {
        return this._consumer;
    }

    protected String getDialect(String name) {
        return name.indexOf(47) >= 0 ? "http://docs.oasis-open.org/wsn/t-1/TopicExpression/Concrete" : "http://docs.oasis-open.org/wsn/t-1/TopicExpression/Simple";
    }

    public Filter getFilter() {
        return this._filter;
    }

    public Date getTerminationTime() {
        return this._terminationTime;
    }

    public Object[] toArray() {
        return new Object[]{this.getConsumerReference(), this.getFilter(), this.getTerminationTime(), null};
    }

    public Element toXML() {
        return this.toXML(XmlUtils.EMPTY_DOC);
    }

    public Element toXML(Document doc) {
        Date termination;
        if (doc == null) {
            throw new NullPointerException(_MESSAGES.get("NullDocument"));
        }
        Element root = XmlUtils.createElement((Document)doc, (QName)WsnConstants.SUBSCRIBE_QNAME);
        EndpointReference consumer = this.getConsumerReference();
        XmlUtils.setElement((Element)root, (QName)WsnConstants.CONSUMER_QNAME, (Object)consumer);
        Filter filter = this.getFilter();
        if (filter != null) {
            XmlUtils.setElement((Element)root, (QName)WsnConstants.FILTER_QNAME, (Object)filter);
        }
        if ((termination = this.getTerminationTime()) != null) {
            XmlUtils.setElement((Element)root, (QName)WsnConstants.INIT_TERMINATION_TIME_QNAME, (Object)termination);
        }
        return root;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

