/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.ws.notification.topics.impl;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.xml.namespace.QName;
import org.apache.muse.util.StringUtils;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.notification.faults.InvalidTopicExpressionFault;
import org.apache.muse.ws.notification.topics.Topic;
import org.apache.muse.ws.notification.topics.TopicNamespace;
import org.apache.muse.ws.notification.topics.TopicPathExpression;
import org.apache.muse.ws.notification.topics.TopicSet;

public class ConcretePathExpression
implements TopicPathExpression {
    private static Messages _MESSAGES = MessagesFactory.get((Object)(class$org$apache$muse$ws$notification$topics$impl$ConcretePathExpression == null ? (class$org$apache$muse$ws$notification$topics$impl$ConcretePathExpression = ConcretePathExpression.class$("org.apache.muse.ws.notification.topics.impl.ConcretePathExpression")) : class$org$apache$muse$ws$notification$topics$impl$ConcretePathExpression));
    private QName _topicPath = null;
    private TopicNamespace _topicSpace = null;
    static /* synthetic */ Class class$org$apache$muse$ws$notification$topics$impl$ConcretePathExpression;

    public ConcretePathExpression(Topic topic) {
        if (topic == null) {
            throw new NullPointerException(_MESSAGES.get("NullTopic"));
        }
        this._topicSpace = topic.getTopicNamespace();
        this._topicPath = this.createTopicPath(this._topicSpace, topic);
    }

    public ConcretePathExpression(TopicNamespace topicSpace, QName topicPath) throws InvalidTopicExpressionFault {
        if (topicSpace == null) {
            throw new NullPointerException(_MESSAGES.get("NullTopicSpace"));
        }
        if (topicPath == null) {
            throw new NullPointerException(_MESSAGES.get("NullTopicPath"));
        }
        this._topicSpace = topicSpace;
        this._topicPath = topicPath;
        String topicNS = topicPath.getNamespaceURI();
        String targetNS = this._topicSpace.getTargetNamespace();
        if (!targetNS.equals(topicNS)) {
            Object[] filler = new Object[]{topicNS, targetNS};
            throw new InvalidTopicExpressionFault(_MESSAGES.get("InvalidTopicNS", filler));
        }
        ConcretePathExpression.validateTopicPath(this._topicPath);
    }

    public ConcretePathExpression(TopicSet topics, QName topicPath) throws InvalidTopicExpressionFault {
        if (topics == null) {
            throw new NullPointerException(_MESSAGES.get("NullTopicSpaceForest"));
        }
        if (topicPath == null) {
            throw new NullPointerException(_MESSAGES.get("NullTopicPath"));
        }
        this._topicPath = topicPath;
        String uri = this._topicPath.getNamespaceURI();
        this._topicSpace = topics.getTopicNamespace(uri);
        if (this._topicSpace == null) {
            Object[] filler = new Object[]{uri};
            throw new InvalidTopicExpressionFault(_MESSAGES.get("InvalidTopicSpaceNS", filler));
        }
        String topicNS = topicPath.getNamespaceURI();
        String targetNS = this._topicSpace.getTargetNamespace();
        if (!targetNS.equals(topicNS)) {
            Object[] filler = new Object[]{topicNS, targetNS};
            throw new InvalidTopicExpressionFault(_MESSAGES.get("InvalidTopicNS", filler));
        }
        ConcretePathExpression.validateTopicPath(this._topicPath);
    }

    private QName createTopicPath(TopicNamespace topicSpace, Topic topic) {
        String namespace = topicSpace.getTargetNamespace();
        LinkedList<String> nodes = new LinkedList<String>();
        String name = topic.getName();
        int totalSize = name.length();
        nodes.add(name);
        for (Topic parent = topic.getParentTopic(); parent != null; parent = parent.getParentTopic()) {
            name = parent.getName();
            totalSize += name.length();
            nodes.addFirst(name);
        }
        StringBuffer buffer = new StringBuffer(totalSize);
        Iterator i = nodes.iterator();
        while (i.hasNext()) {
            buffer.append(i.next());
            if (!i.hasNext()) continue;
            buffer.append('/');
        }
        return new QName(namespace, buffer.toString(), "topic");
    }

    public QName getTopicPath() {
        return this._topicPath;
    }

    public TopicNamespace getTopicSpace() {
        return this._topicSpace;
    }

    public ListIterator iterator() {
        String[] nodes = StringUtils.split((String)this._topicPath.getLocalPart(), (String)"/");
        return new ConcretePathIterator(this._topicSpace, nodes);
    }

    public Topic resolve() {
        ListIterator i = this.iterator();
        Topic topic = null;
        while (i.hasNext()) {
            topic = (Topic)i.next();
            if (topic != null) continue;
            return null;
        }
        return topic;
    }

    public static void validateTopicPath(QName topicPath) throws InvalidTopicExpressionFault {
        String unqualifiedPath = topicPath.getLocalPart();
        if (unqualifiedPath.indexOf(42) >= 0 || unqualifiedPath.indexOf("//") >= 0) {
            Object[] filler = new Object[]{XmlUtils.toString((QName)topicPath)};
            throw new InvalidTopicExpressionFault(_MESSAGES.get("InvalidConcretePath", filler));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ConcretePathIterator
    implements ListIterator {
        private int _currentNode = 0;
        private Topic _currentTopic = null;
        private String[] _nodes = null;
        private TopicNamespace _root = null;

        public ConcretePathIterator(TopicNamespace root, String[] nodes) {
            this._root = root;
            this._nodes = nodes;
        }

        public void add(Object item) {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() {
            return this._currentNode < this._nodes.length;
        }

        public boolean hasPrevious() {
            return this._currentNode > 0;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new IllegalStateException();
            }
            String name = this._nodes[this._currentNode++];
            this._currentTopic = this._currentTopic == null ? this._root.getTopic(name) : this._currentTopic.getTopic(name);
            return this._currentTopic;
        }

        public int nextIndex() {
            return this._currentNode;
        }

        public Object previous() {
            if (!this.hasPrevious()) {
                throw new IllegalStateException();
            }
            --this._currentNode;
            return this._currentTopic.getParentTopic();
        }

        public int previousIndex() {
            return this._currentNode - 1;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void set(Object item) {
            throw new UnsupportedOperationException();
        }
    }
}

