/*******************************************************************************
 * Copyright (c) 2007, 2008 CA, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     CA Inc. - initial API and implementation
 *******************************************************************************/
dojo.provide("org.eclipse.cosmos.provisional.dr.ps.components.widget.RegisterDialog");
dojo.require("org.eclipse.cosmos.provisional.dr.ps.components.utility.common");
dojo.require("dijit.Dialog");
dojo.require("dijit.form.Button");
dojo.require("dijit.form.TextBox");
dojo.require("dijit.form.Textarea");

dojo.declare(
   "org.eclipse.cosmos.provisional.dr.ps.components.query.RegisterDialog",
	// superclass	
   org.eclipse.cosmos.provisional.dr.ps.components.utility.BasicQuery,
	{
		labelDialogQuery:"",
		builder:null,
		bindInput: function(data, callbackMethod){
			this.builder = new org.eclipse.cosmos.provisional.dr.ps.components.widget.RegisterDialog({callback: callbackMethod, labelQuery:this.labelDialogQuery, title:this.title, epr:data.epr, UIContext:this.UIContext});
			this.builder.show();		
		},
		render: function(input){
			this.builder.destroy();
			this.builder = null;
			return input;
		}
	}
); 

 dojo.declare(
	"org.eclipse.cosmos.provisional.dr.ps.components.widget.RegisterDialog",
	[dijit._Widget, dijit._Templated, dijit._Container], 
	{
	 	rows:12,
	 	cols:80,
		labelQuery:"",	 	
		templatePath:dojo.moduleUrl("org.eclipse.cosmos.provisional.dr.ps.components.widget", "html/RegisterDialog.html"),
		widgetsInTemplate: true,
		widgetId: "registerDialog",
		gridWidget: null,
		mdrlist: null,
		cmdbfEPR: null,
		mdrEPRs: null,		
		show: function(){
			this.dialogBox.show();
		},
		destroy: function(){
			var tempWidget = dijit.byId("registerGrid");
			if ( tempWidget ){
				tempWidget.destroy();
			}
			
			var tempButton = dijit.byId("regbutton");
			if ( tempButton ){
				tempButton.destroy();
			}
			
			var tempLabel = dijit.byId("reglabel");
			if ( tempLabel ){
				tempLabel.destroy();
			}
			if ( this.dialogBox ){
				this.dialogBox.destroy();
			}
			this.inherited(arguments);
		},
		
		onRegister: function(){
			
			if ( gridWidget.selection.getSelectedCount() > 0 ){
				var selection = gridWidget.selection.getSelected();

				//
				// build the selected MDR EPRs parameters for the outputter
				//
				this.mdrEPRs = "";
				for(var i=0, l=selection.length; i<l; i++){
					var index = selection[i];
					var mdr = mdrlist[index];
					this.mdrEPRs += "&mdrEPR" + i + "=" + mdr[1];
				}
				
				// re-populate the grid with the registration results
				this.UIContext.submitQuery(
						
					// invoke the Status Response outputter to register the items 
					{queryObject:new org.eclipse.cosmos.provisional.dr.ps.components.utility.BasicQuery({queryHandler:"json?service=org/eclipse/cosmos/internal/dr/drs/service/outputter/StatusResponseOutputter&cmdbfEPR="+this.cmdbfEPR + this.mdrEPRs}), 
					onItem:function(response){
											
		                // define the grid view with columns 
		                var regview = {
		                        cells: [[
			                            {name: "instance Id",       field: 0, width: "100px"},
			                            {name: "accepted/declined", field: 1, width: "200px" }
		                          ]
		                        ]
		                };
		                // define the grid layout containing the view
		                var reglayout = [ regview ];
						
						// create a model from the outputter JSON response
						var regmodel = new dojox.grid.data.Table(null, response);
						
						gridWidget.autoHeight = true;	// turn on autoHeight
						gridWidget.autoWidth = true;	// turn on autoWidth
		
						// set the grid model
						gridWidget.setModel( regmodel );
		
						// set the grid layout
						gridWidget.setStructure(reglayout);
								
						// redraw the grid
						gridWidget.render();
								
					}, queryProp:"query"}
				);
				
				var regbutton = dijit.byId("regbutton");
				regbutton.disabled = true;
				
				var reglabel = dijit.byId("reglabel");
				reglabel.setValue("Registration results:");
				
			} else {
				alert("No MDRs have been selected");
			}
		},
		
		onCancel: function(){
			this.dialogBox.onCancel();
			this.destroy();
		},
		
		postMixInProperties: function(){
			//call superclass
			org.eclipse.cosmos.provisional.dr.ps.components.widget.RegisterDialog.superclass.postMixInProperties.apply(this, arguments);
		},
		
		postCreate: function(){
			//call superclass
			org.eclipse.cosmos.provisional.dr.ps.components.widget.RegisterDialog.superclass.postCreate.apply(this, arguments);
			var idLength = this.id.length;
			var index =  this.id.substring(idLength-2, idLength);
			this.dialogBox = dijit.byId(this.widgetId);
			this.cmdbfEPR = this.epr;
						
            // get the grid widget from the page
			gridWidget = dijit.byId("registerGrid");

			// populate the grid with MDRs
			this.UIContext.submitQuery(
					
				// invoke the Broker outputter to return a list of MDRs to the onItem callback function
				{queryObject:new org.eclipse.cosmos.provisional.dr.ps.components.utility.BasicQuery({queryHandler:"json?service=org/eclipse/cosmos/internal/dr/drs/service/outputter/BrokerOutputter&query=mdr&epr="+this.epr}), 
				onItem:function(response){
					
					mdrlist = response;
					
	                // define the grid view with columns 
	                var regview = {
	                        cells: [[
		                            {name: 'MDR', field: 0, width: "300px"}
	                          ]
	                        ]
	                };
	                // define the grid layout containing the view
	                var reglayout = [ regview ];
					
					// create a model from the outputter JSON response
					var regmodel = new dojox.grid.data.Table(null, response);
					
					gridWidget.autoHeight = true;	// turn on autoHeight
					gridWidget.autoWidth = true;	// turn on autoWidth

					// set the grid model
					gridWidget.setModel( regmodel );
	
					// set the grid layout
					gridWidget.setStructure(reglayout);

					// redraw the grid
					gridWidget.render();

				}, queryProp:"query"}
			);
		}
		
	}
);      
