/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.logging.datamgr.client;

import java.net.URI;
import javax.xml.namespace.QName;

import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.Collection;
import java.util.Iterator;

import org.eclipse.cosmos.common.exceptions.CosmosException;
import org.eclipse.cosmos.dc.logging.datamgr.api.ILogEventCollector;
import org.eclipse.cosmos.dc.logging.datamgr.api.ICBEClient;
import org.eclipse.cosmos.dc.dataManager.client.DataManagerClient;

import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.WsaConstants;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Node;

import org.apache.muse.ws.addressing.soap.SoapFault;
import org.eclipse.cosmos.dc.dataManager.client.DataManagerClient;
import org.eclipse.cosmos.dc.dataManager.exception.DataManagerException;
import org.eclipse.tptp.logging.events.cbe.impl.SituationTypeImpl;
import org.eclipse.tptp.logging.events.cbe.CommonBaseEvent;
import org.eclipse.cosmos.dc.logging.datamgr.common.CBESeverityCount;

public class LoggingDataManagerClient extends DataManagerClient implements ILogEventCollector, ICBEClient {

	public LoggingDataManagerClient()
	{
		super(null);
	}
	
	public LoggingDataManagerClient(EndpointReference epr)
	{
		super(epr);
	}
	
	public Collection<String> getDatasets() throws CosmosException {
		String[] ret = null;
		Vector v = null;
		int i = 0;
		
		ret = getLogFileIdentifiers();
		v = new Vector();
		for (i=0;i<ret.length;i++)
			v.add(ret[i]);
		return v;
	}

	public Collection<CommonBaseEvent> getAllCBE(String logfile) throws CosmosException
	{
		Collection<CommonBaseEvent> ret = null;
		Element e = null;
		
		e = getCBEs(logfile);
		
		ret = ProcessCBEs(e);
		
		return ret;
	}
	
	public Collection<CBESeverityCount> getCBECountBySeverity(String logfile) throws CosmosException
	{
		Collection<CommonBaseEvent> cbe = null;
		Element e = null;
		Iterator cbeI = null;
		CommonBaseEvent ev = null;
		String cname = null;
		CBESeverityCount sc = null;
				
		e = getCBEs(logfile);
			
		HashMap<String, CBESeverityCount> componentMap = new HashMap<String, CBESeverityCount>();
		
		cbe = ProcessCBEs(e);
		cbeI = cbe.iterator();
	    while (cbeI.hasNext()) {
	    	ev = (CommonBaseEvent) cbeI.next();
	    	cname = ev.getSourceComponentId().getComponent();
	    	sc = componentMap.get(cname);
	    	if (sc == null) {
	    		sc = new CBESeverityCount(cname);
	    		componentMap.put(cname,sc);
	    	}
	    	if (ev.getSeverity() >= 50) 
	    		sc.setSevereCount(sc.getSevereCount() + 1);
	    	else {
	    		if (ev.getSeverity() >= 30) 
	    			sc.setWarningCount(sc.getWarningCount() + 1);
	    		else
	    			sc.setInfoCount(sc.getInfoCount() + 1);
	    	}
	    }	

	    return componentMap.values();
	}
	
	public Element getCBEs(String logfile) throws CosmosException {
		QName q = ILogEventCollector.GET_ALL_CBE_OP_QNAME;
		String op = ILogEventCollector.GET_ALL_CBE_OP_URI;
		Element e = null;
		String[] ret = null;
		
		QName gq = new QName(ILogEventCollector.NAMESPACE_URI, "logfile", PREFIX);
		e = XmlUtils.createElement(gq);
		e.setTextContent(logfile);
		//setTrace(true);
		try {
			e = SendRequest(op,q,e);
		} catch (DataManagerException ex) {
			throw new CosmosException("Problem sending request",ex);
		}
		
		return e;
	}

	public String[] getCBESeverityCount(String logfile) throws CosmosException {
		// TODO Auto-generated method stub
		return null;
	}

	public String[] getLogFileIdentifiers() throws CosmosException {
		QName q = ILogEventCollector.GET_LOG_ID_OP_QNAME;
		String op = ILogEventCollector.GET_LOG_ID_OP_URI;
		Element e = null;
		String[] ret = null;
		
		try {
			e = SendRequest(op,q,null);
		} catch (DataManagerException ex) {
			throw new CosmosException("Problem sending request",ex);
		}
		
		ret = ProcessLF(e);
		return ret;
	}

	private Element SendRequest(String operation,QName qstr,Element arg) throws DataManagerException
	{
		Element soapBody = XmlUtils.createElement(qstr);
				
		if (arg != null) {
			Element parm = XmlUtils.createElement(ILogEventCollector.GET_ALL_CBE_LOG_FILE_QNAME);
			parm.appendChild(arg);
			soapBody.appendChild(arg);
		}
		//setTrace(true);
		try {
			Element results = invoke(operation, soapBody);
			return results;
		} catch (SoapFault e) {
			throw new DataManagerException(e);
		}
	}
	
	private String[] ProcessLF(Element e) {
		NodeList n = null;
		Element el = null;
		int i = 0;
		String s = null;
		String r = null;
		String[] p = null;
		String[] ret = null;
		int idx = 0;
		
		n = e.getElementsByTagName("dyn:getLogFileIdentifiersResponseType");	
		if (n.getLength() > 0) 
			p = new String[n.getLength()];
		for (i=0;i<n.getLength();i++) {
			if (n.item(i).getNodeType() == Node.ELEMENT_NODE) {
				el = (Element) n.item(i);
				s = XmlUtils.extractText(el);
				if (s.length() > 0) 
					p[idx++] = new String(s);
			}
		}
		ret = new String[idx];
		for (i=0;i<idx;i++)
			ret[i] = new String(p[i]);
		return ret;
	}
	
	private String[] ProcessAllCBE(Element e) {
		NodeList n = null;
		Element el = null;
		int i = 0;
		String s = null;
		String r = null;
		String[] p = null;
		String[] ret = null;
		int idx = 0;
		
		n = e.getElementsByTagName("dyn:getLogFileIdentifiersResponseType");	
		if (n.getLength() > 0) 
			p = new String[n.getLength()];
		for (i=0;i<n.getLength();i++) {
			if (n.item(i).getNodeType() == Node.ELEMENT_NODE) {
				el = (Element) n.item(i);
				s = XmlUtils.extractText(el);
				if (s.length() > 0) {
					r = Parse(s);
					if (r != null)
						p[idx++] = new String(r);
				}	
			}
		}
		ret = new String[idx];
		for (i=0;i<idx;i++)
			ret[i] = new String(p[i]);
		return ret;
	}

	private String Parse(String s)
	{
		return s;
	}
	
	private Collection<CommonBaseEvent> ProcessCBEs(Element e) {
		NodeList n = null;
		Element el = null;
		int i = 0;
		CommonBaseEvent cbe = null;
		Vector<CommonBaseEvent> ret = null;
		
		ret = new Vector<CommonBaseEvent>();
		
		n = e.getElementsByTagName("CommonBaseEvent");	
		for (i=0;i<n.getLength();i++) {
			if (n.item(i).getNodeType() == Node.ELEMENT_NODE) {
				el = (Element) n.item(i);
				cbe = CreateCBE(el);
				ret.add(cbe);
			}
		}
		return ret;
	}

	private CommonBaseEvent CreateCBE(Element e)
	{
		CBEImpl c = null;
		
		c = new CBEImpl();
		PopulateBase(c,e);
		PopulateExtended(c,e);
		PopulateSourceComponent(c,e);
		PopulateSituation(c,e);

		return c;
	}

	private void PopulateBase(CBEImpl c,Element e)
	{
		if (e.hasAttribute("creationTime")) 
			c.setCreationTime(e.getAttribute("creationTime"));
		
		if (e.hasAttribute("globalInstanceId"))
			c.setGlobalInstanceId(e.getAttribute("globalInstanceId"));

		//if (e.hasAttribute("elapsedTime"))
		//	c.setElapsedTime(newElapsedTime) <long>
		
		if (e.hasAttribute("extensionName"))
			c.setExtensionName(e.getAttribute("extensionName"));

		if (e.hasAttribute("localInstanceId"))
			c.setLocalInstanceId(e.getAttribute("localInstanceId"));

		if (e.hasAttribute("msg"))
			c.setMsg(e.getAttribute("msg"));
		
		if (e.hasAttribute("priority")) {
			String s = e.getAttribute("priority");
			short sh = Short.valueOf(s).shortValue();
			c.setPriority(sh);
		}

		if (e.hasAttribute("repeatCount")) {
			String s = e.getAttribute("repeatCount");
			short sh = Short.valueOf(s).shortValue();
			c.setRepeatCount(sh);
		}
		
		if (e.hasAttribute("sequenceNumber")) {
			String s = e.getAttribute("sequenceNumber");
			long l = Long.valueOf(s).longValue();
			c.setSequenceNumber(l);
		}
		
		if (e.hasAttribute("severity")) {
			String s = e.getAttribute("severity");
			short sh = Short.valueOf(s).shortValue();
			c.setSeverity(sh);
		}
		
	}
	private void PopulateSourceComponent(CBEImpl c,Element el)
	{
		NodeList n = null;
		Element e = null;
		
		String application = new String("");
        String component = new String("");
        String subComponent = new String("");
        String componentType = new String("");
        String componentIdType = new String("");
        String location = new String("");
        String locationType = new String("");
        
        n = el.getElementsByTagName("sourceComponentId");
        e = (Element) n.item(0);
        
        if (e.hasAttribute("application"))
        	application = e.getAttribute("application");
        
        if (e.hasAttribute("component"))
        	component = e.getAttribute("component");
        
        if (e.hasAttribute("subComponent"))
        	subComponent = e.getAttribute("subComponent");
        
        if (e.hasAttribute("componentType"))
        	componentType = e.getAttribute("ComponentType");
        
        if (e.hasAttribute("ComponentIdType"))
        	componentIdType = e.getAttribute("ComponentIdType");
        
        if (e.hasAttribute("location"))
        	location = e.getAttribute("location");
        
        if (e.hasAttribute("locationType"))
        	locationType = e.getAttribute("locationType");
        
        c.setSourceComponentId(application,component,subComponent,componentType,componentIdType,location,locationType);
	}
	
	private void PopulateSituation(CBEImpl c,Element ele)
	{
		NodeList ns = null;
		NodeList n = null;
		Element el = null;
		CBESImpl s = null;
		Element e = null;
		
		s = new CBESImpl();
		ns = ele.getElementsByTagName("situation");
		e = (Element) ns.item(0);
		
		String cat = e.getAttribute("categoryName");
		
		s.setCategoryName(cat);
		n = e.getElementsByTagName("situationType");
		el = (Element) n.item(0);
		String reason = el.getAttribute("reasoningScope");
		if (cat.equals("AvailableSituation")) {
			String available = el.getAttribute("availabilityDisposition");
			String operation = el.getAttribute("operationDisposition");
			String process = el.getAttribute("processingDisposition");
			
			s.setAvailableSituation(reason, available,operation,process);
		}
		if (cat.equals("ConfigureSituation")) {
			String success = el.getAttribute("successDisposition");
		
			s.setConfigureSituation(reason, success);
		}
		if (cat.equals("ConnectSituation")) {
			String success = el.getAttribute("successDisposition");
			String situation = el.getAttribute("situationDisposition");
			
			s.setConnectSituation(reason, situation,success); 
		}
		if (cat.equals("CreateSituation")) {
			String success = el.getAttribute("successDisposition");
			
			s.setCreateSituation(reason, success); 
		}
		if (cat.equals("DependencySituation")) {
			String depend = el.getAttribute("dependencyDisposition");
			
			s.setDependencySituation(reason, depend); 
		}
		if (cat.equals("DestroySituation")) {
			String success = el.getAttribute("successDisposition");
			
			s.setDestroySituation(reason, success);  
		}
		if (cat.equals("FeatureSituation")) {
			String feature = el.getAttribute("featureDisposition");
			
			s.setFeatureSituation(reason, feature);  
		}
		if (cat.equals("OtherSituation")) {
			String any = el.getAttribute("any");
			
			s.setOtherSituation(reason, any);  
		}
		if (cat.equals("ReportSituation")) {
			String rcat = el.getAttribute("ReportCategory");
			
			s.setReportSituation(reason, rcat);  
		}
		if (cat.equals("RequestSituation")) {
			String qualifier = el.getAttribute("situationQualifier");
			String success = el.getAttribute("successDisposition");
			
			s.setRequestSituation(reason,qualifier,success);
		}
		if (cat.equals("StartSituation")) {
			String qualifier = el.getAttribute("situationQualifier");
			String success = el.getAttribute("successDisposition");
			
			s.setStartSituation(reason,qualifier,success);
		}
		if (cat.equals("StopSituation")) {
			String qualifier = el.getAttribute("situationQualifier");
			String success = el.getAttribute("successDisposition");
			
			s.setStopSituation(reason,qualifier,success); 
		}
		
		c.setSituation(s);
	}
	
	private void PopulateExtended(CBEImpl c,Element e) 
	{
		NodeList n = null;
		NodeList nv = null;
		Element el = null;
		Element v = null;
		int i = 0;
		String t = null;
		String value;
		short svalue;
		int ivalue;
		String name = null;
		
		n = e.getElementsByTagName("extendedDataElements");
		for (i=0;i<n.getLength();i++)
			if (n.item(i).getNodeType() == Node.ELEMENT_NODE) {
				el = (Element) n.item(i);
				t = el.getAttribute("type");
				name = el.getAttribute("name");
				if (!t.equals("string") && !t.equals("short") && !t.equals("int"))
					System.out.println("Unknown type" + t);
				else {
					nv = el.getElementsByTagName("values");
					v = (Element) nv.item(0);
					value = XmlUtils.extractText(v);
					if (t.equals("short")) {
					  svalue = Short.valueOf(value).shortValue();
					  c.addExtendedDataElementWithShortValue(name, svalue);
					}
					else {
						if (t.equals("int")) {
							ivalue = Integer.valueOf(value).intValue();
							c.addExtendedDataElementWithIntValue(name,ivalue);
						}
						else
							c.addExtendedDataElement(name,value);
					}
				}
			}	
	}
}

