/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.util.manifest;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.nls.Messages;
import org.eclipse.datatools.connectivity.oda.util.manifest.DataSetType;
import org.eclipse.datatools.connectivity.oda.util.manifest.ExtensionManifest;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestUtil;

public class ManifestExplorer {
    private static ManifestExplorer sm_instance;
    private static Logger sm_logger;
    private Hashtable m_manifestsById;
    private static final String DTP_ODA_EXT_POINT = "org.eclipse.datatools.connectivity.oda.dataSource";
    private static final String PACKAGE_NAME = "org.eclipse.datatools.connectivity.oda.util.manifest";
    static final /* synthetic */ boolean $assertionsDisabled;

    public static ManifestExplorer getInstance() {
        if (sm_instance == null) {
            sm_instance = new ManifestExplorer();
        }
        return sm_instance;
    }

    public static void releaseInstance() {
        sm_instance = null;
        sm_logger = null;
    }

    static Logger getLogger() {
        if (sm_logger == null) {
            sm_logger = Logger.getLogger(PACKAGE_NAME);
        }
        return sm_logger;
    }

    private ManifestExplorer() {
    }

    public void refresh() {
        this.m_manifestsById = null;
    }

    private Hashtable getCachedManifests() {
        if (this.m_manifestsById == null) {
            this.m_manifestsById = new Hashtable();
        }
        return this.m_manifestsById;
    }

    public Properties getDataSourceIdentifiers() {
        IExtension[] extensions = this.getDataSourceExtensions();
        int length = extensions == null ? 0 : extensions.length;
        Properties extensionIds = new Properties();
        for (int i = 0; i < length; ++i) {
            IExtension extension = extensions[i];
            try {
                IConfigurationElement dsElement = ManifestExplorer.getDataSourceElement(extension);
                String dataSourceId = dsElement.getAttribute("id");
                String dataSourceDisplayName = ManifestExplorer.getElementDisplayName(dsElement);
                extensionIds.setProperty(dataSourceId, dataSourceDisplayName);
                continue;
            }
            catch (OdaException ex) {
                ManifestExplorer.getLogger().log(Level.WARNING, "Ignoring invalid extension.", ex);
            }
        }
        return extensionIds;
    }

    public ExtensionManifest getExtensionManifest(String dataSourceId) throws OdaException {
        ExtensionManifest manifest = this.getExtensionManifest(dataSourceId, DTP_ODA_EXT_POINT);
        if (manifest != null) {
            return manifest;
        }
        throw new IllegalArgumentException(dataSourceId);
    }

    public ExtensionManifest getExtensionManifest(String dataSourceId, String extensionPoint) throws OdaException {
        if (dataSourceId == null || dataSourceId.length() == 0) {
            throw new IllegalArgumentException(dataSourceId);
        }
        if (extensionPoint == null || extensionPoint.length() == 0) {
            throw new IllegalArgumentException(extensionPoint);
        }
        ExtensionManifest aManifest = (ExtensionManifest)this.getCachedManifests().get(dataSourceId);
        if (aManifest != null) {
            return aManifest;
        }
        IExtension[] extensions = ManifestExplorer.getExtensions(extensionPoint);
        IExtension dataSourceExtn = this.findExtension(dataSourceId, extensions);
        if (dataSourceExtn == null) {
            return null;
        }
        return this.getExtensionManifest(dataSourceExtn);
    }

    private ExtensionManifest getExtensionManifest(IExtension dataSourceExtn) throws OdaException {
        if (dataSourceExtn == null) {
            throw new OdaException(new IllegalArgumentException(Messages.manifest_nullArgument));
        }
        IConfigurationElement dataSourceElement = ManifestExplorer.getDataSourceElement(dataSourceExtn);
        if (!$assertionsDisabled && dataSourceElement == null) {
            throw new AssertionError();
        }
        String dataSourceId = dataSourceElement.getAttribute("id");
        ExtensionManifest aManifest = (ExtensionManifest)this.getCachedManifests().get(dataSourceId);
        if (aManifest != null) {
            return aManifest;
        }
        aManifest = new ExtensionManifest(dataSourceExtn);
        this.getCachedManifests().put(dataSourceId, aManifest);
        return aManifest;
    }

    public ExtensionManifest[] getExtensionManifests() {
        return this.getExtensionManifests(DTP_ODA_EXT_POINT);
    }

    public ExtensionManifest[] getExtensionManifests(String extensionPoint) {
        Filter aFilter = ManifestExplorer.createFilter();
        aFilter.setMissingDataSetTypesFilter(true);
        aFilter.setDeprecatedFilter(false);
        return this.getExtensionManifests(extensionPoint, aFilter);
    }

    public ExtensionManifest[] getExtensionManifests(boolean includesAllExtensions) {
        return this.getExtensionManifests(DTP_ODA_EXT_POINT, includesAllExtensions);
    }

    public ExtensionManifest[] getExtensionManifests(String extensionPoint, boolean includesAllExtensions) {
        Filter aFilter = ManifestExplorer.createFilter();
        aFilter.setMissingDataSetTypesFilter(!includesAllExtensions);
        aFilter.setDeprecatedFilter(false);
        return this.getExtensionManifests(extensionPoint, aFilter);
    }

    public ExtensionManifest[] getExtensionManifests(String extensionPoint, Filter collectionFilter) {
        IExtension[] extensions = ManifestExplorer.getExtensions(extensionPoint);
        int length = extensions == null ? 0 : extensions.length;
        ArrayList<ExtensionManifest> manifestList = new ArrayList<ExtensionManifest>(length);
        for (int i = 0; i < length; ++i) {
            IExtension dataSourceExtn = extensions[i];
            try {
                ExtensionManifest manifest = this.getExtensionManifest(dataSourceExtn);
                boolean includeExtension = true;
                if (collectionFilter != null) {
                    if (collectionFilter.isMissingDataSetTypesFilterOn() && manifest.getDataSetTypeCount() <= 0) {
                        includeExtension = false;
                    }
                    if (collectionFilter.isDeprecatedFilterOn() && manifest.isDeprecated()) {
                        includeExtension = false;
                    }
                }
                if (!includeExtension) continue;
                manifestList.add(manifest);
                continue;
            }
            catch (OdaException ex) {
                ManifestExplorer.getLogger().log(Level.WARNING, "Ignoring invalid extension.", ex);
            }
        }
        int numOfValidExtensions = manifestList.size();
        return manifestList.toArray(new ExtensionManifest[numOfValidExtensions]);
    }

    private IExtension findExtension(String dataSourceId, IExtension[] extensions) throws OdaException {
        int length = extensions == null ? 0 : extensions.length;
        for (int i = 0; i < length; ++i) {
            IExtension extension = extensions[i];
            String extnDataSourceId = null;
            try {
                IConfigurationElement dataSourceElement = ManifestExplorer.getDataSourceElement(extension);
                extnDataSourceId = dataSourceElement.getAttribute("id");
            }
            catch (OdaException ex) {
                ManifestExplorer.getLogger().log(Level.WARNING, "Ignoring invalid extension.", ex);
                continue;
            }
            if (extnDataSourceId == null || !extnDataSourceId.equalsIgnoreCase(dataSourceId)) continue;
            return extension;
        }
        return null;
    }

    private IExtension[] getDataSourceExtensions() {
        return ManifestExplorer.getExtensions(DTP_ODA_EXT_POINT);
    }

    public static IExtension[] getExtensions(String extPoint) {
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        if (pluginRegistry == null) {
            return null;
        }
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint(extPoint);
        if (extensionPoint == null) {
            return null;
        }
        return extensionPoint.getExtensions();
    }

    static IConfigurationElement getDataSourceElement(IExtension extension) throws OdaException {
        return ManifestUtil.getNamedElement(extension, "dataSource");
    }

    public static IConfigurationElement getNamedElement(IExtension extension, String elementName) throws OdaException {
        return ManifestUtil.getNamedElement(extension, elementName);
    }

    public static IConfigurationElement[] getNamedElements(IExtension extension, String elementName) throws OdaException {
        return ManifestUtil.getNamedElements(extension, elementName);
    }

    public static IConfigurationElement[] getNamedElements(IExtension extension, String elementName, String requiredAttributeName) throws OdaException {
        return ManifestUtil.getNamedElements(extension, elementName, requiredAttributeName);
    }

    static Hashtable getDataSetElements(IExtension extension, String dataSourceElementId) throws OdaException {
        IConfigurationElement[] configElements = ManifestUtil.getNamedElements(extension, "dataSet");
        Hashtable<String, DataSetType> dataSetElements = new Hashtable<String, DataSetType>();
        int numConfigElements = configElements.length;
        for (int i = 0; i < numConfigElements; ++i) {
            IConfigurationElement configElement = configElements[i];
            String dataSetTypeId = configElement.getAttribute("id");
            dataSetElements.put(dataSetTypeId, new DataSetType(configElement));
        }
        if (dataSetElements.size() < 1) {
            String msg = Messages.bind((String)Messages.manifest_NO_DATA_SET_TYPES_DEFINED, (Object)dataSourceElementId);
            if (numConfigElements >= 1) {
                throw new OdaException(msg);
            }
            ManifestExplorer.getLogger().log(Level.CONFIG, msg);
        }
        return dataSetElements;
    }

    static String getElementDisplayName(IConfigurationElement dsElement) {
        String displayName = dsElement.getAttribute("defaultDisplayName");
        if ((displayName == null || displayName.length() == 0) && (displayName = dsElement.getAttribute("name")) == null) {
            displayName = dsElement.getAttribute("id");
        }
        return displayName;
    }

    public int getDefaultOdaDataTypeCode(int nativeTypeCode, String odaDataSourceId, String dataSetType) {
        DataSetType setType = null;
        try {
            ExtensionManifest manifest = this.getExtensionManifest(odaDataSourceId);
            if (manifest == null) {
                return 0;
            }
            setType = manifest.getDataSetType(dataSetType);
        }
        catch (OdaException e) {
            // empty catch block
        }
        if (setType == null) {
            return 0;
        }
        return setType.getDefaultOdaDataTypeCode(nativeTypeCode);
    }

    public static Filter createFilter() {
        return ManifestExplorer.getInstance().new Filter();
    }

    static {
        $assertionsDisabled = !ManifestExplorer.class.desiredAssertionStatus();
        sm_instance = null;
        sm_logger = null;
    }

    public class Filter {
        private boolean m_noDataSetTypes = false;
        private boolean m_deprecated = false;

        Filter() {
        }

        public void setMissingDataSetTypesFilter(boolean exclude) {
            this.m_noDataSetTypes = exclude;
        }

        public void setDeprecatedFilter(boolean exclude) {
            this.m_deprecated = exclude;
        }

        public boolean isMissingDataSetTypesFilterOn() {
            return this.m_noDataSetTypes;
        }

        public boolean isDeprecatedFilterOn() {
            return this.m_deprecated;
        }
    }
}

