/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.re;

import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.report.engine.extension.ReportItemQueryBase;
import org.eclipse.birt.report.item.crosstab.core.CrosstabException;
import org.eclipse.birt.report.item.crosstab.core.ICrosstabConstants;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.i18n.Messages;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabQueryUtil;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.MapRule;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;

public class CrosstabReportItemQuery
extends ReportItemQueryBase
implements ICrosstabConstants {
    private static Logger logger;
    private CrosstabReportItemHandle crosstabItem;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.item.crosstab.core.re.CrosstabReportItemQuery");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    public void setModelObject(ExtendedItemHandle modelHandle) {
        super.setModelObject(modelHandle);
        try {
            this.crosstabItem = (CrosstabReportItemHandle)modelHandle.getReportItem();
        }
        catch (ExtendedElementException extendedElementException) {
            logger.log(Level.SEVERE, Messages.getString("CrosstabReportItemQuery.error.crosstab.loading"));
            this.crosstabItem = null;
        }
    }

    public IDataQueryDefinition[] createReportQueries(IDataQueryDefinition parent) throws BirtException {
        if (this.crosstabItem == null) {
            throw new CrosstabException(this.modelHandle == null ? null : this.modelHandle.getElement(), Messages.getString("CrosstabReportItemQuery.error.query.building"));
        }
        ICubeQueryDefinition cubeQuery = CrosstabQueryUtil.createCubeQuery(this.crosstabItem, parent, true, true, true, true, true, true);
        String emptyValue = this.crosstabItem.getEmptyCellValue();
        if (this.context != null) {
            LevelViewHandle lv;
            DimensionViewHandle dv;
            int j;
            int i = 0;
            while (i < this.crosstabItem.getMeasureCount()) {
                MeasureViewHandle mv = this.crosstabItem.getMeasure(i);
                this.processChildQuery((IDataQueryDefinition)cubeQuery, mv.getCell(), emptyValue);
                this.processChildQuery((IDataQueryDefinition)cubeQuery, mv.getHeader(), emptyValue);
                j = 0;
                while (j < mv.getAggregationCount()) {
                    this.processChildQuery((IDataQueryDefinition)cubeQuery, mv.getAggregationCell(j), emptyValue);
                    ++j;
                }
                ++i;
            }
            if (this.crosstabItem.getDimensionCount(0) > 0) {
                i = 0;
                while (i < this.crosstabItem.getDimensionCount(0)) {
                    dv = this.crosstabItem.getDimension(0, i);
                    j = 0;
                    while (j < dv.getLevelCount()) {
                        lv = dv.getLevel(j);
                        this.processChildQuery((IDataQueryDefinition)cubeQuery, lv.getCell(), emptyValue);
                        this.processChildQuery((IDataQueryDefinition)cubeQuery, lv.getAggregationHeader(), emptyValue);
                        ++j;
                    }
                    ++i;
                }
            }
            if (this.crosstabItem.getDimensionCount(1) > 0) {
                i = 0;
                while (i < this.crosstabItem.getDimensionCount(1)) {
                    dv = this.crosstabItem.getDimension(1, i);
                    j = 0;
                    while (j < dv.getLevelCount()) {
                        lv = dv.getLevel(j);
                        this.processChildQuery((IDataQueryDefinition)cubeQuery, lv.getCell(), emptyValue);
                        this.processChildQuery((IDataQueryDefinition)cubeQuery, lv.getAggregationHeader(), emptyValue);
                        ++j;
                    }
                    ++i;
                }
            }
            this.processChildQuery((IDataQueryDefinition)cubeQuery, this.crosstabItem.getGrandTotal(0), emptyValue);
            this.processChildQuery((IDataQueryDefinition)cubeQuery, this.crosstabItem.getGrandTotal(1), emptyValue);
        }
        return new IDataQueryDefinition[]{cubeQuery};
    }

    private void processChildQuery(IDataQueryDefinition parent, CrosstabCellHandle cell, String emptyVlaue) {
        if (cell != null) {
            Iterator itr = cell.getContents().iterator();
            while (itr.hasNext()) {
                ReportElementHandle handle = (ReportElementHandle)itr.next();
                if (emptyVlaue != null && handle instanceof DataItemHandle) {
                    DataItemHandle dataHandle = (DataItemHandle)handle;
                    MapRule rule = StructureFactory.createMapRule();
                    rule.setTestExpression(ExpressionUtil.createJSDataExpression((String)dataHandle.getResultSetColumn()));
                    rule.setOperator("is-null");
                    rule.setDisplay(emptyVlaue);
                    PropertyHandle mapHandle = dataHandle.getPropertyHandle("mapRules");
                    try {
                        mapHandle.addItem((IStructure)rule);
                    }
                    catch (SemanticException e) {
                        logger.log(Level.SEVERE, Messages.getString("CrosstabReportItemQuery.error.register.empty.cell.value"), e);
                    }
                }
                this.context.createQuery(parent, handle);
            }
        }
    }
}

