/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ParameterGroupHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.CascadingParameterGroup;
import org.eclipse.birt.report.model.elements.DataSet;
import org.eclipse.birt.report.model.elements.interfaces.ICascadingParameterGroupModel;

public class CascadingParameterGroupHandle
extends ParameterGroupHandle
implements ICascadingParameterGroupModel {
    public CascadingParameterGroupHandle(Module module, CascadingParameterGroup element) {
        super(module, element);
    }

    public DataSetHandle getDataSet() {
        DataSet dataSet = ((CascadingParameterGroup)this.getElement()).getDataSetElement(this.module);
        if (dataSet == null) {
            return null;
        }
        return (DataSetHandle)dataSet.getHandle(dataSet.getRoot());
    }

    public void setDataSet(DataSetHandle handle) throws SemanticException {
        if (handle == null) {
            this.setStringProperty("dataSet", null);
        } else {
            ModuleHandle moduleHandle = handle.getRoot();
            String valueToSet = handle.getElement().getFullName();
            if (moduleHandle instanceof LibraryHandle) {
                String namespace = ((LibraryHandle)moduleHandle).getNamespace();
                valueToSet = StringUtil.buildQualifiedReference(namespace, valueToSet);
            }
            this.setStringProperty("dataSet", valueToSet);
        }
    }

    public void setPromptText(String promptValue) throws SemanticException {
        this.setStringProperty("promptText", promptValue);
    }

    public String getPromptText() {
        return this.getStringProperty("promptText");
    }

    public void setDataSetMode(String mode) throws SemanticException {
        this.setStringProperty("dataSetMode", mode);
    }

    public String getDataSetMode() {
        return this.getStringProperty("dataSetMode");
    }
}

